/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.rowcreator.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.seasar.robot.dbflute.helper.StringKeyMap;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.robot.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRelationKey;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRelationRowCache;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRelationRowCreationResource;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRelationSelector;

public abstract class TnRelationRowCreatorImpl
implements TnRelationRowCreator {
    @Override
    public Object createRelationRow(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, TnRelationKey relKey, Map<String, Map<String, TnPropertyMapping>> relPropCache, TnRelationRowCache relRowCache, TnRelationSelector relSelector) throws SQLException {
        TnRelationRowCreationResource res = this.createResourceForRow(rs, rpt, selectColumnMap, selectIndexMap, relKey, relPropCache, relRowCache, relSelector);
        return this.createRelationRow(res);
    }

    protected TnRelationRowCreationResource createResourceForRow(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, TnRelationKey relKey, Map<String, Map<String, TnPropertyMapping>> relPropCache, TnRelationRowCache relRowCache, TnRelationSelector relSelector) throws SQLException {
        TnRelationRowCreationResource res = new TnRelationRowCreationResource();
        res.setResultSet(rs);
        res.setRelationPropertyType(rpt);
        res.setSelectColumnMap(selectColumnMap);
        res.setSelectIndexMap(selectIndexMap);
        res.setRelationKey(relKey);
        res.setRelPropCache(relPropCache);
        res.setRelRowCache(relRowCache);
        res.setRelationSelector(relSelector);
        res.setBaseSuffix("");
        res.setRelationNoSuffix(rpt.getRelationNoSuffixPart());
        res.setLimitRelationNestLevel(this.getLimitRelationNestLevel());
        res.setCurrentRelationNestLevel(1);
        res.setCreateDeadLink(this.isCreateDeadLink());
        return res;
    }

    protected Object createRelationRow(TnRelationRowCreationResource res) throws SQLException {
        if (!res.hasPropertyCacheElement()) {
            return null;
        }
        this.setupRelationKeyValue(res);
        this.setupRelationAllValue(res);
        return res.getRow();
    }

    protected abstract void setupRelationKeyValue(TnRelationRowCreationResource var1);

    protected abstract void setupRelationAllValue(TnRelationRowCreationResource var1) throws SQLException;

    protected boolean isValidRelationPerPropertyLoop(TnRelationRowCreationResource res) throws SQLException {
        return true;
    }

    protected boolean isValidRelationAfterPropertyLoop(TnRelationRowCreationResource res) throws SQLException {
        if (res.isCreateDeadLink()) {
            return true;
        }
        return res.hasValidValueCount();
    }

    @Override
    public Map<String, Map<String, TnPropertyMapping>> createPropertyCache(Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, TnRelationSelector relSelector, TnBeanMetaData baseBmd) throws SQLException {
        Map<String, Map<String, TnPropertyMapping>> relPropCache = this.newRelationPropertyCache();
        List<TnRelationPropertyType> relationPropertyTypeList = baseBmd.getRelationPropertyTypeList();
        for (TnRelationPropertyType rpt : relationPropertyTypeList) {
            String baseSuffix = "";
            String relationNoSuffix = rpt.getRelationNoSuffixPart();
            TnRelationRowCreationResource res = this.createResourceForPropertyCache(rpt, selectColumnMap, selectIndexMap, relPropCache, relSelector, "", relationNoSuffix, this.getLimitRelationNestLevel());
            this.setupPropertyCache(res);
        }
        return relPropCache;
    }

    protected Map<String, Map<String, TnPropertyMapping>> newRelationPropertyCache() {
        return StringKeyMap.createAsCaseInsensitive();
    }

    protected TnRelationRowCreationResource createResourceForPropertyCache(TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, Map<String, Map<String, TnPropertyMapping>> relPropCache, TnRelationSelector relSelector, String baseSuffix, String relationNoSuffix, int limitRelationNestLevel) throws SQLException {
        TnRelationRowCreationResource res = new TnRelationRowCreationResource();
        res.setRelationPropertyType(rpt);
        res.setSelectColumnMap(selectColumnMap);
        res.setSelectIndexMap(selectIndexMap);
        res.setRelPropCache(relPropCache);
        res.setRelationSelector(relSelector);
        res.setBaseSuffix(baseSuffix);
        res.setRelationNoSuffix(relationNoSuffix);
        res.setLimitRelationNestLevel(limitRelationNestLevel);
        res.setCurrentRelationNestLevel(1);
        return res;
    }

    protected abstract void setupPropertyCache(TnRelationRowCreationResource var1) throws SQLException;

    protected void setupPropertyCacheElement(TnRelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        if (!res.containsSelectColumn(columnName)) {
            return;
        }
        res.savePropertyCacheElement();
    }

    protected boolean isTargetRelation(TnRelationRowCreationResource res) throws SQLException {
        return true;
    }

    protected abstract boolean isCreateDeadLink();

    protected abstract int getLimitRelationNestLevel();
}

