/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.robot.dbflute.s2dao.metadata.impl.TnPropertyTypeImpl;

public class TnRelationPropertyTypeImpl
extends TnPropertyTypeImpl
implements TnRelationPropertyType {
    protected final int _relationNo;
    protected final String _relationNoSuffixPart;
    protected final String[] _myKeys;
    protected final String[] _yourKeys;
    protected final TnBeanMetaData _myBeanMetaData;
    protected final TnBeanMetaData _yourBeanMetaData;
    protected final List<TnPropertyType> _uniquePropertyTypeList;
    protected final boolean _hasSimpleUniqueKey;
    protected final boolean _hasCompoundUniqueKey;
    protected final TnPropertyType _simpleUniquePropertyType;

    public TnRelationPropertyTypeImpl(DfPropertyDesc propertyDesc, int relationNo, String[] myKeys, String[] yourKeys, TnBeanMetaData myBeanMetaData, TnBeanMetaData yourBeanMetaData) {
        super(propertyDesc);
        this._relationNo = relationNo;
        this._relationNoSuffixPart = this.buildRelationNoSuffixPart(relationNo);
        this._myKeys = myKeys;
        this._yourKeys = yourKeys;
        this._myBeanMetaData = myBeanMetaData;
        this._yourBeanMetaData = yourBeanMetaData;
        this._uniquePropertyTypeList = this.deriveUniqueKeys(yourKeys, yourBeanMetaData);
        this._hasSimpleUniqueKey = this._uniquePropertyTypeList.size() == 1;
        this._hasCompoundUniqueKey = this._uniquePropertyTypeList.size() >= 2;
        this._simpleUniquePropertyType = this._hasSimpleUniqueKey ? this._uniquePropertyTypeList.get(0) : null;
    }

    protected String buildRelationNoSuffixPart(int relationNo) {
        return "_" + relationNo;
    }

    protected List<TnPropertyType> deriveUniqueKeys(String[] yourKeys, TnBeanMetaData yourBeanMetaData) {
        ArrayList<TnPropertyType> uniquePropertyTypeList;
        DBMeta dbmeta = yourBeanMetaData.getDBMeta();
        if (dbmeta != null && dbmeta.hasPrimaryKey()) {
            UniqueInfo primaryUniqueInfo = dbmeta.getPrimaryUniqueInfo();
            List<ColumnInfo> uniqueColumnList = primaryUniqueInfo.getUniqueColumnList();
            uniquePropertyTypeList = new ArrayList(uniqueColumnList.size());
            for (ColumnInfo columnInfo : uniqueColumnList) {
                TnPropertyType pt = yourBeanMetaData.getPropertyTypeByColumnName(columnInfo.getColumnDbName());
                uniquePropertyTypeList.add(pt);
            }
        } else {
            uniquePropertyTypeList = new ArrayList<TnPropertyType>(yourKeys.length);
            for (String yourKey : yourKeys) {
                TnPropertyType pt = yourBeanMetaData.getPropertyTypeByColumnName(yourKey);
                uniquePropertyTypeList.add(pt);
            }
        }
        return uniquePropertyTypeList;
    }

    @Override
    public int getRelationNo() {
        return this._relationNo;
    }

    @Override
    public String getRelationNoSuffixPart() {
        return this._relationNoSuffixPart;
    }

    @Override
    public int getKeySize() {
        if (this._myKeys.length > 0) {
            return this._myKeys.length;
        }
        return this._yourBeanMetaData.getPrimaryKeySize();
    }

    @Override
    public String getMyKey(int index) {
        if (this._myKeys.length > 0) {
            return this._myKeys[index];
        }
        return this._yourBeanMetaData.getPrimaryKeyDbName(index);
    }

    @Override
    public String getYourKey(int index) {
        if (this._yourKeys.length > 0) {
            return this._yourKeys[index];
        }
        return this._yourBeanMetaData.getPrimaryKeyDbName(index);
    }

    @Override
    public boolean isYourKey(String columnName) {
        for (int i = 0; i < this.getKeySize(); ++i) {
            if (!columnName.equalsIgnoreCase(this.getYourKey(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public TnBeanMetaData getMyBeanMetaData() {
        return this._myBeanMetaData;
    }

    @Override
    public TnBeanMetaData getYourBeanMetaData() {
        return this._yourBeanMetaData;
    }

    @Override
    public List<TnPropertyType> getUniquePropertyTypeList() {
        return this._uniquePropertyTypeList;
    }

    @Override
    public boolean hasSimpleUniqueKey() {
        return this._hasSimpleUniqueKey;
    }

    @Override
    public boolean hasCompoundUniqueKey() {
        return this._hasCompoundUniqueKey;
    }

    @Override
    public TnPropertyType getSimpleUniquePropertyType() {
        return this._simpleUniquePropertyType;
    }
}

