/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.identity;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.exception.handler.SQLExceptionHandler;
import org.seasar.robot.dbflute.exception.handler.SQLExceptionResource;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.jdbc.SqlLogInfo;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.resource.ResourceContext;
import org.seasar.robot.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnBasicSelectHandler;

public abstract class TnIdentifierAbstractGenerator
implements TnIdentifierGenerator {
    protected final TnPropertyType _propertyType;
    protected final TnResultSetHandler _resultSetHandler;

    public TnIdentifierAbstractGenerator(TnPropertyType propertyType) {
        if (propertyType == null) {
            String msg = "The arguement 'propertyType' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._propertyType = propertyType;
        this._resultSetHandler = new TnIdentifierResultSetHandler(propertyType.getValueType());
    }

    @Override
    public boolean isPrimaryKey() {
        return this._propertyType.isPrimaryKey();
    }

    protected Object executeSql(DataSource ds, String sql, Object[] args) {
        TnBasicSelectHandler selectHandler = this.createSelectHandler(ds, sql);
        if (args != null) {
            selectHandler.setExceptionMessageSqlArgs(args);
        }
        return selectHandler.execute(args);
    }

    protected TnBasicSelectHandler createSelectHandler(DataSource ds, String sql) {
        return new TnBasicSelectHandler(ds, sql, this._resultSetHandler, this.createStatementFactory(ds, sql)){

            @Override
            protected void saveResultSqlLogInfo(SqlLogInfo sqlLogInfo) {
            }
        };
    }

    protected StatementFactory createStatementFactory(DataSource ds, String sql) {
        return new TnIdentifierGeneratorStatementFactory();
    }

    protected void reflectIdentifier(Object bean, Object value) {
        DfPropertyDesc pd = this._propertyType.getPropertyDesc();
        pd.setValue(bean, value);
    }

    @Override
    public String getPropertyName() {
        return this._propertyType.getPropertyName();
    }

    protected static class TnIdentifierGeneratorStatementFactory
    implements StatementFactory {
        protected TnIdentifierGeneratorStatementFactory() {
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection conn, String sql) {
            try {
                return conn.prepareStatement(sql);
            }
            catch (SQLException e) {
                SQLExceptionResource resource = this.createSQLExceptionResource();
                resource.setNotice("Failed to prepare the statement for identity.");
                this.handleSQLException(e, resource);
                return null;
            }
        }

        @Override
        public CallableStatement createCallableStatement(Connection conn, String sql) {
            try {
                return conn.prepareCall(sql);
            }
            catch (SQLException e) {
                SQLExceptionResource resource = this.createSQLExceptionResource();
                resource.setNotice("Failed to prepare callable statement for identity.");
                this.handleSQLException(e, resource);
                return null;
            }
        }

        protected void handleSQLException(SQLException e, SQLExceptionResource resource) {
            this.createSQLExceptionHandler().handleSQLException(e, resource);
        }

        protected SQLExceptionHandler createSQLExceptionHandler() {
            return ResourceContext.createSQLExceptionHandler();
        }

        protected SQLExceptionResource createSQLExceptionResource() {
            return new SQLExceptionResource();
        }
    }

    protected static class TnIdentifierResultSetHandler
    implements TnResultSetHandler {
        private ValueType _valueType;

        public TnIdentifierResultSetHandler(ValueType valueType) {
            this._valueType = valueType;
        }

        @Override
        public Object handle(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return this._valueType.getValue(rs, 1);
            }
            return null;
        }
    }
}

