/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.jdbc;

import org.seasar.robot.dbflute.bhv.core.BehaviorCommandMeta;

public class SqlLogInfo {
    protected final BehaviorCommandMeta _meta;
    protected final String _executedSql;
    protected final Object[] _bindArgs;
    protected final Class<?>[] _bindArgTypes;
    protected final SqlLogDisplaySqlBuilder _displaySqlBuilder;
    protected String _cachedDisplaySql;

    public SqlLogInfo(BehaviorCommandMeta meta, String executedSql, Object[] bindArgs, Class<?>[] bindArgTypes, SqlLogDisplaySqlBuilder displaySqlBuilder) {
        this._meta = meta;
        this._executedSql = executedSql;
        this._bindArgs = bindArgs;
        this._bindArgTypes = bindArgTypes;
        this._displaySqlBuilder = displaySqlBuilder;
    }

    public String getDisplaySql() {
        if (this._cachedDisplaySql != null) {
            return this._cachedDisplaySql;
        }
        this._cachedDisplaySql = this._displaySqlBuilder.build(this._executedSql, this._bindArgs, this._bindArgTypes);
        return this._cachedDisplaySql;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("executedSql.length()=").append(this._executedSql != null ? Integer.valueOf(this._executedSql.length()) : null);
        sb.append(", bindArgs.length=").append(this._bindArgs != null ? Integer.valueOf(this._bindArgs.length) : null);
        sb.append(", bindArgTypes.length=").append(this._bindArgTypes != null ? Integer.valueOf(this._bindArgTypes.length) : null);
        sb.append(", cachedDisplaySql.length()=").append(this._cachedDisplaySql != null ? Integer.valueOf(this._cachedDisplaySql.length()) : null);
        sb.append("}");
        return sb.toString();
    }

    public BehaviorCommandMeta getMeta() {
        return this._meta;
    }

    public String getExecutedSql() {
        return this._executedSql;
    }

    public Object[] getBindArgs() {
        return this._bindArgs;
    }

    public Class<?>[] getBindArgTypes() {
        return this._bindArgTypes;
    }

    public static interface SqlLogDisplaySqlBuilder {
        public String build(String var1, Object[] var2, Class<?>[] var3);
    }
}

