/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.token.file;

import java.util.List;
import org.seasar.robot.dbflute.helper.token.file.FileMakingHeaderInfo;

public class FileMakingOption {
    protected String _delimiter;
    protected String _encoding;
    protected String _lineSeparator;
    protected boolean _quoteMinimally;
    protected boolean _suppressValueCountCheck;
    protected FileMakingHeaderInfo _headerInfo;

    public FileMakingOption delimitateByComma() {
        this._delimiter = ",";
        return this;
    }

    public FileMakingOption delimitateByTab() {
        this._delimiter = "\t";
        return this;
    }

    public FileMakingOption encodeAsUTF8() {
        this._encoding = "UTF-8";
        return this;
    }

    public FileMakingOption encodeAsWindows31J() {
        this._encoding = "Windows-31J";
        return this;
    }

    public FileMakingOption separateByCrLf() {
        this._lineSeparator = "\r\n";
        return this;
    }

    public FileMakingOption separateByLf() {
        this._lineSeparator = "\n";
        return this;
    }

    public FileMakingOption separateCrLf() {
        this._lineSeparator = "\r\n";
        return this;
    }

    public FileMakingOption separateLf() {
        this._lineSeparator = "\n";
        return this;
    }

    public FileMakingOption quoteMinimally() {
        this._quoteMinimally = true;
        return this;
    }

    public FileMakingOption suppressValueCountCheck() {
        this._suppressValueCountCheck = true;
        return this;
    }

    public FileMakingOption headerInfo(List<String> columnNameList) {
        if (columnNameList != null) {
            FileMakingHeaderInfo headerInfo = new FileMakingHeaderInfo();
            headerInfo.acceptColumnNameList(columnNameList);
            this._headerInfo = headerInfo;
        } else {
            this._headerInfo = null;
        }
        return this;
    }

    public String toString() {
        return "{" + this._delimiter + ", " + this._encoding + ", " + this._quoteMinimally + ", " + this._headerInfo + "}";
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator;
    }

    public boolean isQuoteMinimally() {
        return this._quoteMinimally;
    }

    public boolean isSuppressValueCountCheck() {
        return this._suppressValueCountCheck;
    }

    public FileMakingHeaderInfo getFileMakingHeaderInfo() {
        return this._headerInfo;
    }

    public void setFileMakingHeaderInfo(FileMakingHeaderInfo headerInfo) {
        this._headerInfo = headerInfo;
    }
}

