/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.jprop;

import java.util.List;
import org.seasar.robot.dbflute.util.DfTypeUtil;

public class JavaPropertiesProperty {
    protected final String _propertyKey;
    protected final String _propertyValue;
    protected final boolean _canBeIntegerProperty;
    protected final boolean _canBeLongProperty;
    protected final boolean _canBeDecimalProperty;
    protected final boolean _canBeDateProperty;
    protected final boolean _mayBeBooleanProperty;
    protected String _defName;
    protected String _camelizedName;
    protected String _capCamelName;
    protected String _uncapCamelName;
    protected String _variableArgDef;
    protected String _variableArgSet;
    protected List<Integer> _variableNumberList;
    protected String _comment;
    protected boolean _extends;
    protected boolean _override;
    protected boolean _secure;

    public JavaPropertiesProperty(String propertyKey, String propertyValue) {
        this._propertyKey = propertyKey;
        this._propertyValue = propertyValue;
        this._canBeIntegerProperty = this.deriveCanBeIntegerProperty();
        this._canBeLongProperty = this.deriveCanBeLongProperty();
        this._canBeDecimalProperty = this.deriveCanBeDecimalProperty();
        this._canBeDateProperty = this.deriveCanBeDateProperty();
        this._mayBeBooleanProperty = this.deriveMayBeBooleanProperty();
    }

    protected boolean deriveCanBeIntegerProperty() {
        if (this._propertyValue != null) {
            try {
                DfTypeUtil.toInteger((Object)this._propertyValue);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean deriveCanBeLongProperty() {
        if (this._propertyValue != null) {
            try {
                DfTypeUtil.toLong((Object)this._propertyValue);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean deriveCanBeDecimalProperty() {
        if (this._propertyValue != null) {
            try {
                DfTypeUtil.toBigDecimal(this._propertyValue);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean deriveCanBeDateProperty() {
        if (this._propertyValue != null) {
            try {
                DfTypeUtil.toDate(this._propertyValue);
                return true;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean deriveMayBeBooleanProperty() {
        return this._propertyValue != null && this.isTrueOrFalseProperty(this._propertyValue.trim());
    }

    protected boolean isTrueOrFalseProperty(String propertyValue) {
        return propertyValue.equalsIgnoreCase("true") || propertyValue.equalsIgnoreCase("false");
    }

    public boolean mayBeIntegerProperty() {
        return this._canBeIntegerProperty;
    }

    public boolean mayBeLongProperty() {
        return !this.mayBeIntegerProperty() && this._canBeLongProperty;
    }

    public boolean mayBeDecimalProperty() {
        return !this.mayBeIntegerProperty() && !this.mayBeLongProperty() && this._canBeDecimalProperty;
    }

    protected boolean mayBeNumber() {
        return this.mayBeIntegerProperty() || this.mayBeLongProperty() || this.mayBeDecimalProperty();
    }

    public boolean mayBeDateProperty() {
        return !this.mayBeNumber() && this._canBeDateProperty;
    }

    public boolean mayBeBooleanProperty() {
        return this._mayBeBooleanProperty;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JavaPropertiesProperty)) {
            return false;
        }
        JavaPropertiesProperty another = (JavaPropertiesProperty)obj;
        return this._propertyKey.equals(another._propertyKey);
    }

    public int hashCode() {
        return this._propertyKey.hashCode();
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._propertyKey + ", " + this._propertyValue + "}";
    }

    public String getPropertyKey() {
        return this._propertyKey;
    }

    public String getPropertyValue() {
        return this._propertyValue;
    }

    public String getDefName() {
        return this._defName;
    }

    public void setDefName(String defName) {
        this._defName = defName;
    }

    public String getCamelizedName() {
        return this._camelizedName;
    }

    public void setCamelizedName(String camelizedName) {
        this._camelizedName = camelizedName;
    }

    public String getCapCamelName() {
        return this._capCamelName;
    }

    public void setCapCamelName(String capCamelName) {
        this._capCamelName = capCamelName;
    }

    public String getUncapCamelName() {
        return this._uncapCamelName;
    }

    public void setUncapCamelName(String uncapCamelName) {
        this._uncapCamelName = uncapCamelName;
    }

    public String getVariableArgDef() {
        return this._variableArgDef;
    }

    public void setVariableArgDef(String variableArgDef) {
        this._variableArgDef = variableArgDef;
    }

    public String getVariableArgSet() {
        return this._variableArgSet;
    }

    public void setVariableArgSet(String variableArgSet) {
        this._variableArgSet = variableArgSet;
    }

    public List<Integer> getVariableNumberList() {
        return this._variableNumberList;
    }

    public void setVariableNumberList(List<Integer> variableNumberList) {
        this._variableNumberList = variableNumberList;
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public boolean isExtends() {
        return this._extends;
    }

    public void toBeExtends() {
        this._extends = true;
    }

    public boolean isOverride() {
        return this._override;
    }

    public void toBeOverride() {
        this._override = true;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void toBeSecure() {
        this._secure = true;
    }
}

