/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.seasar.robot.dbflute.helper.beans.DfBeanDesc;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.helper.beans.exception.DfBeanIllegalPropertyException;
import org.seasar.robot.dbflute.util.DfReflectionUtil;
import org.seasar.robot.dbflute.util.DfTypeUtil;

public class DfPropertyDescImpl
implements DfPropertyDesc {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private String _propertyName;
    private Class<?> _propertyType;
    private Method _readMethod;
    private Method _writeMethod;
    private Field _field;
    private DfBeanDesc _beanDesc;
    private Constructor<?> _stringConstructor;
    private Method _valueOfMethod;
    private boolean _readable = false;
    private boolean _writable = false;

    public DfPropertyDescImpl(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, DfBeanDesc beanDesc) {
        this(propertyName, propertyType, readMethod, writeMethod, null, beanDesc);
    }

    public DfPropertyDescImpl(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, Field field, DfBeanDesc beanDesc) {
        if (propertyName == null) {
            String msg = "The argument 'propertyName' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        if (propertyType == null) {
            String msg = "The argument 'propertyType' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this.setReadMethod(readMethod);
        this.setWriteMethod(writeMethod);
        this.setField(field);
        this._beanDesc = beanDesc;
        this.setupStringConstructor();
        this.setupValueOfMethod();
    }

    private void setupStringConstructor() {
        Constructor<?>[] cons = this._propertyType.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> con = cons[i];
            if (con.getParameterTypes().length != 1 || !con.getParameterTypes()[0].equals(String.class)) continue;
            this._stringConstructor = con;
            break;
        }
    }

    private void setupValueOfMethod() {
        Method[] methods = this._propertyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (DfReflectionUtil.isBridgeMethod(method) || DfReflectionUtil.isSyntheticMethod(method) || !DfReflectionUtil.isStatic(method.getModifiers()) || !method.getName().equals("valueOf") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            this._valueOfMethod = method;
            break;
        }
    }

    @Override
    public DfBeanDesc getBeanDesc() {
        return this._beanDesc;
    }

    @Override
    public final String getPropertyName() {
        return this._propertyName;
    }

    @Override
    public final Class<?> getPropertyType() {
        return this._propertyType;
    }

    @Override
    public final Method getReadMethod() {
        return this._readMethod;
    }

    @Override
    public final void setReadMethod(Method readMethod) {
        this._readMethod = readMethod;
        if (readMethod != null) {
            this._readable = true;
        }
    }

    @Override
    public final boolean hasReadMethod() {
        return this._readMethod != null;
    }

    @Override
    public final Method getWriteMethod() {
        return this._writeMethod;
    }

    @Override
    public final void setWriteMethod(Method writeMethod) {
        this._writeMethod = writeMethod;
        if (writeMethod != null) {
            this._writable = true;
        }
    }

    @Override
    public final boolean hasWriteMethod() {
        return this._writeMethod != null;
    }

    @Override
    public Field getField() {
        return this._field;
    }

    @Override
    public void setField(Field field) {
        this._field = field;
        if (field != null && DfReflectionUtil.isPublic(field.getModifiers())) {
            this._readable = true;
            this._writable = true;
        }
    }

    @Override
    public final Object getValue(Object target) {
        try {
            if (!this._readable) {
                Class<?> beanClass = this._beanDesc.getBeanClass();
                String msg = DfTypeUtil.toClassTitle(beanClass) + "." + this._propertyName;
                msg = msg + " is not readable.";
                throw new IllegalStateException(msg);
            }
            if (this.hasReadMethod()) {
                return DfReflectionUtil.invoke(this._readMethod, target, EMPTY_ARGS);
            }
            return DfReflectionUtil.getValue(this._field, target);
        }
        catch (Throwable t) {
            throw new DfBeanIllegalPropertyException(this._beanDesc.getBeanClass(), this._propertyName, t);
        }
    }

    @Override
    public final void setValue(Object target, Object value) {
        try {
            value = this.convertIfNeed(value);
            if (!this._writable) {
                Class<?> beanClass = this._beanDesc.getBeanClass();
                String msg = DfTypeUtil.toClassTitle(beanClass) + "." + this._propertyName;
                msg = msg + " is not writable.";
                throw new IllegalStateException(msg);
            }
            if (this.hasWriteMethod()) {
                DfReflectionUtil.invoke(this._writeMethod, target, new Object[]{value});
            } else {
                DfReflectionUtil.setValue(this._field, target, value);
            }
        }
        catch (Throwable t) {
            throw new DfBeanIllegalPropertyException(this._beanDesc.getBeanClass(), this._propertyName, t);
        }
    }

    @Override
    public boolean isReadable() {
        return this._readable;
    }

    @Override
    public boolean isWritable() {
        return this._writable;
    }

    @Override
    public Object convertIfNeed(Object arg) {
        if (this._propertyType.isPrimitive()) {
            return this.convertPrimitiveWrapper(arg);
        }
        if (Number.class.isAssignableFrom(this._propertyType)) {
            return this.convertNumber(arg);
        }
        if (Date.class.isAssignableFrom(this._propertyType)) {
            return this.convertDate(arg);
        }
        if (Boolean.class.isAssignableFrom(this._propertyType)) {
            return DfTypeUtil.toBoolean(arg);
        }
        if (arg != null && arg.getClass() != String.class && String.class == this._propertyType) {
            return arg.toString();
        }
        if (arg instanceof String && !String.class.equals(this._propertyType)) {
            return this.convertWithString(arg);
        }
        if (Calendar.class.isAssignableFrom(this._propertyType)) {
            return DfTypeUtil.toCalendar(arg);
        }
        return arg;
    }

    private Object convertPrimitiveWrapper(Object arg) {
        return DfTypeUtil.toWrapper(arg, this._propertyType);
    }

    private Object convertNumber(Object arg) {
        return DfTypeUtil.toNumber(arg, this._propertyType);
    }

    private Object convertDate(Object arg) {
        if (this._propertyType == Date.class) {
            return DfTypeUtil.toDate(arg);
        }
        if (this._propertyType == Timestamp.class) {
            return DfTypeUtil.toTimestamp(arg);
        }
        if (this._propertyType == java.sql.Date.class) {
            return DfTypeUtil.toDate(arg);
        }
        if (this._propertyType == Time.class) {
            return DfTypeUtil.toTime(arg);
        }
        return arg;
    }

    private Object convertWithString(Object arg) {
        if (this._stringConstructor != null) {
            return DfReflectionUtil.newInstance(this._stringConstructor, new Object[]{arg});
        }
        if (this._valueOfMethod != null) {
            return DfReflectionUtil.invoke(this._valueOfMethod, null, new Object[]{arg});
        }
        return arg;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("propertyName=");
        buf.append(this._propertyName);
        buf.append(",propertyType=");
        buf.append(this._propertyType.getName());
        buf.append(",readMethod=");
        buf.append(this._readMethod != null ? this._readMethod.getName() : "null");
        buf.append(",writeMethod=");
        buf.append(this._writeMethod != null ? this._writeMethod.getName() : "null");
        return buf.toString();
    }
}

