/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class StringKeyMap<VALUE>
implements Map<String, VALUE>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, VALUE> _searchMap;
    protected final Map<String, VALUE> _plainMap;
    protected final Map<String, String> _searchPlainKeyMap;
    protected boolean _flexible;

    protected StringKeyMap(boolean flexible, boolean order, boolean concurrent) {
        if (order && concurrent) {
            String msg = "The 'order' and 'concurrent' should not be both true at the same time!";
            throw new IllegalStateException(msg);
        }
        this._flexible = flexible;
        if (concurrent) {
            this._searchMap = StringKeyMap.newConcurrentHashMap();
            this._plainMap = null;
            this._searchPlainKeyMap = null;
        } else {
            if (order) {
                this._searchMap = StringKeyMap.newLinkedHashMap();
                this._plainMap = StringKeyMap.newLinkedHashMap();
            } else {
                this._searchMap = StringKeyMap.newHashMap();
                this._plainMap = StringKeyMap.newHashMap();
            }
            this._searchPlainKeyMap = StringKeyMap.newHashMap();
        }
    }

    public static <VALUE> StringKeyMap<VALUE> createAsCaseInsensitive() {
        return new StringKeyMap<VALUE>(false, false, false);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsCaseInsensitiveConcurrent() {
        return new StringKeyMap<VALUE>(false, false, true);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsCaseInsensitiveOrdered() {
        return new StringKeyMap<VALUE>(false, true, false);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsFlexible() {
        return new StringKeyMap<VALUE>(true, false, false);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsFlexibleConcurrent() {
        return new StringKeyMap<VALUE>(true, false, true);
    }

    public static <VALUE> StringKeyMap<VALUE> createAsFlexibleOrdered() {
        return new StringKeyMap<VALUE>(true, true, false);
    }

    @Override
    public VALUE get(Object key) {
        String stringKey = this.convertStringKey(key);
        return this._searchMap.get(stringKey);
    }

    @Override
    public VALUE put(String key, VALUE value) {
        String stringKey = this.convertStringKey(key);
        if (this._plainMap != null) {
            String plainKey = this.generatePlainKey(key, stringKey);
            this._plainMap.put(plainKey, value);
            this._searchPlainKeyMap.put(stringKey, plainKey);
        }
        return this._searchMap.put(stringKey, value);
    }

    @Override
    public VALUE remove(Object key) {
        String stringKey = this.convertStringKey(key);
        if (this._plainMap != null) {
            String plainKey = this.generatePlainKey(key, stringKey);
            this._plainMap.remove(plainKey);
            this._searchPlainKeyMap.remove(stringKey);
        }
        return this._searchMap.remove(stringKey);
    }

    protected String generatePlainKey(Object key, String stringKey) {
        String plainKey = this._searchPlainKeyMap.get(stringKey);
        return plainKey != null ? plainKey : (key != null ? key.toString() : null);
    }

    @Override
    public final void putAll(Map<? extends String, ? extends VALUE> map) {
        Set<Map.Entry<String, VALUE>> entrySet = map.entrySet();
        Iterator<Map.Entry<String, VALUE>> i$ = entrySet.iterator();
        while (i$.hasNext()) {
            Map.Entry<String, VALUE> entryObj;
            Map.Entry<String, VALUE> entry = entryObj = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        String stringKey = this.convertStringKey(key);
        return this._searchMap.containsKey(stringKey);
    }

    @Override
    public void clear() {
        if (this._plainMap != null) {
            this._plainMap.clear();
            this._searchPlainKeyMap.clear();
        }
        this._searchMap.clear();
    }

    @Override
    public int size() {
        return this._searchMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._searchMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        if (this._plainMap != null) {
            return this._plainMap.keySet();
        }
        return this._searchMap.keySet();
    }

    @Override
    public Collection<VALUE> values() {
        return this._searchMap.values();
    }

    @Override
    public boolean containsValue(Object obj) {
        return this._searchMap.containsValue(obj);
    }

    @Override
    public Set<Map.Entry<String, VALUE>> entrySet() {
        if (this._plainMap != null) {
            return this._plainMap.entrySet();
        }
        return this._searchMap.entrySet();
    }

    public boolean equalsUnderCharOption(StringKeyMap<VALUE> map) {
        if (map == null) {
            return false;
        }
        if (this.size() != map.size()) {
            return false;
        }
        Set<Map.Entry<String, VALUE>> entrySet = map.entrySet();
        for (Map.Entry<String, VALUE> entry : entrySet) {
            if (!this.containsKey(entry.getKey())) {
                return false;
            }
            VALUE value = this.get(entry.getKey());
            if (!(value != null ? !value.equals(entry.getValue()) : entry.getValue() != null)) continue;
            return false;
        }
        return true;
    }

    protected String convertStringKey(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.toLowerCase(this.removeConnector((String)key));
    }

    protected String removeConnector(String value) {
        if (value == null) {
            return null;
        }
        if (this._flexible) {
            if (StringKeyMap.isSingleQuoted(value)) {
                value = StringKeyMap.unquoteSingle(value);
            } else if (StringKeyMap.isDoubleQuoted(value)) {
                value = StringKeyMap.unquoteDouble(value);
            }
            value = StringKeyMap.replace(value, "_", "");
            value = StringKeyMap.replace(value, "-", "");
            value = StringKeyMap.replace(value, " ", "");
        }
        return value;
    }

    protected String toLowerCase(String value) {
        return value.toLowerCase();
    }

    protected static String replace(String str, String fromStr, String toStr) {
        StringBuilder sb = null;
        int pos = 0;
        int pos2 = 0;
        while (true) {
            pos = str.indexOf(fromStr, pos2);
            if (pos2 == 0 && pos < 0) {
                return str;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (pos == 0) {
                sb.append(toStr);
                pos2 = fromStr.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(str.substring(pos2, pos));
            sb.append(toStr);
            pos2 = pos + fromStr.length();
        }
        sb.append(str.substring(pos2));
        return sb.toString();
    }

    protected static boolean isSingleQuoted(String str) {
        return str.length() > 1 && str.startsWith("'") && str.endsWith("'");
    }

    protected static boolean isDoubleQuoted(String str) {
        return str.length() > 1 && str.startsWith("\"") && str.endsWith("\"");
    }

    protected static String unquoteSingle(String str) {
        if (!StringKeyMap.isSingleQuoted(str)) {
            return str;
        }
        return str.substring("'".length(), str.length() - "'".length());
    }

    protected static String unquoteDouble(String str) {
        if (!StringKeyMap.isDoubleQuoted(str)) {
            return str;
        }
        return str.substring("\"".length(), str.length() - "\"".length());
    }

    protected static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    protected static <KEY, VALUE> HashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StringKeyMap) {
            StringKeyMap map = (StringKeyMap)obj;
            if (this.size() != map.size()) {
                return false;
            }
            Map<String, VALUE> myMap = this._plainMap != null ? this._plainMap : this._searchMap;
            Map<String, VALUE> yourMap = map._plainMap != null ? map._plainMap : map._searchMap;
            return ((Object)myMap).equals(yourMap);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (this.size() != map.size()) {
                return false;
            }
            return this._plainMap != null ? ((Object)this._plainMap).equals(map) : ((Object)this._searchMap).equals(map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._plainMap != null ? ((Object)this._plainMap).hashCode() : ((Object)this._searchMap).hashCode();
    }

    public String toString() {
        return this._plainMap != null ? this._plainMap.toString() : this._searchMap.toString();
    }
}

