/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean.sqlclause.subquery;

import org.seasar.robot.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.AbstractSubQuery;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.robot.dbflute.exception.IllegalConditionBeanOperationException;

public class ScalarCondition
extends AbstractSubQuery {
    protected final String _mainSubQueryIdentity;
    protected final String _operand;
    protected final PartitionByProvider _partitionByProvider;

    public ScalarCondition(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQuerySqlClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, String mainSubQueryIdentity, String operand, PartitionByProvider partitionByProvider) {
        super(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQuerySqlClause, subQueryIdentity, subQueryDBMeta, cipherManager);
        this._mainSubQueryIdentity = mainSubQueryIdentity;
        this._operand = operand;
        this._partitionByProvider = partitionByProvider;
    }

    public String buildScalarCondition(String function) {
        String columnDbName = this._subQuerySqlClause.getSpecifiedColumnDbNameAsOne();
        if (columnDbName == null || columnDbName.trim().length() == 0) {
            this.throwScalarConditionInvalidColumnSpecificationException(function);
        }
        ColumnRealName columnRealName = this._localRealNameProvider.provide(columnDbName);
        String subQueryClause = this.getSubQueryClause(function);
        String beginMark = this.resolveSubQueryBeginMark(this._subQueryIdentity) + this.ln();
        String endMark = this.resolveSubQueryEndMark(this._subQueryIdentity);
        String endIndent = "       ";
        ColumnInfo columnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
        String specifiedExp = this.decrypt(columnInfo, columnRealName.toString());
        return specifiedExp + " " + this._operand + " (" + beginMark + subQueryClause + this.ln() + "       " + ") " + endMark;
    }

    protected String getSubQueryClause(String function) {
        String subQueryClause;
        if (!this._subQueryDBMeta.hasPrimaryKey() || this._subQueryDBMeta.hasCompoundPrimaryKey()) {
            String msg = "The scalar-condition is unsupported when no primary key or compound primary key:";
            msg = msg + " table=" + this._subQueryDBMeta.getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        String tableAliasName = this.getSubQueryLocalAliasName();
        String derivedColumnDbName = this._subQuerySqlClause.getSpecifiedColumnDbNameAsOne();
        if (derivedColumnDbName == null) {
            this.throwScalarConditionInvalidColumnSpecificationException(function);
        }
        ColumnSqlName derivedColumnSqlName = this._subQuerySqlClause.getSpecifiedColumnSqlNameAsOne();
        ColumnRealName derivedColumnRealName = ColumnRealName.create(tableAliasName, derivedColumnSqlName);
        this.assertScalarConditionColumnType(function, derivedColumnDbName);
        ColumnRealName partitionByCorrelatedColumnRealName = null;
        ColumnSqlName partitionByRelatedColumnSqlName = null;
        SqlClause partitionBySqlClause = this._partitionByProvider.provideSqlClause();
        if (partitionBySqlClause != null) {
            String partitionByColumnDbName = partitionBySqlClause.getSpecifiedColumnDbNameAsOne();
            if (partitionByColumnDbName == null) {
                this.throwScalarConditionPartitionByInvalidColumnSpecificationException(function);
            }
            partitionByCorrelatedColumnRealName = this._localRealNameProvider.provide(partitionByColumnDbName);
            partitionByRelatedColumnSqlName = this._subQuerySqlNameProvider.provide(partitionByColumnDbName);
        }
        if (this._subQuerySqlClause.hasUnionQuery()) {
            subQueryClause = this.getUnionSubQuerySql(function, tableAliasName, derivedColumnSqlName, derivedColumnRealName, partitionByCorrelatedColumnRealName, partitionByRelatedColumnSqlName);
        } else {
            ColumnInfo columnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
            String specifiedExp = this.decrypt(columnInfo, derivedColumnRealName.toString());
            String selectClause = "select " + function + "(" + specifiedExp + ")";
            String fromWhereClause = this.buildFromWhereClause(selectClause, tableAliasName, partitionByCorrelatedColumnRealName, partitionByRelatedColumnSqlName);
            subQueryClause = selectClause + " " + fromWhereClause;
        }
        return this.resolveSubQueryLevelVariable(subQueryClause);
    }

    protected String getUnionSubQuerySql(String function, String tableAliasName, ColumnSqlName derivedColumnSqlName, ColumnRealName derivedColumnRealName, ColumnRealName partitionByCorrelatedColumnRealName, ColumnSqlName partitionByRelatedColumnSqlName) {
        String beginMark = this.resolveSubQueryBeginMark(this._mainSubQueryIdentity) + this.ln();
        String endMark = this.resolveSubQueryEndMark(this._mainSubQueryIdentity);
        ColumnSqlName pkSqlName = this._subQueryDBMeta.getPrimaryUniqueInfo().getFirstColumn().getColumnSqlName();
        ColumnRealName pkRealName = ColumnRealName.create(tableAliasName, pkSqlName);
        String selectClause = "select " + pkRealName + ", " + derivedColumnRealName;
        String fromWhereClause = this.buildFromWhereClause(selectClause, tableAliasName, partitionByCorrelatedColumnRealName, partitionByRelatedColumnSqlName);
        String mainSql = selectClause + " " + fromWhereClause;
        String mainAlias = this.buildSubQueryMainAliasName();
        ColumnRealName mainDerivedColumnRealName = ColumnRealName.create(mainAlias, derivedColumnSqlName);
        ColumnInfo columnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
        String specifiedExp = this.decrypt(columnInfo, mainDerivedColumnRealName.toString());
        return "select " + function + "(" + specifiedExp + ")" + this.ln() + "  from (" + beginMark + mainSql + this.ln() + "       ) " + mainAlias + endMark;
    }

    protected String buildFromWhereClause(String selectClause, String tableAliasName, ColumnRealName partitionByCorrelatedColumnRealName, ColumnSqlName partitionByRelatedColumnSqlName) {
        String fromWhereClause = partitionByCorrelatedColumnRealName != null ? this.buildCorrelationFromWhereClause(selectClause, tableAliasName, partitionByCorrelatedColumnRealName, partitionByRelatedColumnSqlName, null) : this.buildPlainFromWhereClause(selectClause, tableAliasName, null);
        return fromWhereClause;
    }

    protected void throwScalarConditionInvalidColumnSpecificationException(String function) {
        this.createCBExThrower().throwScalarConditionInvalidColumnSpecificationException(function);
    }

    protected void throwScalarConditionPartitionByInvalidColumnSpecificationException(String function) {
        this.createCBExThrower().throwScalarConditionPartitionByInvalidColumnSpecificationException(function);
    }

    protected void assertScalarConditionColumnType(String function, String derivedColumnDbName) {
        Class<?> deriveColumnType = this._subQueryDBMeta.findColumnInfo(derivedColumnDbName).getPropertyType();
        if (("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) && !Number.class.isAssignableFrom(deriveColumnType)) {
            this.throwScalarConditionUnmatchedColumnTypeException(function, derivedColumnDbName, deriveColumnType);
        }
    }

    protected void throwScalarConditionUnmatchedColumnTypeException(String function, String derivedColumnDbName, Class<?> derivedColumnType) {
        this.createCBExThrower().throwScalarConditionUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType);
    }

    public static interface PartitionByProvider {
        public SqlClause provideSqlClause();
    }
}

