/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean.sqlclause;

import org.seasar.robot.dbflute.cbean.sqlclause.AbstractSqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.robot.dbflute.dbway.DBWay;
import org.seasar.robot.dbflute.dbway.WayOfOracle;

public class SqlClauseOracle
extends AbstractSqlClause {
    private static final long serialVersionUID = 1L;
    protected static final DBWay _dbway = new WayOfOracle();
    protected String _fetchScopeSelectHint = "";
    protected String _fetchScopeSqlSuffix = "";
    protected String _lockSqlSuffix = "";
    protected Integer _pagingBindFrom;
    protected Integer _pagingBindTo;

    public SqlClauseOracle(String tableDbName) {
        super(tableDbName);
    }

    @Override
    protected String prepareUnionClause(String selectClause) {
        selectClause = this.replace(selectClause, "/*$pmb.selectHint*/", "");
        return super.prepareUnionClause(selectClause);
    }

    @Override
    protected void doFetchFirst() {
        this.doFetchPage();
    }

    @Override
    protected void doFetchPage() {
        AbstractSqlClause.RownumPagingProcessor processor = this.createRownumPagingProcessor(this.getRownumExpression());
        processor.processRowNumberPaging();
        this._fetchScopeSelectHint = processor.getSelectHint();
        this._fetchScopeSqlSuffix = processor.getSqlSuffix();
        this._pagingBindFrom = processor.getPagingBindFrom();
        this._pagingBindTo = processor.getPagingBindTo();
    }

    protected AbstractSqlClause.RownumPagingProcessor createRownumPagingProcessor(String expression) {
        AbstractSqlClause.RownumPagingProcessor processor = new AbstractSqlClause.RownumPagingProcessor(expression);
        if (this.isBindPagingCondition()) {
            processor.useBindVariable();
        }
        return processor;
    }

    protected boolean isBindPagingCondition() {
        return true;
    }

    protected String getRownumExpression() {
        return "rownum";
    }

    @Override
    protected void doClearFetchPageClause() {
        this._fetchScopeSelectHint = "";
        this._fetchScopeSqlSuffix = "";
    }

    @Override
    public void lockForUpdate() {
        DBMeta dbmeta = this.findDBMeta(this._tableDbName);
        String basePointAliasName = this.getBasePointAliasName();
        if (dbmeta.hasPrimaryKey()) {
            ColumnSqlName primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnSqlName();
            this._lockSqlSuffix = " for update of " + basePointAliasName + "." + primaryKeyName;
        } else {
            ColumnSqlName randomColumnName = dbmeta.getColumnInfoList().get(0).getColumnSqlName();
            this._lockSqlSuffix = " for update of " + basePointAliasName + "." + randomColumnName;
        }
    }

    @Override
    protected String createSelectHint() {
        return this._fetchScopeSelectHint;
    }

    @Override
    protected String createFromBaseTableHint() {
        return "";
    }

    @Override
    protected String createFromHint() {
        return "";
    }

    @Override
    protected String createSqlSuffix() {
        return this._fetchScopeSqlSuffix + this._lockSqlSuffix;
    }

    public SqlClause lockForUpdateNoWait() {
        this.lockForUpdate();
        this._lockSqlSuffix = this._lockSqlSuffix + " nowait";
        return this;
    }

    public SqlClause lockForUpdateWait(int waitSec) {
        this.lockForUpdate();
        this._lockSqlSuffix = this._lockSqlSuffix + " wait " + waitSec;
        return this;
    }

    @Override
    public int getInScopeLimit() {
        return 1000;
    }

    public QueryClauseArranger createFullTextSearchClauseArranger() {
        return new FullTextSearchClauseArranger();
    }

    public String escapeFullTextSearchValue(String conditionValue) {
        if (conditionValue.contains("}")) {
            conditionValue = this.replace(conditionValue, "}", "}}");
        }
        conditionValue = "{" + conditionValue + "}";
        return conditionValue;
    }

    @Override
    public DBWay dbway() {
        return _dbway;
    }

    public Integer getPagingBindFrom() {
        return this._pagingBindFrom;
    }

    public Integer getPagingBindTo() {
        return this._pagingBindTo;
    }

    protected static class FullTextSearchClauseArranger
    implements QueryClauseArranger {
        protected FullTextSearchClauseArranger() {
        }

        @Override
        public String arrange(ColumnRealName columnRealName, String operand, String bindExpression, String rearOption) {
            return "contains(" + columnRealName + ", " + bindExpression + ") > 0";
        }
    }
}

