/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean.sqlclause;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.seasar.robot.dbflute.cbean.ManualOrderBean;
import org.seasar.robot.dbflute.cbean.chelper.HpCBPurpose;
import org.seasar.robot.dbflute.cbean.chelper.HpDerivingSubQueryInfo;
import org.seasar.robot.dbflute.cbean.chelper.HpInvalidQueryInfo;
import org.seasar.robot.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.robot.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.robot.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.robot.dbflute.cbean.ckey.ConditionKey;
import org.seasar.robot.dbflute.cbean.coption.ConditionOption;
import org.seasar.robot.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.robot.dbflute.cbean.coption.ScalarSelectOption;
import org.seasar.robot.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.clause.ClauseLazyReflector;
import org.seasar.robot.dbflute.cbean.sqlclause.join.FixedConditionLazyChecker;
import org.seasar.robot.dbflute.cbean.sqlclause.join.FixedConditionResolver;
import org.seasar.robot.dbflute.cbean.sqlclause.join.InnerJoinLazyReflector;
import org.seasar.robot.dbflute.cbean.sqlclause.join.InnerJoinLazyReflectorBase;
import org.seasar.robot.dbflute.cbean.sqlclause.join.LeftOuterJoinInfo;
import org.seasar.robot.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.robot.dbflute.cbean.sqlclause.orderby.OrderByElement;
import org.seasar.robot.dbflute.cbean.sqlclause.query.OrScopeQueryAndPartQueryClause;
import org.seasar.robot.dbflute.cbean.sqlclause.query.OrScopeQueryInfo;
import org.seasar.robot.dbflute.cbean.sqlclause.query.OrScopeQueryReflector;
import org.seasar.robot.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.robot.dbflute.cbean.sqlclause.query.QueryClauseFilter;
import org.seasar.robot.dbflute.cbean.sqlclause.query.QueryUsedAliasInfo;
import org.seasar.robot.dbflute.cbean.sqlclause.query.StringQueryClause;
import org.seasar.robot.dbflute.cbean.sqlclause.select.SelectedRelationColumn;
import org.seasar.robot.dbflute.cbean.sqlclause.select.SpecifiedSelectColumnHandler;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.seasar.robot.dbflute.cbean.sqlclause.union.UnionClauseProvider;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.robot.dbflute.dbmeta.name.TableSqlName;
import org.seasar.robot.dbflute.dbway.DBWay;
import org.seasar.robot.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.helper.StringKeyMap;
import org.seasar.robot.dbflute.resource.DBFluteSystem;
import org.seasar.robot.dbflute.util.DfAssertUtil;
import org.seasar.robot.dbflute.util.Srl;

public abstract class AbstractSqlClause
implements SqlClause,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final SqlClause.SelectClauseType DEFAULT_SELECT_CLAUSE_TYPE = SqlClause.SelectClauseType.COLUMNS;
    protected static final String SELECT_HINT = "/*$pmb.selectHint*/";
    protected final String _tableDbName;
    protected DBMeta _dbmeta;
    protected DBMetaProvider _dbmetaProvider;
    protected Map<String, DBMeta> _cachedDBMetaMap;
    protected int _subQueryLevel;
    protected Map<String, String> _selectedRelationBasicMap;
    protected Map<String, Map<String, SelectedRelationColumn>> _selectedRelationColumnMap;
    protected Set<String> _selectedNextConnectingRelationSet;
    protected Map<String, Map<String, HpSpecifiedColumn>> _specifiedSelectColumnMap;
    protected Map<String, Map<String, HpSpecifiedColumn>> _backupSpecifiedSelectColumnMap;
    protected Map<String, HpDerivingSubQueryInfo> _specifiedDerivingSubQueryMap;
    protected Map<String, String> _selectClauseRealColumnAliasMap;
    protected SqlClause.SelectClauseType _selectClauseType = DEFAULT_SELECT_CLAUSE_TYPE;
    protected SqlClause.SelectClauseType _previousSelectClauseType;
    protected Map<String, Integer> _selectIndexMap;
    protected Map<String, String> _selectIndexReverseMap;
    protected boolean _useSelectIndex = true;
    protected Map<String, LeftOuterJoinInfo> _outerJoinMap;
    protected List<FixedConditionLazyChecker> _fixedConditionLazyChecker;
    protected boolean _structuralPossibleInnerJoinAllowed;
    protected boolean _whereUsedInnerJoinAllowed;
    protected List<InnerJoinLazyReflector> _innerJoinLazyReflector;
    protected List<QueryClause> _whereList;
    protected List<QueryClause> _baseTableInlineWhereList;
    protected OrderByClause _orderByClause;
    protected List<UnionQueryInfo> _unionQueryInfoList;
    protected boolean _orderByEffective;
    protected int _fetchStartIndex = 0;
    protected int _fetchSize = 0;
    protected int _fetchPageNumber = 1;
    protected boolean _fetchScopeEffective;
    protected boolean _orScopeQueryEffective;
    protected OrScopeQueryInfo _currentTmpOrScopeQueryInfo;
    protected boolean _orScopeQueryAndPartEffective;
    protected int _orScopeQueryAndPartIdentity;
    protected SubQueryIndentProcessor _subQueryIndentProcessor;
    protected boolean _emptyStringQueryAllowed;
    protected boolean _invalidQueryChecked;
    protected List<HpInvalidQueryInfo> _invalidQueryList;
    protected transient List<QueryClauseFilter> _whereClauseSimpleFilterList;
    protected Map<String, Object> _columyQueryObjectMap;
    protected Map<String, Object> _manualOrderParameterMap;
    protected Map<String, Object> _freeParameterMap;
    protected GearedCipherManager _gearedCipherManager;
    protected boolean _suppressSelectColumnDecryption;
    protected ScalarSelectOption _scalarSelectOption;
    protected boolean _pagingAdjustment;
    protected boolean _pagingCountLeastJoin;
    protected boolean _pagingCountLater;
    protected boolean _queryUpdateForcedDirectAllowed;
    protected HpCBPurpose _purpose = HpCBPurpose.NORMAL_USE;
    protected List<ClauseLazyReflector> _clauseLazyReflectorList;

    public AbstractSqlClause(String tableDbName) {
        if (tableDbName == null) {
            String msg = "The argument 'tableDbName' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._tableDbName = tableDbName;
    }

    public AbstractSqlClause dbmetaProvider(DBMetaProvider dbmetaProvider) {
        if (dbmetaProvider == null) {
            String msg = "The argument 'dbmetaProvider' should not be null: tableDbName=" + this._tableDbName;
            throw new IllegalArgumentException(msg);
        }
        this._dbmetaProvider = dbmetaProvider;
        this._dbmeta = this.findDBMeta(this._tableDbName);
        return this;
    }

    public AbstractSqlClause cipherManager(GearedCipherManager manager) {
        this._gearedCipherManager = manager;
        return this;
    }

    @Override
    public int getSubQueryLevel() {
        return this._subQueryLevel;
    }

    @Override
    public void setupForSubQuery(int subQueryLevel) {
        this._subQueryLevel = subQueryLevel;
    }

    @Override
    public boolean isForSubQuery() {
        return this._subQueryLevel > 0;
    }

    @Override
    public String getClause() {
        this.reflectClauseLazilyIfExists();
        StringBuilder sb = new StringBuilder(512);
        String selectClause = this.getSelectClause();
        sb.append(selectClause);
        this.buildClauseWithoutMainSelect(sb, selectClause);
        String sql = sb.toString();
        sql = this.filterEnclosingClause(sql);
        sql = this.processSubQueryIndent(sql);
        return sql;
    }

    protected void buildClauseWithoutMainSelect(StringBuilder sb, String selectClause) {
        this.buildFromClause(sb);
        sb.append(this.getFromHint());
        this.buildWhereClause(sb);
        sb.append(this.deleteUnionWhereTemplateMark(this.prepareUnionClause(selectClause)));
        if (!this.needsUnionNormalSelectEnclosing()) {
            sb.append(this.prepareClauseOrderBy());
            sb.append(this.prepareClauseSqlSuffix());
        }
    }

    protected String deleteUnionWhereTemplateMark(String unionClause) {
        if (unionClause != null && unionClause.trim().length() > 0) {
            unionClause = this.replace(unionClause, this.getUnionWhereClauseMark(), "");
            unionClause = this.replace(unionClause, this.getUnionWhereFirstConditionMark(), "");
        }
        return unionClause;
    }

    @Override
    public String getClauseFromWhereWithUnionTemplate() {
        this.reflectClauseLazilyIfExists();
        return this.buildClauseFromWhereAsTemplate(false);
    }

    @Override
    public String getClauseFromWhereWithWhereUnionTemplate() {
        this.reflectClauseLazilyIfExists();
        return this.buildClauseFromWhereAsTemplate(true);
    }

    protected String buildClauseFromWhereAsTemplate(boolean template) {
        StringBuilder sb = new StringBuilder(256);
        this.buildFromClause(sb);
        sb.append(this.getFromHint());
        this.buildWhereClause(sb, template);
        sb.append(this.prepareUnionClause(this.getUnionSelectClauseMark()));
        return sb.toString();
    }

    protected String prepareUnionClause(String selectClause) {
        if (!this.hasUnionQuery()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (UnionQueryInfo unionQueryInfo : this._unionQueryInfoList) {
            UnionClauseProvider unionClauseProvider = unionQueryInfo.getUnionClauseProvider();
            String unionQueryClause = unionClauseProvider.provide();
            boolean unionAll = unionQueryInfo.isUnionAll();
            sb.append(this.ln()).append(unionAll ? " union all " : " union ").append(this.ln());
            sb.append(selectClause).append(" ").append(unionQueryClause);
        }
        return sb.toString();
    }

    protected String prepareClauseOrderBy() {
        if (!this._orderByEffective || !this.hasOrderByClause()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(this.getOrderByClause());
        return sb.toString();
    }

    protected String prepareClauseSqlSuffix() {
        String sqlSuffix = this.getSqlSuffix();
        if (sqlSuffix == null || sqlSuffix.trim().length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(sqlSuffix);
        return sb.toString();
    }

    protected String filterEnclosingClause(String sql) {
        sql = this.filterUnionNormalSelectEnclosing(sql);
        sql = this.filterUnionCountOrScalarEnclosing(sql);
        return sql;
    }

    protected String filterUnionNormalSelectEnclosing(String sql) {
        if (!this.needsUnionNormalSelectEnclosing()) {
            return sql;
        }
        String selectClause = "select/*$pmb.selectHint*/ *";
        String inlineViewAlias = this.getUnionQueryInlineViewAlias();
        String beginMark = this.resolveSubQueryBeginMark(inlineViewAlias) + this.ln();
        String endMark = this.resolveSubQueryEndMark(inlineViewAlias);
        StringBuilder sb = new StringBuilder();
        sb.append("select/*$pmb.selectHint*/ *").append(this.ln());
        sb.append("  from (").append(beginMark).append(sql).append(this.ln()).append("       ) ");
        sb.append(inlineViewAlias).append(endMark);
        sb.append(this.prepareClauseOrderBy()).append(this.prepareClauseSqlSuffix());
        return sb.toString();
    }

    protected String filterUnionCountOrScalarEnclosing(String sql) {
        if (!this.needsUnionCountOrScalarEnclosing()) {
            return sql;
        }
        String inlineViewAlias = this.getUnionQueryInlineViewAlias();
        String selectClause = this.buildSelectClauseScalar(inlineViewAlias);
        String beginMark = this.resolveSubQueryBeginMark(inlineViewAlias) + this.ln();
        String endMark = this.resolveSubQueryEndMark(inlineViewAlias);
        StringBuilder sb = new StringBuilder();
        sb.append(selectClause).append(this.ln());
        sb.append("  from (").append(beginMark).append(sql).append(this.ln()).append("       ) ");
        sb.append(inlineViewAlias).append(endMark);
        return sb.toString();
    }

    protected boolean needsUnionNormalSelectEnclosing() {
        if (!this.isUnionNormalSelectEnclosingRequired()) {
            return false;
        }
        return this.hasUnionQuery() && !this.isSelectClauseTypeScalar();
    }

    protected boolean isUnionNormalSelectEnclosingRequired() {
        return false;
    }

    protected boolean needsUnionCountOrScalarEnclosing() {
        return this.hasUnionQuery() && this.isSelectClauseTypeScalar();
    }

    @Override
    public String getSelectClause() {
        this.reflectClauseLazilyIfExists();
        if (this.isSelectClauseNonUnionScalar()) {
            return this.buildSelectClauseScalar(this.getBasePointAliasName());
        }
        StringBuilder sb = new StringBuilder();
        if (this._useSelectIndex) {
            this._selectIndexMap = this.createSelectIndexMap();
        }
        Integer selectIndex = this.processSelectClauseLocal(sb);
        this.processSelectClauseRelation(sb, selectIndex);
        this.processSelectClauseDerivedReferrer(sb);
        return sb.toString();
    }

    protected Integer processSelectClauseLocal(StringBuilder sb) {
        boolean validSpecifiedLocal;
        List<ColumnInfo> columnInfoList;
        String basePointAliasName = this.getBasePointAliasName();
        DBMeta dbmeta = this.getDBMeta();
        Map<String, HpSpecifiedColumn> localSpecifiedMap = this._specifiedSelectColumnMap != null ? this._specifiedSelectColumnMap.get(basePointAliasName) : null;
        if (this.isSelectClauseTypeUniqueScalar()) {
            if (dbmeta.hasPrimaryKey()) {
                ColumnInfo specifiedColumn;
                columnInfoList = new ArrayList<ColumnInfo>();
                columnInfoList.addAll(dbmeta.getPrimaryUniqueInfo().getUniqueColumnList());
                if (this.isSelectClauseTypeSpecifiedScalar() && (specifiedColumn = this.getSpecifiedColumnInfoAsOne()) != null) {
                    columnInfoList.add(specifiedColumn);
                }
            } else {
                columnInfoList = dbmeta.getColumnInfoList();
            }
            validSpecifiedLocal = false;
        } else {
            columnInfoList = dbmeta.getColumnInfoList();
            validSpecifiedLocal = localSpecifiedMap != null && !localSpecifiedMap.isEmpty();
        }
        Integer selectIndex = 0;
        boolean needsDelimiter = false;
        for (ColumnInfo columnInfo : columnInfoList) {
            String onQueryName;
            String columnDbName = columnInfo.getColumnDbName();
            ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
            if (validSpecifiedLocal && !localSpecifiedMap.containsKey(columnDbName)) continue;
            if (needsDelimiter) {
                sb.append(", ");
            } else {
                sb.append("select");
                this.appendSelectHint(sb);
                sb.append(" ");
                needsDelimiter = true;
            }
            String realColumnName = basePointAliasName + "." + columnSqlName;
            selectIndex = selectIndex + 1;
            if (this._useSelectIndex) {
                onQueryName = this.buildSelectIndexAlias(columnSqlName, null, selectIndex);
                this.registerSelectIndex(columnDbName, onQueryName, selectIndex);
            } else {
                onQueryName = columnSqlName.toString();
            }
            sb.append(this.decryptSelectColumnIfNeeds(columnInfo, realColumnName)).append(" as ").append(onQueryName);
            this.getSelectClauseRealColumnAliasMap().put(realColumnName, onQueryName);
            if (!validSpecifiedLocal || !localSpecifiedMap.containsKey(columnDbName)) continue;
            HpSpecifiedColumn specifiedColumn = localSpecifiedMap.get(columnDbName);
            specifiedColumn.setOnQueryName(onQueryName);
        }
        return selectIndex;
    }

    protected Integer processSelectClauseRelation(StringBuilder sb, Integer selectIndex) {
        for (Map.Entry<String, Map<String, SelectedRelationColumn>> entry : this.getSelectedRelationColumnMap().entrySet()) {
            String tableAliasName = entry.getKey();
            Map<String, SelectedRelationColumn> map = entry.getValue();
            Collection<SelectedRelationColumn> selectColumnInfoList = map.values();
            Map<String, HpSpecifiedColumn> foreginSpecifiedMap = null;
            if (this._specifiedSelectColumnMap != null) {
                foreginSpecifiedMap = this._specifiedSelectColumnMap.get(tableAliasName);
            }
            boolean validSpecifiedForeign = foreginSpecifiedMap != null && !foreginSpecifiedMap.isEmpty();
            boolean finishedForeignIndent = false;
            for (SelectedRelationColumn selectColumnInfo : selectColumnInfoList) {
                String onQueryName;
                ColumnInfo columnInfo = selectColumnInfo.getColumnInfo();
                String columnDbName = columnInfo.getColumnDbName();
                if (validSpecifiedForeign && !foreginSpecifiedMap.containsKey(columnDbName)) continue;
                String realColumnName = selectColumnInfo.buildRealColumnSqlName();
                String columnAliasName = selectColumnInfo.getColumnAliasName();
                selectIndex = selectIndex + 1;
                if (this._useSelectIndex) {
                    onQueryName = this.buildSelectIndexAlias(columnInfo.getColumnSqlName(), columnAliasName, selectIndex);
                    this.registerSelectIndex(columnAliasName, onQueryName, selectIndex);
                } else {
                    onQueryName = columnAliasName;
                }
                if (!finishedForeignIndent) {
                    sb.append(this.ln()).append("     ");
                    finishedForeignIndent = true;
                }
                sb.append(", ");
                sb.append(this.decryptSelectColumnIfNeeds(columnInfo, realColumnName)).append(" as ").append(onQueryName);
                this.getSelectClauseRealColumnAliasMap().put(realColumnName, onQueryName);
                if (!validSpecifiedForeign || !foreginSpecifiedMap.containsKey(columnDbName)) continue;
                HpSpecifiedColumn specifiedColumn = foreginSpecifiedMap.get(columnDbName);
                specifiedColumn.setOnQueryName(onQueryName);
            }
        }
        return selectIndex;
    }

    protected void processSelectClauseDerivedReferrer(StringBuilder sb) {
        if (this._specifiedDerivingSubQueryMap == null || this._specifiedDerivingSubQueryMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, HpDerivingSubQueryInfo> entry : this._specifiedDerivingSubQueryMap.entrySet()) {
            String subQueryAlias = entry.getKey();
            String derivingSubQuery = entry.getValue().getDerivingSubQuery();
            sb.append(this.ln()).append("     ");
            sb.append(", ").append(derivingSubQuery);
            if (subQueryAlias == null) continue;
            this.getSelectClauseRealColumnAliasMap().put(subQueryAlias, subQueryAlias);
        }
    }

    protected Map<String, String> getSelectClauseRealColumnAliasMap() {
        if (this._selectClauseRealColumnAliasMap == null) {
            this._selectClauseRealColumnAliasMap = new HashMap<String, String>();
        }
        return this._selectClauseRealColumnAliasMap;
    }

    protected boolean isSelectClauseTypeCount() {
        return this._selectClauseType.isCount();
    }

    protected boolean isSelectClauseTypeScalar() {
        return this._selectClauseType.isScalar();
    }

    protected boolean isSelectClauseTypeUniqueScalar() {
        return this._selectClauseType.isUniqueScalar();
    }

    protected boolean isSelectClauseTypeSpecifiedScalar() {
        return this._selectClauseType.isSpecifiedScalar();
    }

    protected boolean isSelectClauseTypeNonUnionCount() {
        return !this.hasUnionQuery() && this.isSelectClauseTypeCount();
    }

    protected boolean isSelectClauseNonUnionScalar() {
        return !this.hasUnionQuery() && this.isSelectClauseTypeScalar();
    }

    protected boolean isSelectClauseNonUnionSelect() {
        return !this.hasUnionQuery() && !this.isSelectClauseTypeScalar();
    }

    protected String buildSelectClauseScalar(String aliasName) {
        if (this.isSelectClauseTypeCount()) {
            return this.buildSelectClauseCount();
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.COUNT_DISTINCT)) {
            return this.buildSelectClauseCountDistinct(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MAX)) {
            return this.buildSelectClauseMax(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MIN)) {
            return this.buildSelectClauseMin(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.SUM)) {
            return this.buildSelectClauseSum(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.AVG)) {
            return this.buildSelectClauseAvg(aliasName);
        }
        String msg = "The type of select clause is not for scalar:";
        msg = msg + " type=" + (Object)((Object)this._selectClauseType);
        throw new IllegalStateException(msg);
    }

    protected String buildSelectClauseCount() {
        return "select count(*)";
    }

    protected String buildSelectClauseCountDistinct(String aliasName) {
        return this.buildSelectClauseSpecifiedScalar(aliasName, "count(distinct");
    }

    protected String buildSelectClauseMax(String aliasName) {
        return this.buildSelectClauseSpecifiedScalar(aliasName, "max");
    }

    protected String buildSelectClauseMin(String aliasName) {
        return this.buildSelectClauseSpecifiedScalar(aliasName, "min");
    }

    protected String buildSelectClauseSum(String aliasName) {
        return this.buildSelectClauseSpecifiedScalar(aliasName, "sum");
    }

    protected String buildSelectClauseAvg(String aliasName) {
        return this.buildSelectClauseSpecifiedScalar(aliasName, "avg");
    }

    protected String buildSelectClauseSpecifiedScalar(String aliasName, String function) {
        String columnAlias = this.getScalarSelectColumnAlias();
        ColumnSqlName columnSqlName = this.getSpecifiedColumnSqlNameAsOne();
        ColumnInfo columnInfo = this.getSpecifiedColumnInfoAsOne();
        if (columnSqlName != null) {
            String valueExp = aliasName + "." + columnSqlName;
            String functionExp = this.doBuildFunctionExp(function, this.decryptSelectColumnIfNeeds(columnInfo, valueExp));
            return "select " + functionExp + " as " + columnAlias;
        }
        String subQuery = this.getSpecifiedDerivingSubQueryAsOne();
        if (subQuery != null) {
            if (this.hasUnionQuery()) {
                String valueExp = aliasName + "." + columnAlias;
                return "select " + this.doBuildFunctionExp(function, this.decryptSelectColumnIfNeeds(columnInfo, valueExp));
            }
            String aliasDef = " as " + columnAlias;
            StringBuilder sb = new StringBuilder();
            String pureSubQuery = Srl.substringLastFront(subQuery, aliasDef);
            String aliasDefRear = Srl.substringLastRear(subQuery, aliasDef);
            String functionExp = this.doBuildFunctionExp(function, pureSubQuery);
            sb.append("select ").append(functionExp).append(aliasDef).append(aliasDefRear);
            return sb.toString();
        }
        String msg = "Not found specifed column for scalar: function=" + function;
        throw new IllegalStateException(msg);
    }

    protected String doBuildFunctionExp(String function, String columnExp) {
        String frontConnector = function.contains("(") ? " " : "(";
        String functionExp = function + frontConnector + columnExp + ")";
        return this._scalarSelectOption != null ? this._scalarSelectOption.filterFunction(functionExp) : functionExp;
    }

    @Override
    public Map<String, Integer> getSelectIndexMap() {
        return this._selectIndexMap;
    }

    @Override
    public Map<String, String> getSelectIndexReverseMap() {
        return this._selectIndexReverseMap;
    }

    protected void registerSelectIndex(String keyName, String onQueryName, Integer selectIndex) {
        if (this._selectIndexMap == null) {
            this._selectIndexMap = this.createSelectIndexMap();
        }
        this._selectIndexMap.put(keyName, selectIndex);
        if (this._selectIndexReverseMap == null) {
            this._selectIndexReverseMap = this.createSelectIndexMap();
        }
        this._selectIndexReverseMap.put(onQueryName, keyName);
    }

    protected <VALUE> Map<String, VALUE> createSelectIndexMap() {
        return StringKeyMap.createAsFlexible();
    }

    protected String buildSelectIndexAlias(ColumnSqlName sqlName, String aliasName, Integer selectIndex) {
        if (sqlName.hasIrregularChar()) {
            return "c" + selectIndex;
        }
        String baseName = aliasName != null ? aliasName : sqlName.toString();
        int aliasNameLimitSize = this.getAliasNameLimitSize();
        if (baseName.length() > aliasNameLimitSize) {
            int aliasNameBaseSize = aliasNameLimitSize - 10;
            return Srl.substring(baseName, 0, aliasNameBaseSize) + "_c" + selectIndex;
        }
        return baseName;
    }

    protected int getAliasNameLimitSize() {
        return 30;
    }

    @Override
    public void disableSelectIndex() {
        this._useSelectIndex = false;
    }

    @Override
    public String getSelectHint() {
        return this.createSelectHint();
    }

    protected void appendSelectHint(StringBuilder sb) {
        sb.append(SELECT_HINT);
    }

    @Override
    public String getFromClause() {
        this.reflectClauseLazilyIfExists();
        StringBuilder sb = new StringBuilder();
        this.buildFromClause(sb);
        return sb.toString();
    }

    protected void buildFromClause(StringBuilder sb) {
        sb.append(this.ln()).append("  ");
        sb.append("from ");
        int tablePos = 7;
        if (this.isJoinInParentheses()) {
            for (int i = 0; i < this.getOuterJoinMap().size(); ++i) {
                sb.append("(");
                ++tablePos;
            }
        }
        TableSqlName tableSqlName = this.getDBMeta().getTableSqlName();
        String basePointAliasName = this.getBasePointAliasName();
        if (this.hasBaseTableInlineWhereClause()) {
            List<QueryClause> baseTableInlineWhereList = this.getBaseTableInlineWhereList();
            sb.append(this.getInlineViewClause(tableSqlName, baseTableInlineWhereList, tablePos));
            sb.append(" ").append(basePointAliasName);
        } else {
            sb.append(tableSqlName).append(" ").append(basePointAliasName);
        }
        sb.append(this.getFromBaseTableHint());
        sb.append(this.getLeftOuterJoinClause());
    }

    @Override
    public String getFromBaseTableHint() {
        return this.createFromBaseTableHint();
    }

    protected String getLeftOuterJoinClause() {
        StringBuilder sb = new StringBuilder();
        this.checkFixedConditionLazily();
        this.reflectInnerJoinAutoDetectLazily();
        boolean countLeastJoinAllowed = this.checkCountLeastJoinAllowed();
        boolean structuralPossibleInnerJoinAllowed = this.checkStructuralPossibleInnerJoinAllowed();
        for (Map.Entry<String, LeftOuterJoinInfo> outerJoinEntry : this.getOuterJoinMap().entrySet()) {
            String foreignAliasName = outerJoinEntry.getKey();
            LeftOuterJoinInfo joinInfo = outerJoinEntry.getValue();
            if (countLeastJoinAllowed && this.canBeCountLeastJoin(joinInfo)) continue;
            this.buildLeftOuterJoinClause(sb, foreignAliasName, joinInfo, structuralPossibleInnerJoinAllowed);
        }
        return sb.toString();
    }

    protected void checkFixedConditionLazily() {
        if (this._fixedConditionLazyChecker != null && !this._fixedConditionLazyChecker.isEmpty()) {
            for (FixedConditionLazyChecker lazyChecker : this._fixedConditionLazyChecker) {
                lazyChecker.check();
            }
        }
    }

    protected void reflectInnerJoinAutoDetectLazily() {
        if (!this.hasInnerJoinLazyReflector()) {
            return;
        }
        List<InnerJoinLazyReflector> reflectorList = this.getInnerJoinLazyReflectorList();
        for (InnerJoinLazyReflector reflector : reflectorList) {
            reflector.reflect();
        }
        reflectorList.clear();
    }

    protected boolean checkCountLeastJoinAllowed() {
        if (!this.canPagingCountLeastJoin()) {
            return false;
        }
        if (!this.isSelectClauseTypeNonUnionCount()) {
            return false;
        }
        return !this.hasFixedConditionOverRelationJoin();
    }

    protected boolean checkStructuralPossibleInnerJoinAllowed() {
        if (!this._structuralPossibleInnerJoinAllowed) {
            return false;
        }
        return !this.hasFixedConditionOverRelationJoin();
    }

    protected boolean hasFixedConditionOverRelationJoin() {
        for (LeftOuterJoinInfo joinInfo : this.getOuterJoinMap().values()) {
            if (!joinInfo.hasFixedConditionOverRelation()) continue;
            return true;
        }
        return false;
    }

    protected boolean canBeCountLeastJoin(LeftOuterJoinInfo joinInfo) {
        return !joinInfo.isCountableJoin();
    }

    protected void buildLeftOuterJoinClause(StringBuilder sb, String foreignAliasName, LeftOuterJoinInfo joinInfo, boolean structuralPossibleInnerJoinAllowed) {
        Map<ColumnRealName, ColumnRealName> joinOnMap = joinInfo.getJoinOnMap();
        this.assertJoinOnMapNotEmpty(joinOnMap, foreignAliasName);
        sb.append(this.ln()).append("   ");
        boolean canBeInnerJoin = this.canBeInnerJoin(joinInfo, structuralPossibleInnerJoinAllowed);
        String joinExp = canBeInnerJoin ? " inner join " : " left outer join ";
        sb.append(joinExp);
        this.buildJoinTableClause(sb, joinInfo, joinExp, canBeInnerJoin);
        sb.append(" ").append(foreignAliasName);
        if (joinInfo.hasInlineOrOnClause() || joinInfo.hasFixedCondition()) {
            sb.append(this.ln()).append("     ");
        }
        sb.append(" on ");
        this.buildJoinOnClause(sb, joinInfo, joinOnMap);
        if (this.isJoinInParentheses()) {
            sb.append(")");
        }
    }

    protected boolean canBeInnerJoin(LeftOuterJoinInfo joinInfo, boolean structuralPossibleInnerJoinAllowed) {
        if (joinInfo.isInnerJoin()) {
            return true;
        }
        if (structuralPossibleInnerJoinAllowed) {
            return joinInfo.isStructuralPossibleInnerJoin();
        }
        return false;
    }

    protected boolean isJoinInParentheses() {
        return false;
    }

    protected void buildJoinTableClause(StringBuilder sb, LeftOuterJoinInfo joinInfo, String joinExp, boolean canBeInnerJoin) {
        String foreignTableDbName = joinInfo.getForeignTableDbName();
        int tablePos = 3 + joinExp.length();
        DBMeta foreignDBMeta = this.findDBMeta(foreignTableDbName);
        TableSqlName foreignTableSqlName = foreignDBMeta.getTableSqlName();
        List<QueryClause> inlineWhereClauseList = joinInfo.getInlineWhereClauseList();
        String tableExp = inlineWhereClauseList.isEmpty() ? foreignTableSqlName.toString() : this.getInlineViewClause(foreignTableSqlName, inlineWhereClauseList, tablePos);
        if (joinInfo.hasFixedCondition()) {
            sb.append(joinInfo.resolveFixedInlineView(tableExp, canBeInnerJoin));
        } else {
            sb.append(tableExp);
        }
    }

    protected String getInlineViewClause(TableSqlName inlineTableSqlName, List<QueryClause> inlineWhereClauseList, int tablePos) {
        String inlineBaseAlias = this.getInlineViewBasePointAlias();
        StringBuilder sb = new StringBuilder();
        sb.append("(select * from ").append(inlineTableSqlName).append(" ").append(inlineBaseAlias);
        String baseIndent = this.buildSpaceBar(tablePos + 1);
        sb.append(this.ln()).append(baseIndent);
        sb.append(" where ");
        int count = 0;
        for (QueryClause whereClause : inlineWhereClauseList) {
            String clauseElement = this.filterWhereClauseSimply(((Object)whereClause).toString());
            if (count > 0) {
                sb.append(this.ln()).append(baseIndent);
                sb.append("   and ");
            }
            sb.append(clauseElement);
            ++count;
        }
        sb.append(")");
        return sb.toString();
    }

    protected void buildJoinOnClause(StringBuilder sb, LeftOuterJoinInfo joinInfo, Map<ColumnRealName, ColumnRealName> joinOnMap) {
        int currentConditionCount = 0;
        currentConditionCount = this.doBuildJoinOnClauseBasic(sb, joinInfo, joinOnMap, currentConditionCount);
        currentConditionCount = this.doBuildJoinOnClauseFixed(sb, joinInfo, joinOnMap, currentConditionCount);
        currentConditionCount = this.doBuildJoinOnClauseAdditional(sb, joinInfo, joinOnMap, currentConditionCount);
    }

    protected int doBuildJoinOnClauseBasic(StringBuilder sb, LeftOuterJoinInfo joinInfo, Map<ColumnRealName, ColumnRealName> joinOnMap, int currentConditionCount) {
        for (Map.Entry<ColumnRealName, ColumnRealName> joinOnEntry : joinOnMap.entrySet()) {
            ColumnRealName localRealName = joinOnEntry.getKey();
            ColumnRealName foreignRealName = joinOnEntry.getValue();
            sb.append(currentConditionCount > 0 ? " and " : "");
            sb.append(localRealName).append(" = ").append(foreignRealName);
            ++currentConditionCount;
        }
        return currentConditionCount;
    }

    protected int doBuildJoinOnClauseFixed(StringBuilder sb, LeftOuterJoinInfo joinInfo, Map<ColumnRealName, ColumnRealName> joinOnMap, int currentConditionCount) {
        if (joinInfo.hasFixedCondition()) {
            String fixedCondition = joinInfo.getFixedCondition();
            if (this.isInlineViewOptimizedCondition(fixedCondition)) {
                return currentConditionCount;
            }
            sb.append(this.ln()).append("    ");
            sb.append(currentConditionCount > 0 ? " and " : "");
            sb.append(fixedCondition);
            ++currentConditionCount;
        }
        return currentConditionCount;
    }

    protected boolean isInlineViewOptimizedCondition(String fixedCondition) {
        return "$$optimized$$".equals(fixedCondition);
    }

    protected int doBuildJoinOnClauseAdditional(StringBuilder sb, LeftOuterJoinInfo joinInfo, Map<ColumnRealName, ColumnRealName> joinOnMap, int currentConditionCount) {
        List<QueryClause> additionalOnClauseList = joinInfo.getAdditionalOnClauseList();
        for (QueryClause additionalOnClause : additionalOnClauseList) {
            sb.append(this.ln()).append("    ");
            sb.append(currentConditionCount > 0 ? " and " : "");
            sb.append(additionalOnClause);
            ++currentConditionCount;
        }
        return currentConditionCount;
    }

    @Override
    public String getFromHint() {
        return this.createFromHint();
    }

    @Override
    public String getWhereClause() {
        this.reflectClauseLazilyIfExists();
        StringBuilder sb = new StringBuilder();
        this.buildWhereClause(sb);
        return sb.toString();
    }

    protected void buildWhereClause(StringBuilder sb) {
        this.buildWhereClause(sb, false);
    }

    protected void buildWhereClause(StringBuilder sb, boolean template) {
        List<QueryClause> whereList = this.getWhereList();
        if (whereList.isEmpty()) {
            if (template) {
                sb.append(" ").append(this.getWhereClauseMark());
            }
            return;
        }
        int count = 0;
        for (QueryClause whereClause : whereList) {
            String clauseElement = this.filterWhereClauseSimply(((Object)whereClause).toString());
            if (count == 0) {
                sb.append(this.ln()).append(" ");
                sb.append("where ").append(template ? this.getWhereFirstConditionMark() : "").append(clauseElement);
            } else {
                sb.append(this.ln()).append("  ");
                sb.append(" and ").append(clauseElement);
            }
            ++count;
        }
    }

    @Override
    public String getOrderByClause() {
        this.reflectClauseLazilyIfExists();
        OrderByClause orderBy = this.getOrderBy();
        String orderByClause = null;
        if (this.hasUnionQuery()) {
            Map<String, String> selectClauseRealColumnAliasMap = this.getSelectClauseRealColumnAliasMap();
            if (selectClauseRealColumnAliasMap.isEmpty()) {
                String msg = "The selectClauseColumnAliasMap should not be empty when union query exists.";
                throw new IllegalStateException(msg);
            }
            orderByClause = orderBy.getOrderByClause(selectClauseRealColumnAliasMap);
        } else {
            orderByClause = orderBy.getOrderByClause();
        }
        if (orderByClause != null && orderByClause.trim().length() > 0) {
            return this.ln() + " " + orderByClause;
        }
        return orderByClause;
    }

    @Override
    public String getSqlSuffix() {
        this.reflectClauseLazilyIfExists();
        String sqlSuffix = this.createSqlSuffix();
        if (sqlSuffix != null && sqlSuffix.trim().length() > 0) {
            return this.ln() + sqlSuffix;
        }
        return sqlSuffix;
    }

    @Override
    public void registerSelectedRelation(String foreignTableAliasName, String localTableDbName, String foreignPropertyName, String localRelationPath, String foreignRelationPath) {
        this.assertObjectNotNull("foreignTableAliasName", foreignTableAliasName);
        this.assertObjectNotNull("localTableDbName", localTableDbName);
        this.assertObjectNotNull("foreignPropertyName", foreignPropertyName);
        this.assertObjectNotNull("foreignRelationPath", foreignRelationPath);
        this.getSelectedRelationBasicMap().put(foreignRelationPath, foreignPropertyName);
        Map<String, SelectedRelationColumn> columnMap = this.createSelectedSelectColumnInfo(foreignTableAliasName, localTableDbName, foreignPropertyName, localRelationPath);
        this.getSelectedRelationColumnMap().put(foreignTableAliasName, columnMap);
        this.analyzeSelectedNextConnectingRelation(foreignRelationPath);
    }

    protected Map<String, String> getSelectedRelationBasicMap() {
        if (this._selectedRelationBasicMap == null) {
            this._selectedRelationBasicMap = new LinkedHashMap<String, String>();
        }
        return this._selectedRelationBasicMap;
    }

    protected Map<String, SelectedRelationColumn> createSelectedSelectColumnInfo(String foreignTableAliasName, String localTableDbName, String foreignPropertyName, String localRelationPath) {
        DBMeta dbmeta = this.findDBMeta(localTableDbName);
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        int relationNo = foreignInfo.getRelationNo();
        String nextRelationPath = "_" + relationNo;
        if (localRelationPath != null) {
            nextRelationPath = localRelationPath + nextRelationPath;
        }
        LinkedHashMap<String, SelectedRelationColumn> resultMap = new LinkedHashMap<String, SelectedRelationColumn>();
        DBMeta foreignDBMeta = foreignInfo.getForeignDBMeta();
        List<ColumnInfo> columnInfoList = foreignDBMeta.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnDbName = columnInfo.getColumnDbName();
            SelectedRelationColumn selectColumnInfo = new SelectedRelationColumn();
            selectColumnInfo.setTableAliasName(foreignTableAliasName);
            selectColumnInfo.setColumnInfo(columnInfo);
            selectColumnInfo.setColumnAliasName(columnDbName + nextRelationPath);
            resultMap.put(columnDbName, selectColumnInfo);
        }
        return resultMap;
    }

    protected void analyzeSelectedNextConnectingRelation(String foreignRelationPath) {
        if (foreignRelationPath.length() <= 3) {
            return;
        }
        String delimiter = "_";
        int delimiterCount = Srl.count(foreignRelationPath, "_");
        if (delimiterCount < 2) {
            return;
        }
        String previousPath = Srl.substringLastFront(foreignRelationPath, "_");
        Set<String> selectecNextConnectingRelationSet = this.getSelectedNextConnectingRelationSet();
        selectecNextConnectingRelationSet.add(previousPath);
    }

    @Override
    public int getSelectedRelationCount() {
        return this._selectedRelationBasicMap != null ? this._selectedRelationBasicMap.size() : 0;
    }

    @Override
    public boolean isSelectedRelationEmpty() {
        return this._selectedRelationBasicMap == null || this._selectedRelationBasicMap.isEmpty();
    }

    @Override
    public boolean hasSelectedRelation(String foreignRelationPath) {
        return this._selectedRelationBasicMap != null && this._selectedRelationBasicMap.containsKey(foreignRelationPath);
    }

    @Override
    public Map<String, Map<String, SelectedRelationColumn>> getSelectedRelationColumnMap() {
        if (this._selectedRelationColumnMap == null) {
            this._selectedRelationColumnMap = new LinkedHashMap<String, Map<String, SelectedRelationColumn>>();
        }
        return this._selectedRelationColumnMap;
    }

    @Override
    public boolean isSelectedNextConnectingRelation(String foreignRelationPath) {
        return this._selectedNextConnectingRelationSet != null && this._selectedNextConnectingRelationSet.contains(foreignRelationPath);
    }

    protected Set<String> getSelectedNextConnectingRelationSet() {
        if (this._selectedNextConnectingRelationSet == null) {
            this._selectedNextConnectingRelationSet = new HashSet<String>();
        }
        return this._selectedNextConnectingRelationSet;
    }

    @Override
    public void registerOuterJoin(String foreignAliasName, String foreignTableDbName, String localAliasName, String localTableDbName, Map<ColumnRealName, ColumnRealName> joinOnMap, ForeignInfo foreignInfo, String fixedCondition, FixedConditionResolver fixedConditionResolver) {
        this.doRegisterOuterJoin(foreignAliasName, foreignTableDbName, localAliasName, localTableDbName, joinOnMap, foreignInfo, fixedCondition, fixedConditionResolver);
    }

    @Override
    public void registerOuterJoinFixedInline(String foreignAliasName, String foreignTableDbName, String localAliasName, String localTableDbName, Map<ColumnRealName, ColumnRealName> joinOnMap, ForeignInfo foreignInfo, String fixedCondition, FixedConditionResolver fixedConditionResolver) {
        this.doRegisterOuterJoin(foreignAliasName, foreignTableDbName, localAliasName, localTableDbName, joinOnMap, foreignInfo, null, null);
        if (fixedCondition != null) {
            if (fixedConditionResolver != null) {
                fixedCondition = fixedConditionResolver.resolveVariable(fixedCondition, true);
            }
            String inlineBaseAlias = this.getInlineViewBasePointAlias();
            String clause = Srl.replace(fixedCondition, foreignAliasName + ".", inlineBaseAlias + ".");
            this.registerOuterJoinInlineWhereClause(foreignAliasName, clause, false);
        }
    }

    protected void doRegisterOuterJoin(String foreignAliasName, String foreignTableDbName, String localAliasName, String localTableDbName, Map<ColumnRealName, ColumnRealName> joinOnMap, ForeignInfo foreignInfo, String fixedCondition, FixedConditionResolver fixedConditionResolver) {
        this.assertAlreadyOuterJoin(foreignAliasName);
        this.assertJoinOnMapNotEmpty(joinOnMap, foreignAliasName);
        Map<String, LeftOuterJoinInfo> outerJoinMap = this.getOuterJoinMap();
        LeftOuterJoinInfo joinInfo = new LeftOuterJoinInfo();
        joinInfo.setForeignAliasName(foreignAliasName);
        joinInfo.setForeignTableDbName(foreignTableDbName);
        joinInfo.setLocalAliasName(localAliasName);
        joinInfo.setLocalTableDbName(localTableDbName);
        joinInfo.setJoinOnMap(joinOnMap);
        LeftOuterJoinInfo localJoinInfo = outerJoinMap.get(localAliasName);
        if (localJoinInfo != null) {
            joinInfo.setLocalJoinInfo(localJoinInfo);
        }
        joinInfo.setPureFK(foreignInfo.isPureFK());
        joinInfo.setNotNullFKColumn(foreignInfo.isNotNullFKColumn());
        joinInfo.setFixedCondition(fixedCondition);
        joinInfo.setFixedConditionResolver(fixedConditionResolver);
        joinInfo.resolveFixedCondition();
        outerJoinMap.put(foreignAliasName, joinInfo);
    }

    @Override
    public void registerFixedConditionLazyChecker(FixedConditionLazyChecker checker) {
        if (this._fixedConditionLazyChecker == null) {
            this._fixedConditionLazyChecker = new ArrayList<FixedConditionLazyChecker>(4);
        }
        this._fixedConditionLazyChecker.add(checker);
    }

    @Override
    public Map<String, LeftOuterJoinInfo> getOuterJoinMap() {
        if (this._outerJoinMap == null) {
            this._outerJoinMap = new LinkedHashMap<String, LeftOuterJoinInfo>(4);
        }
        return this._outerJoinMap;
    }

    @Override
    public boolean hasOuterJoin() {
        return this._outerJoinMap != null && !this._outerJoinMap.isEmpty();
    }

    @Override
    public void changeToInnerJoin(String foreignAliasName) {
        this.doChangeToInnerJoin(foreignAliasName, false);
    }

    protected void doChangeToInnerJoin(String foreignAliasName, boolean autoDetect) {
        Map<String, LeftOuterJoinInfo> outerJoinMap = this.getOuterJoinMap();
        LeftOuterJoinInfo joinInfo = outerJoinMap.get(foreignAliasName);
        if (joinInfo == null) {
            String msg = "The foreignAliasName was not found:";
            msg = msg + " " + foreignAliasName + " in " + outerJoinMap.keySet();
            throw new IllegalStateException(msg);
        }
        joinInfo.setInnerJoin(true);
        this.reflectUnderInnerJoinToJoin(joinInfo, autoDetect);
    }

    protected void reflectUnderInnerJoinToJoin(LeftOuterJoinInfo foreignJoinInfo, boolean autoDetect) {
        for (LeftOuterJoinInfo currentJoinInfo = foreignJoinInfo.getLocalJoinInfo(); currentJoinInfo != null; currentJoinInfo = currentJoinInfo.getLocalJoinInfo()) {
            if (autoDetect) {
                currentJoinInfo.setInnerJoin(true);
                continue;
            }
            currentJoinInfo.setUnderInnerJoin(true);
        }
    }

    @Override
    public void allowInnerJoinAutoDetect() {
        this.allowStructuralPossibleInnerJoin();
        this.allowWhereUsedInnerJoin();
    }

    @Override
    public void suppressInnerJoinAutoDetect() {
        this.suppressStructuralPossibleInnerJoin();
        this.suppressWhereUsedInnerJoin();
    }

    @Override
    public void allowStructuralPossibleInnerJoin() {
        this._structuralPossibleInnerJoinAllowed = true;
    }

    @Override
    public void suppressStructuralPossibleInnerJoin() {
        this._structuralPossibleInnerJoinAllowed = false;
    }

    @Override
    public boolean isStructuralPossibleInnerJoinAllowed() {
        return this._structuralPossibleInnerJoinAllowed;
    }

    @Override
    public void allowWhereUsedInnerJoin() {
        this._whereUsedInnerJoinAllowed = true;
    }

    @Override
    public void suppressWhereUsedInnerJoin() {
        this._whereUsedInnerJoinAllowed = false;
    }

    @Override
    public boolean isWhereUsedInnerJoinAllowed() {
        return this._whereUsedInnerJoinAllowed;
    }

    protected List<InnerJoinLazyReflector> getInnerJoinLazyReflectorList() {
        if (this._innerJoinLazyReflector == null) {
            this._innerJoinLazyReflector = new ArrayList<InnerJoinLazyReflector>(4);
        }
        return this._innerJoinLazyReflector;
    }

    protected boolean hasInnerJoinLazyReflector() {
        return this._innerJoinLazyReflector != null && !this._innerJoinLazyReflector.isEmpty();
    }

    protected void assertAlreadyOuterJoin(String foreignAliasName) {
        if (this.getOuterJoinMap().containsKey(foreignAliasName)) {
            String msg = "The foreign alias name have already registered in outer join: " + foreignAliasName;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertJoinOnMapNotEmpty(Map<ColumnRealName, ColumnRealName> joinOnMap, String foreignAliasName) {
        if (joinOnMap.isEmpty()) {
            String msg = "The joinOnMap should not be empty: foreignAliasName=" + foreignAliasName;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void registerWhereClause(ColumnRealName columnRealName, ConditionKey key, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option, String usedAliasName) {
        this.assertObjectNotNull("columnRealName", columnRealName);
        this.assertObjectNotNull("key", key);
        this.assertObjectNotNull("value", value);
        this.assertStringNotNullAndNotTrimmedEmpty("usedAliasName", usedAliasName);
        List<QueryClause> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, columnRealName, key, value, cipher, option, false, false);
        this.reflectWhereUsedToJoin(usedAliasName);
        if (!ConditionKey.isNullaleConditionKey(key)) {
            this.registerInnerJoinLazyReflector(usedAliasName);
        }
    }

    @Override
    public void registerWhereClause(String clause, String usedAliasName) {
        this.registerWhereClause(clause, usedAliasName, false);
    }

    @Override
    public void registerWhereClause(String clause, String usedAliasName, boolean noWayInner) {
        this.assertStringNotNullAndNotTrimmedEmpty("clause", clause);
        this.assertStringNotNullAndNotTrimmedEmpty("usedAliasName", usedAliasName);
        List<QueryClause> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, clause);
        this.reflectWhereUsedToJoin(usedAliasName);
        if (!noWayInner) {
            this.registerInnerJoinLazyReflector(usedAliasName);
        }
    }

    @Override
    public void registerWhereClause(QueryClause clause, QueryUsedAliasInfo ... usedAliasInfos) {
        this.assertObjectNotNull("clause", clause);
        this.assertObjectNotNull("usedAliasInfos", usedAliasInfos);
        if (usedAliasInfos.length == 0) {
            String msg = "The argument 'usedAliasInfos' should not be empty.";
            throw new IllegalArgumentException(msg);
        }
        List<QueryClause> clauseList = this.getWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, clause);
        for (QueryUsedAliasInfo usedAliasInfo : usedAliasInfos) {
            String usedAliasName = usedAliasInfo.getUsedAliasName();
            this.reflectWhereUsedToJoin(usedAliasName);
            this.registerInnerJoinLazyReflector(usedAliasInfo);
        }
    }

    protected void reflectWhereUsedToJoin(String usedAliasName) {
        for (LeftOuterJoinInfo currentJoinInfo = this.getOuterJoinMap().get(usedAliasName); currentJoinInfo != null && !currentJoinInfo.isWhereUsedJoin(); currentJoinInfo = currentJoinInfo.getLocalJoinInfo()) {
            currentJoinInfo.setWhereUsedJoin(true);
        }
    }

    protected void registerInnerJoinLazyReflector(String usedAliasName) {
        if (this.isOutOfWhereUsedInnerJoin()) {
            return;
        }
        QueryUsedAliasInfo usedAliasInfo = new QueryUsedAliasInfo(usedAliasName, null);
        this.registerInnerJoinLazyReflector(usedAliasInfo);
    }

    protected void registerInnerJoinLazyReflector(QueryUsedAliasInfo usedAliasInfo) {
        if (this.isOutOfWhereUsedInnerJoin()) {
            return;
        }
        List<InnerJoinLazyReflector> reflectorList = this.getInnerJoinLazyReflectorList();
        reflectorList.add(this.createInnerJoinLazyReflector(usedAliasInfo));
    }

    protected boolean isOutOfWhereUsedInnerJoin() {
        return !this._whereUsedInnerJoinAllowed || this._orScopeQueryEffective;
    }

    protected InnerJoinLazyReflectorBase createInnerJoinLazyReflector(QueryUsedAliasInfo usedAliasInfo) {
        final String usedAliasName = usedAliasInfo.getUsedAliasName();
        return new InnerJoinLazyReflectorBase(usedAliasInfo.getInnerJoinAutoDetectNoWaySpeaker()){

            @Override
            protected void doReflect() {
                if (AbstractSqlClause.this.getOuterJoinMap().containsKey(usedAliasName)) {
                    AbstractSqlClause.this.doChangeToInnerJoin(usedAliasName, true);
                }
            }
        };
    }

    protected List<QueryClause> getWhereClauseList4Register() {
        if (this._orScopeQueryEffective) {
            return this.getTmpOrWhereList();
        }
        return this.getWhereList();
    }

    @Override
    public void exchangeFirstWhereClauseForLastOne() {
        List<QueryClause> whereList = this.getWhereList();
        if (whereList.size() > 1) {
            QueryClause first = whereList.get(0);
            QueryClause last = whereList.get(whereList.size() - 1);
            whereList.set(0, last);
            whereList.set(whereList.size() - 1, first);
        }
    }

    protected List<QueryClause> getWhereList() {
        if (this._whereList == null) {
            this._whereList = new ArrayList<QueryClause>(8);
        }
        return this._whereList;
    }

    @Override
    public boolean hasWhereClauseOnBaseQuery() {
        return this._whereList != null && !this._whereList.isEmpty();
    }

    @Override
    public void clearWhereClauseOnBaseQuery() {
        if (this._whereList != null) {
            this._whereList.clear();
        }
    }

    @Override
    public void registerBaseTableInlineWhereClause(ColumnSqlName columnSqlName, ConditionKey key, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option) {
        List<QueryClause> clauseList = this.getBaseTableInlineWhereClauseList4Register();
        String inlineBaseAlias = this.getInlineViewBasePointAlias();
        ColumnRealName columnRealName = ColumnRealName.create(inlineBaseAlias, columnSqlName);
        this.doRegisterWhereClause(clauseList, columnRealName, key, value, cipher, option, true, false);
    }

    @Override
    public void registerBaseTableInlineWhereClause(String value) {
        List<QueryClause> clauseList = this.getBaseTableInlineWhereClauseList4Register();
        this.doRegisterWhereClause(clauseList, value);
    }

    protected List<QueryClause> getBaseTableInlineWhereClauseList4Register() {
        if (this._orScopeQueryEffective) {
            return this.getTmpOrBaseTableInlineWhereList();
        }
        return this.getBaseTableInlineWhereList();
    }

    protected List<QueryClause> getBaseTableInlineWhereList() {
        if (this._baseTableInlineWhereList == null) {
            this._baseTableInlineWhereList = new ArrayList<QueryClause>(2);
        }
        return this._baseTableInlineWhereList;
    }

    @Override
    public boolean hasBaseTableInlineWhereClause() {
        return this._baseTableInlineWhereList != null && !this._baseTableInlineWhereList.isEmpty();
    }

    @Override
    public void clearBaseTableInlineWhereClause() {
        if (this._baseTableInlineWhereList != null) {
            this._baseTableInlineWhereList.clear();
        }
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String foreignAliasName, ColumnSqlName columnSqlName, ConditionKey key, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option, boolean onClause) {
        this.assertNotYetOuterJoin(foreignAliasName);
        List<QueryClause> clauseList = this.getOuterJoinInlineWhereClauseList4Register(foreignAliasName, onClause);
        String tableAliasName = onClause ? foreignAliasName : this.getInlineViewBasePointAlias();
        ColumnRealName columnRealName = ColumnRealName.create(tableAliasName, columnSqlName);
        this.doRegisterWhereClause(clauseList, columnRealName, key, value, cipher, option, true, onClause);
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String foreignAliasName, String clause, boolean onClause) {
        this.assertNotYetOuterJoin(foreignAliasName);
        List<QueryClause> clauseList = this.getOuterJoinInlineWhereClauseList4Register(foreignAliasName, onClause);
        this.doRegisterWhereClause(clauseList, clause);
    }

    protected List<QueryClause> getOuterJoinInlineWhereClauseList4Register(String foreignAliasName, boolean onClause) {
        LeftOuterJoinInfo joinInfo = this.getOuterJoinMap().get(foreignAliasName);
        List<QueryClause> clauseList = onClause ? (this._orScopeQueryEffective ? this.getTmpOrAdditionalOnClauseList(foreignAliasName) : joinInfo.getAdditionalOnClauseList()) : (this._orScopeQueryEffective ? this.getTmpOrOuterJoinInlineClauseList(foreignAliasName) : joinInfo.getInlineWhereClauseList());
        return clauseList;
    }

    protected void assertNotYetOuterJoin(String aliasName) {
        if (!this.getOuterJoinMap().containsKey(aliasName)) {
            String msg = "The alias name have not registered in outer join yet: " + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public boolean hasOuterJoinInlineWhereClause() {
        if (this._outerJoinMap == null) {
            return false;
        }
        for (Map.Entry<String, LeftOuterJoinInfo> entry : this._outerJoinMap.entrySet()) {
            LeftOuterJoinInfo joinInfo = entry.getValue();
            if (!joinInfo.hasInlineOrOnClause()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearOuterJoinInlineWhereClause() {
        if (this._outerJoinMap == null) {
            return;
        }
        for (Map.Entry<String, LeftOuterJoinInfo> entry : this._outerJoinMap.entrySet()) {
            LeftOuterJoinInfo joinInfo = entry.getValue();
            if (!joinInfo.hasInlineOrOnClause()) continue;
            joinInfo.getInlineWhereClauseList().clear();
            joinInfo.getAdditionalOnClauseList().clear();
        }
    }

    protected void doRegisterWhereClause(List<QueryClause> clauseList, ColumnRealName columnRealName, ConditionKey key, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option, final boolean inline, final boolean onClause) {
        key.addWhereClause(new ConditionValue.QueryModeProvider(){

            @Override
            public boolean isOrScopeQuery() {
                return AbstractSqlClause.this.isOrScopeQueryEffective();
            }

            @Override
            public boolean isInline() {
                return inline;
            }

            @Override
            public boolean isOnClause() {
                return onClause;
            }
        }, clauseList, columnRealName, value, cipher, option);
        this.markOrScopeQueryAndPart(clauseList);
    }

    protected void doRegisterWhereClause(List<QueryClause> clauseList, String clause) {
        this.doRegisterWhereClause(clauseList, new StringQueryClause(clause));
    }

    protected void doRegisterWhereClause(List<QueryClause> clauseList, QueryClause clause) {
        clauseList.add(clause);
        this.markOrScopeQueryAndPart(clauseList);
    }

    @Override
    public void makeOrScopeQueryEffective() {
        OrScopeQueryInfo tmpOrScopeQueryInfo = new OrScopeQueryInfo();
        if (this._currentTmpOrScopeQueryInfo != null) {
            this._currentTmpOrScopeQueryInfo.addChildInfo(tmpOrScopeQueryInfo);
        }
        this._currentTmpOrScopeQueryInfo = tmpOrScopeQueryInfo;
        this._orScopeQueryEffective = true;
    }

    @Override
    public void closeOrScopeQuery() {
        this.assertCurrentTmpOrScopeQueryInfo();
        OrScopeQueryInfo parentInfo = this._currentTmpOrScopeQueryInfo.getParentInfo();
        if (parentInfo != null) {
            this._currentTmpOrScopeQueryInfo = parentInfo;
        } else {
            this.reflectTmpOrClauseToRealObject(this._currentTmpOrScopeQueryInfo);
            this.clearOrScopeQuery();
        }
    }

    protected void clearOrScopeQuery() {
        this._currentTmpOrScopeQueryInfo = null;
        this._orScopeQueryEffective = false;
        this._orScopeQueryAndPartEffective = false;
    }

    protected void reflectTmpOrClauseToRealObject(OrScopeQueryInfo localInfo) {
        OrScopeQueryReflector reflector = this.createOrClauseReflector();
        reflector.reflectTmpOrClauseToRealObject(localInfo);
    }

    protected OrScopeQueryReflector createOrClauseReflector() {
        return new OrScopeQueryReflector(this.getWhereList(), this.getBaseTableInlineWhereList(), this.getOuterJoinMap());
    }

    @Override
    public boolean isOrScopeQueryEffective() {
        return this._orScopeQueryEffective;
    }

    @Override
    public boolean isOrScopeQueryAndPartEffective() {
        return this._orScopeQueryAndPartEffective;
    }

    protected List<QueryClause> getTmpOrWhereList() {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrWhereList();
    }

    protected List<QueryClause> getTmpOrBaseTableInlineWhereList() {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrBaseTableInlineWhereList();
    }

    protected List<QueryClause> getTmpOrAdditionalOnClauseList(String aliasName) {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrAdditionalOnClauseList(aliasName);
    }

    protected List<QueryClause> getTmpOrOuterJoinInlineClauseList(String aliasName) {
        this.assertCurrentTmpOrScopeQueryInfo();
        return this._currentTmpOrScopeQueryInfo.getTmpOrOuterJoinInlineClauseList(aliasName);
    }

    @Override
    public void beginOrScopeQueryAndPart() {
        this.assertCurrentTmpOrScopeQueryInfo();
        ++this._orScopeQueryAndPartIdentity;
        this._orScopeQueryAndPartEffective = true;
    }

    @Override
    public void endOrScopeQueryAndPart() {
        this.assertCurrentTmpOrScopeQueryInfo();
        this._orScopeQueryAndPartEffective = false;
    }

    protected void markOrScopeQueryAndPart(List<QueryClause> clauseList) {
        if (this._orScopeQueryEffective && this._orScopeQueryAndPartEffective && !clauseList.isEmpty()) {
            QueryClause original = clauseList.remove(clauseList.size() - 1);
            clauseList.add(new OrScopeQueryAndPartQueryClause(original, this._orScopeQueryAndPartIdentity));
        }
    }

    protected void assertCurrentTmpOrScopeQueryInfo() {
        if (this._currentTmpOrScopeQueryInfo == null) {
            String msg = "The attribute 'currentTmpOrScopeQueryInfo' should not be null in or-scope query:";
            msg = msg + " orScopeQueryEffective=" + this._orScopeQueryEffective;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public OrderByClause getOrderByComponent() {
        return this.getOrderBy();
    }

    protected OrderByClause getOrderBy() {
        if (this._orderByClause == null) {
            this._orderByClause = new OrderByClause();
        }
        return this._orderByClause;
    }

    @Override
    public OrderByElement getOrderByLastElement() {
        if (this._orderByClause == null) {
            return null;
        }
        return this._orderByClause.getOrderByLastElement();
    }

    @Override
    public void clearOrderBy() {
        this._orderByEffective = false;
        this.getOrderBy().clear();
    }

    @Override
    public void makeOrderByEffective() {
        if (this.hasOrderByClause()) {
            this._orderByEffective = true;
        }
    }

    @Override
    public void ignoreOrderBy() {
        this._orderByEffective = false;
    }

    @Override
    public void registerOrderBy(String orderByProperty, boolean ascOrDesc, ColumnInfo columnInfo) {
        this.doRegisterOrderBy(orderByProperty, ascOrDesc, columnInfo, false);
    }

    @Override
    public void registerSpecifiedDerivedOrderBy(String orderByProperty, boolean ascOrDesc) {
        HpDerivingSubQueryInfo specifiedDerivingInfo = this.getSpecifiedDerivingInfo(orderByProperty);
        if (specifiedDerivingInfo == null) {
            String msg = "The deriving column was not found by the property: " + orderByProperty;
            throw new IllegalStateException(msg);
        }
        ColumnInfo columnInfo = this.getSpecifiedDerivingColumnInfo(specifiedDerivingInfo);
        this.doRegisterOrderBy(orderByProperty, ascOrDesc, columnInfo, true);
    }

    protected void doRegisterOrderBy(String orderByProperty, boolean ascOrDesc, ColumnInfo columnInfo, boolean derived) {
        try {
            this._orderByEffective = true;
            ArrayList<String> orderByList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(orderByProperty, "/");
            while (st.hasMoreElements()) {
                orderByList.add(st.nextToken());
            }
            for (String orderBy : orderByList) {
                String columnName;
                String aliasName;
                this._orderByEffective = true;
                if (orderBy.indexOf(".") < 0) {
                    aliasName = null;
                    columnName = orderBy;
                } else {
                    aliasName = orderBy.substring(0, orderBy.lastIndexOf("."));
                    columnName = orderBy.substring(orderBy.lastIndexOf(".") + 1);
                }
                OrderByElement element = new OrderByElement(aliasName, columnName, columnInfo, derived);
                if (ascOrDesc) {
                    element.setupAsc();
                } else {
                    element.setupDesc();
                }
                element.setGearedCipherManager(this._gearedCipherManager);
                this.getOrderBy().addOrderByElement(element);
            }
        }
        catch (RuntimeException e) {
            String msg = "Failed to register order-by:";
            msg = msg + " orderByProperty=" + orderByProperty + " ascOrDesc=" + ascOrDesc;
            msg = msg + " table=" + this._tableDbName;
            throw new IllegalStateException(msg, e);
        }
    }

    @Override
    public void addNullsFirstToPreviousOrderBy() {
        this.getOrderBy().addNullsFirstToPreviousOrderByElement(this.createOrderByNullsSetupper());
    }

    @Override
    public void addNullsLastToPreviousOrderBy() {
        this.getOrderBy().addNullsLastToPreviousOrderByElement(this.createOrderByNullsSetupper());
    }

    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupper() {
        return new OrderByClause.OrderByNullsSetupper(){

            @Override
            public String setup(String columnName, String orderByElementClause, boolean nullsFirst) {
                return orderByElementClause + " nulls " + (nullsFirst ? "first" : "last");
            }
        };
    }

    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupperByCaseWhen() {
        return new OrderByClause.OrderByNullsSetupper(){

            @Override
            public String setup(String columnName, String orderByElementClause, boolean nullsFirst) {
                String thenNumber = nullsFirst ? "1" : "0";
                String elseNumber = nullsFirst ? "0" : "1";
                String caseWhen = "case when " + columnName + " is not null then " + thenNumber + " else " + elseNumber + " end asc";
                return caseWhen + ", " + orderByElementClause;
            }
        };
    }

    @Override
    public void addManualOrderToPreviousOrderByElement(ManualOrderBean manualOrderBean) {
        this.assertObjectNotNull("manualOrderBean", manualOrderBean);
        this.getOrderBy().addManualOrderByElement(manualOrderBean);
    }

    @Override
    public boolean hasOrderByClause() {
        return this._orderByClause != null && !this._orderByClause.isEmpty();
    }

    @Override
    public void registerUnionQuery(UnionClauseProvider unionClauseProvider, boolean unionAll) {
        this.assertObjectNotNull("unionClauseProvider", unionClauseProvider);
        UnionQueryInfo unionQueryInfo = new UnionQueryInfo();
        unionQueryInfo.setUnionClauseProvider(unionClauseProvider);
        unionQueryInfo.setUnionAll(unionAll);
        this.addUnionQueryInfo(unionQueryInfo);
    }

    protected void addUnionQueryInfo(UnionQueryInfo unionQueryInfo) {
        if (this._unionQueryInfoList == null) {
            this._unionQueryInfoList = new ArrayList<UnionQueryInfo>();
        }
        this._unionQueryInfoList.add(unionQueryInfo);
    }

    @Override
    public boolean hasUnionQuery() {
        return this._unionQueryInfoList != null && !this._unionQueryInfoList.isEmpty();
    }

    @Override
    public void clearUnionQuery() {
        if (this._unionQueryInfoList != null) {
            this._unionQueryInfoList.clear();
        }
    }

    @Override
    public void fetchFirst(int fetchSize) {
        this._fetchScopeEffective = true;
        if (fetchSize <= 0) {
            String msg = "Argument[fetchSize] should be plus: " + fetchSize;
            throw new IllegalArgumentException(msg);
        }
        this._fetchStartIndex = 0;
        this._fetchSize = fetchSize;
        this._fetchPageNumber = 1;
        this.doClearFetchPageClause();
        this.doFetchFirst();
    }

    @Override
    public void fetchScope(int fetchStartIndex, int fetchSize) {
        this._fetchScopeEffective = true;
        if (fetchStartIndex < 0) {
            String msg = "Argument[fetchStartIndex] must be plus or zero: " + fetchStartIndex;
            throw new IllegalArgumentException(msg);
        }
        if (fetchSize <= 0) {
            String msg = "Argument[fetchSize] should be plus: " + fetchSize;
            throw new IllegalArgumentException(msg);
        }
        this._fetchStartIndex = fetchStartIndex;
        this._fetchSize = fetchSize;
        this.fetchPage(1);
    }

    @Override
    public void fetchPage(int fetchPageNumber) {
        this._fetchScopeEffective = true;
        if (fetchPageNumber <= 0) {
            fetchPageNumber = 1;
        }
        if (this._fetchSize <= 0) {
            this.throwFetchSizeNotPlusException(fetchPageNumber);
        }
        this._fetchPageNumber = fetchPageNumber;
        if (this._fetchPageNumber == 1 && this._fetchStartIndex == 0) {
            this.fetchFirst(this._fetchSize);
        }
        this.doClearFetchPageClause();
        this.doFetchPage();
    }

    protected void throwFetchSizeNotPlusException(int fetchPageNumber) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Fetch size should not be minus or zero!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Fetch Size]" + this.ln();
        msg = msg + "fetchSize=" + this._fetchSize + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Fetch Page Number]" + this.ln();
        msg = msg + "fetchPageNumber=" + fetchPageNumber + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IllegalStateException(msg);
    }

    protected abstract void doFetchFirst();

    protected abstract void doFetchPage();

    protected abstract void doClearFetchPageClause();

    @Override
    public int getFetchStartIndex() {
        return this._fetchStartIndex;
    }

    @Override
    public int getFetchSize() {
        return this._fetchSize;
    }

    @Override
    public int getFetchPageNumber() {
        return this._fetchPageNumber;
    }

    @Override
    public int getPageStartIndex() {
        if (this._fetchPageNumber <= 0) {
            String msg = "_fetchPageNumber must be plus: " + this._fetchPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._fetchStartIndex + this._fetchSize * (this._fetchPageNumber - 1);
    }

    @Override
    public int getPageEndIndex() {
        if (this._fetchPageNumber <= 0) {
            String msg = "_fetchPageNumber must be plus: " + this._fetchPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._fetchStartIndex + this._fetchSize * this._fetchPageNumber;
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this._fetchScopeEffective;
    }

    @Override
    public void ignoreFetchScope() {
        this._fetchScopeEffective = false;
        this.doClearFetchPageClause();
    }

    @Override
    public void makeFetchScopeEffective() {
        if (this.getFetchSize() > 0 && this.getFetchPageNumber() > 0) {
            this.fetchPage(this.getFetchPageNumber());
        }
    }

    @Override
    public boolean isFetchStartIndexSupported() {
        return true;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return true;
    }

    protected abstract String createSelectHint();

    protected abstract String createFromBaseTableHint();

    protected abstract String createFromHint();

    protected abstract String createSqlSuffix();

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getPageStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getFetchSize();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this._fetchScopeEffective;
    }

    @Override
    public String getBasePointAliasName() {
        return this.isForSubQuery() ? "sub" + this.getSubQueryLevel() + "loc" : "dfloc";
    }

    @Override
    public String resolveJoinAliasName(String relationPath, int nestLevel) {
        return (this.isForSubQuery() ? "sub" + this.getSubQueryLevel() : "df") + "rel" + relationPath;
    }

    @Override
    public int resolveRelationNo(String localTableName, String foreignPropertyName) {
        DBMeta dbmeta = this.findDBMeta(localTableName);
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        return foreignInfo.getRelationNo();
    }

    @Override
    public String getInlineViewBasePointAlias() {
        return "dfinlineloc";
    }

    @Override
    public String getUnionQueryInlineViewAlias() {
        return "dfunionview";
    }

    @Override
    public String getDerivedReferrerNestedAlias() {
        return "dfrefview";
    }

    @Override
    public String getScalarSelectColumnAlias() {
        return "dfscalar";
    }

    @Override
    public String getWhereClauseMark() {
        return "#df:whereClause#";
    }

    @Override
    public String getWhereFirstConditionMark() {
        return "#df:whereFirstCondition#";
    }

    @Override
    public String getUnionSelectClauseMark() {
        return "#df:unionSelectClause#";
    }

    @Override
    public String getUnionWhereClauseMark() {
        return "#df:unionWhereClause#";
    }

    @Override
    public String getUnionWhereFirstConditionMark() {
        return "#df:unionWhereFirstCondition#";
    }

    @Override
    public String resolveSubQueryBeginMark(String subQueryIdentity) {
        return this.getSubQueryIndentProcessor().resolveSubQueryBeginMark(subQueryIdentity);
    }

    @Override
    public String resolveSubQueryEndMark(String subQueryIdentity) {
        return this.getSubQueryIndentProcessor().resolveSubQueryEndMark(subQueryIdentity);
    }

    @Override
    public String processSubQueryIndent(String sql) {
        return this.processSubQueryIndent(sql, "", sql);
    }

    protected String processSubQueryIndent(String sql, String preIndent, String originalSql) {
        return this.getSubQueryIndentProcessor().processSubQueryIndent(sql, preIndent, originalSql);
    }

    protected SubQueryIndentProcessor getSubQueryIndentProcessor() {
        if (this._subQueryIndentProcessor == null) {
            this._subQueryIndentProcessor = new SubQueryIndentProcessor();
        }
        return this._subQueryIndentProcessor;
    }

    @Override
    public void specifySelectColumn(HpSpecifiedColumn specifiedColumn) {
        String tableAliasName;
        if (this._specifiedSelectColumnMap == null) {
            this._specifiedSelectColumnMap = StringKeyMap.createAsFlexible();
        }
        if (!this._specifiedSelectColumnMap.containsKey(tableAliasName = specifiedColumn.getTableAliasName())) {
            StringKeyMap elementMap = StringKeyMap.createAsFlexibleOrdered();
            this._specifiedSelectColumnMap.put(tableAliasName, elementMap);
        }
        String columnDbName = specifiedColumn.getColumnDbName();
        Map<String, HpSpecifiedColumn> elementMap = this._specifiedSelectColumnMap.get(tableAliasName);
        elementMap.put(columnDbName, specifiedColumn);
    }

    @Override
    public boolean hasSpecifiedSelectColumn(String tableAliasName) {
        return this._specifiedSelectColumnMap != null && this._specifiedSelectColumnMap.containsKey(tableAliasName);
    }

    @Override
    public boolean hasSpecifiedSelectColumn(String tableAliasName, String columnDbName) {
        if (this._specifiedSelectColumnMap == null) {
            return false;
        }
        Map<String, HpSpecifiedColumn> elementMap = this._specifiedSelectColumnMap.get(tableAliasName);
        if (elementMap == null) {
            return false;
        }
        return elementMap.containsKey(columnDbName);
    }

    @Override
    public void handleSpecifiedSelectColumn(String tableAliasName, SpecifiedSelectColumnHandler columnHandler) {
        if (this._specifiedSelectColumnMap == null) {
            return;
        }
        Map<String, HpSpecifiedColumn> elementMap = this._specifiedSelectColumnMap.get(tableAliasName);
        if (elementMap == null) {
            return;
        }
        for (HpSpecifiedColumn specifiedColumn : elementMap.values()) {
            columnHandler.handle(tableAliasName, specifiedColumn);
        }
    }

    @Override
    public void backupSpecifiedSelectColumn() {
        this._backupSpecifiedSelectColumnMap = this._specifiedSelectColumnMap;
    }

    @Override
    public void restoreSpecifiedSelectColumn() {
        this._specifiedSelectColumnMap = this._backupSpecifiedSelectColumnMap;
        this._backupSpecifiedSelectColumnMap = null;
    }

    @Override
    public void clearSpecifiedSelectColumn() {
        if (this._specifiedSelectColumnMap != null) {
            this._specifiedSelectColumnMap.clear();
            this._specifiedSelectColumnMap = null;
        }
    }

    @Override
    public String getSpecifiedColumnDbNameAsOne() {
        ColumnInfo columnInfo = this.getSpecifiedColumnInfoAsOne();
        return columnInfo != null ? columnInfo.getColumnDbName() : null;
    }

    @Override
    public ColumnInfo getSpecifiedColumnInfoAsOne() {
        Map<String, HpSpecifiedColumn> elementMap = this.getSpecifiedColumnElementMapAsOne();
        if (elementMap != null && elementMap.size() == 1) {
            return elementMap.values().iterator().next().getColumnInfo();
        }
        return null;
    }

    @Override
    public ColumnRealName getSpecifiedColumnRealNameAsOne() {
        ColumnSqlName columnSqlName = this.getSpecifiedColumnSqlNameAsOne();
        if (columnSqlName != null) {
            return ColumnRealName.create(this.getSpecifiedColumnTableAliasNameAsOne(), columnSqlName);
        }
        return null;
    }

    @Override
    public ColumnSqlName getSpecifiedColumnSqlNameAsOne() {
        ColumnInfo columnInfo = this.getSpecifiedColumnInfoAsOne();
        return columnInfo != null ? columnInfo.getColumnSqlName() : null;
    }

    protected String getSpecifiedColumnTableAliasNameAsOne() {
        if (this._specifiedSelectColumnMap != null && this._specifiedSelectColumnMap.size() == 1) {
            return this._specifiedSelectColumnMap.keySet().iterator().next();
        }
        return null;
    }

    protected Map<String, HpSpecifiedColumn> getSpecifiedColumnElementMapAsOne() {
        if (this._specifiedSelectColumnMap != null && this._specifiedSelectColumnMap.size() == 1) {
            return this._specifiedSelectColumnMap.values().iterator().next();
        }
        return null;
    }

    @Override
    public void specifyDerivingSubQuery(HpDerivingSubQueryInfo subQueryInfo) {
        if (this._specifiedDerivingSubQueryMap == null) {
            this._specifiedDerivingSubQueryMap = StringKeyMap.createAsFlexibleOrdered();
        }
        String aliasName = subQueryInfo.getAliasName();
        this._specifiedDerivingSubQueryMap.put(aliasName, subQueryInfo);
    }

    @Override
    public boolean hasSpecifiedDerivingSubQuery(String aliasName) {
        return this._specifiedDerivingSubQueryMap != null && this._specifiedDerivingSubQueryMap.containsKey(aliasName);
    }

    @Override
    public List<String> getSpecifiedDerivingAliasList() {
        if (this._specifiedDerivingSubQueryMap == null) {
            List emptyList = Collections.EMPTY_LIST;
            return emptyList;
        }
        return new ArrayList<String>(this._specifiedDerivingSubQueryMap.keySet());
    }

    @Override
    public HpDerivingSubQueryInfo getSpecifiedDerivingInfo(String aliasName) {
        if (this._specifiedDerivingSubQueryMap == null) {
            return null;
        }
        return this._specifiedDerivingSubQueryMap.get(aliasName);
    }

    protected ColumnInfo getSpecifiedDerivingColumnInfo(HpDerivingSubQueryInfo derivingInfo) {
        SqlClause subQuerySqlClause = derivingInfo.getDerivedReferrer().getSubQuerySqlClause();
        ColumnInfo columnInfo = subQuerySqlClause.getSpecifiedColumnInfoAsOne();
        if (columnInfo != null) {
            return columnInfo;
        }
        return subQuerySqlClause.getSpecifiedDerivingColumnInfoAsOne();
    }

    @Override
    public ColumnInfo getSpecifiedDerivingColumnInfoAsOne() {
        HpDerivingSubQueryInfo derivingInfo = this.getSpecifiedDerivingInfoAsOne();
        return derivingInfo != null ? this.getSpecifiedDerivingColumnInfo(derivingInfo) : null;
    }

    @Override
    public String getSpecifiedDerivingAliasNameAsOne() {
        HpDerivingSubQueryInfo derivingInfo = this.getSpecifiedDerivingInfoAsOne();
        return derivingInfo != null ? derivingInfo.getAliasName() : null;
    }

    @Override
    public String getSpecifiedDerivingSubQueryAsOne() {
        HpDerivingSubQueryInfo derivingInfo = this.getSpecifiedDerivingInfoAsOne();
        return derivingInfo != null ? derivingInfo.getDerivingSubQuery() : null;
    }

    protected HpDerivingSubQueryInfo getSpecifiedDerivingInfoAsOne() {
        if (this._specifiedDerivingSubQueryMap != null && this._specifiedDerivingSubQueryMap.size() == 1) {
            return this._specifiedDerivingSubQueryMap.values().iterator().next();
        }
        return null;
    }

    @Override
    public void clearSpecifiedDerivingSubQuery() {
        if (this._specifiedDerivingSubQueryMap != null) {
            this._specifiedDerivingSubQueryMap.clear();
            this._specifiedDerivingSubQueryMap = null;
        }
    }

    @Override
    public boolean isEmptyStringQueryAllowed() {
        return this._emptyStringQueryAllowed;
    }

    @Override
    public void allowEmptyStringQuery() {
        this._emptyStringQueryAllowed = true;
    }

    @Override
    public boolean isInvalidQueryChecked() {
        return this._invalidQueryChecked;
    }

    @Override
    public void checkInvalidQuery() {
        this._invalidQueryChecked = true;
    }

    @Override
    public void acceptInvalidQuery() {
        this._invalidQueryChecked = false;
    }

    @Override
    public List<HpInvalidQueryInfo> getInvalidQueryList() {
        return new ArrayList<HpInvalidQueryInfo>(this.doGetInvalidQueryList());
    }

    @Override
    public void saveInvalidQuery(HpInvalidQueryInfo invalidQueryInfo) {
        this.doGetInvalidQueryList().add(invalidQueryInfo);
    }

    protected List<HpInvalidQueryInfo> doGetInvalidQueryList() {
        if (this._invalidQueryList == null) {
            this._invalidQueryList = new ArrayList<HpInvalidQueryInfo>();
        }
        return this._invalidQueryList;
    }

    @Override
    public void addWhereClauseSimpleFilter(QueryClauseFilter whereClauseSimpleFilter) {
        if (this._whereClauseSimpleFilterList == null) {
            this._whereClauseSimpleFilterList = new ArrayList<QueryClauseFilter>();
        }
        this._whereClauseSimpleFilterList.add(whereClauseSimpleFilter);
    }

    protected String filterWhereClauseSimply(String clauseElement) {
        if (this._whereClauseSimpleFilterList == null || this._whereClauseSimpleFilterList.isEmpty()) {
            return clauseElement;
        }
        for (QueryClauseFilter filter : this._whereClauseSimpleFilterList) {
            if (filter == null) {
                String msg = "The list of filter should not have null: _whereClauseSimpleFilterList=" + this._whereClauseSimpleFilterList;
                throw new IllegalStateException(msg);
            }
            clauseElement = filter.filterClauseElement(clauseElement);
        }
        return clauseElement;
    }

    @Override
    public void classifySelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this.changeSelectClauseType(selectClauseType);
    }

    protected void changeSelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this.savePreviousSelectClauseType();
        this._selectClauseType = selectClauseType;
    }

    protected void savePreviousSelectClauseType() {
        this._previousSelectClauseType = this._selectClauseType;
    }

    @Override
    public void rollbackSelectClauseType() {
        this._selectClauseType = this._previousSelectClauseType != null ? this._previousSelectClauseType : DEFAULT_SELECT_CLAUSE_TYPE;
    }

    @Override
    public Map<String, Object> getColumnQueryObjectMap() {
        return this._columyQueryObjectMap;
    }

    @Override
    public String registerColumnQueryObjectToThemeList(String themeKey, Object addedValue) {
        if (this._columyQueryObjectMap == null) {
            this._columyQueryObjectMap = new LinkedHashMap<String, Object>();
        }
        int listIndex = this.doAddValueToThemeList(themeKey, addedValue, this._columyQueryObjectMap);
        return this.buildColumnQueryObjectBindExp(themeKey + ".get(" + listIndex + ")");
    }

    protected String buildColumnQueryObjectBindExp(String relativePath) {
        return "/*pmb.conditionQuery.colQyCBMap." + relativePath + ".conditionQuery.";
    }

    @Override
    public Map<String, Object> getManualOrderParameterMap() {
        return this._manualOrderParameterMap;
    }

    @Override
    public String registerManualOrderParameterToThemeList(String themeKey, Object addedValue) {
        if (this._manualOrderParameterMap == null) {
            this._manualOrderParameterMap = new LinkedHashMap<String, Object>();
        }
        int listIndex = this.doAddValueToThemeList(themeKey, addedValue, this._manualOrderParameterMap);
        return this.buildManualOrderParameterBindExp(themeKey + ".get(" + listIndex + ")");
    }

    protected String buildManualOrderParameterBindExp(String relativePath) {
        return "/*pmb.conditionQuery.mnuOdrPrmMap." + relativePath + "*/null";
    }

    @Override
    public Map<String, Object> getFreeParameterMap() {
        return this._freeParameterMap;
    }

    @Override
    public String registerFreeParameterToThemeList(String themeKey, Object addedValue) {
        if (this._freeParameterMap == null) {
            this._freeParameterMap = new LinkedHashMap<String, Object>();
        }
        int listIndex = this.doAddValueToThemeList(themeKey, addedValue, this._freeParameterMap);
        return this.buildFreeParameterBindExp(themeKey + ".get(" + listIndex + ")");
    }

    protected String buildFreeParameterBindExp(String relativePath) {
        return "/*pmb.conditionQuery.freePrmMap." + relativePath + "*/null";
    }

    protected int doAddValueToThemeList(String themeKey, Object addedValue, Map<String, Object> map) {
        ArrayList<Object> valueList = (ArrayList<Object>)map.get(themeKey);
        if (valueList == null) {
            valueList = new ArrayList<Object>();
            map.put(themeKey, valueList);
        }
        int listIndex = valueList.size();
        valueList.add(addedValue);
        return listIndex;
    }

    @Override
    public GearedCipherManager getGearedCipherManager() {
        return this._gearedCipherManager;
    }

    @Override
    public ColumnFunctionCipher findColumnFunctionCipher(ColumnInfo columnInfo) {
        ColumnFunctionCipher cipher;
        if (this._gearedCipherManager != null && (cipher = this._gearedCipherManager.findColumnFunctionCipher(columnInfo)) != null) {
            return cipher;
        }
        return null;
    }

    @Override
    public void makeSelectColumnDecryptionEffective() {
        this._suppressSelectColumnDecryption = false;
    }

    @Override
    public void suppressSelectColumnDecryption() {
        this._suppressSelectColumnDecryption = true;
    }

    protected String encryptIfNeeds(ColumnInfo columnInfo, String valueExp) {
        ColumnFunctionCipher cipher = this.findColumnFunctionCipher(columnInfo);
        return cipher != null ? cipher.encrypt(valueExp) : valueExp;
    }

    protected String decryptSelectColumnIfNeeds(ColumnInfo columnInfo, String valueExp) {
        if (this._suppressSelectColumnDecryption) {
            return valueExp;
        }
        return this.doDecryptIfNeeds(columnInfo, valueExp);
    }

    protected String doDecryptIfNeeds(ColumnInfo columnInfo, String valueExp) {
        ColumnFunctionCipher cipher = this.findColumnFunctionCipher(columnInfo);
        return cipher != null ? cipher.decrypt(valueExp) : valueExp;
    }

    @Override
    public void acceptScalarSelectOption(ScalarSelectOption option) {
        if (option != null) {
            option.xjudgeDatabase(this);
        }
        this._scalarSelectOption = option;
    }

    @Override
    public void makePagingAdjustmentEffective() {
        this._pagingAdjustment = true;
    }

    @Override
    public void ignorePagingAdjustment() {
        this._pagingAdjustment = false;
    }

    @Override
    public void enablePagingCountLater() {
        this._pagingCountLater = true;
    }

    @Override
    public void disablePagingCountLater() {
        this._pagingCountLater = false;
    }

    protected boolean canPagingCountLater() {
        return this._pagingAdjustment && this._pagingCountLater;
    }

    @Override
    public void enablePagingCountLeastJoin() {
        this._pagingCountLeastJoin = true;
    }

    @Override
    public void disablePagingCountLeastJoin() {
        this._pagingCountLeastJoin = false;
    }

    protected boolean canPagingCountLeastJoin() {
        return this._pagingAdjustment && this._pagingCountLeastJoin;
    }

    @Override
    public void registerClauseLazyReflector(ClauseLazyReflector clauseLazyReflector) {
        if (this._clauseLazyReflectorList == null) {
            this._clauseLazyReflectorList = new ArrayList<ClauseLazyReflector>();
        }
        this._clauseLazyReflectorList.add(clauseLazyReflector);
    }

    protected void reflectClauseLazilyIfExists() {
        if (this._clauseLazyReflectorList == null) {
            return;
        }
        for (ClauseLazyReflector reflector : this._clauseLazyReflectorList) {
            reflector.reflect();
        }
        this._clauseLazyReflectorList.clear();
    }

    @Override
    public String getClauseQueryInsert(Map<String, String> fixedValueQueryExpMap, SqlClause resourceSqlClause) {
        String resourceViewClause = resourceSqlClause.getClause();
        if (this._specifiedSelectColumnMap == null) {
            String msg = "The specified columns for query-insert are required.";
            throw new IllegalConditionBeanOperationException(msg);
        }
        Map<String, HpSpecifiedColumn> elementMap = this._specifiedSelectColumnMap.get(this.getBasePointAliasName());
        if (elementMap == null || elementMap.isEmpty()) {
            String msg = "The specified columns of inserted table for query-insert are required.";
            throw new IllegalConditionBeanOperationException(msg);
        }
        DBMeta dbmeta = this.getDBMeta();
        StringBuilder intoSb = new StringBuilder();
        StringBuilder selectSb = new StringBuilder();
        String resourceAlias = "dfres";
        int index = 0;
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String onQueryName;
            String columnDbName = columnInfo.getColumnDbName();
            HpSpecifiedColumn specifiedColumn = elementMap.get(columnDbName);
            if (specifiedColumn != null) {
                onQueryName = specifiedColumn.getValidMappedOnQueryName();
            } else {
                if (!fixedValueQueryExpMap.containsKey(columnDbName)) continue;
                String fixedValueQueryExp = fixedValueQueryExpMap.get(columnDbName);
                onQueryName = fixedValueQueryExp != null ? this.encryptIfNeeds(columnInfo, fixedValueQueryExp) : "null";
            }
            if (onQueryName == null || onQueryName.trim().length() == 0) {
                String msg = "The on-query name for query-insert is required: " + specifiedColumn;
                throw new IllegalConditionBeanOperationException(msg);
            }
            ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
            if (index > 0) {
                intoSb.append(", ");
                selectSb.append(", ");
            }
            intoSb.append(columnSqlName);
            if (specifiedColumn != null) {
                selectSb.append("dfres").append(".");
            }
            selectSb.append(onQueryName);
            ++index;
        }
        String subQueryIdentity = "queryInsertResource";
        String subQueryBeginMark = this.resolveSubQueryBeginMark("queryInsertResource");
        String subQueryEndMark = this.resolveSubQueryEndMark("queryInsertResource");
        StringBuilder mainSb = new StringBuilder();
        mainSb.append("insert into ").append(dbmeta.getTableSqlName());
        mainSb.append(" (").append((CharSequence)intoSb).append(")").append(this.ln());
        mainSb.append("select ").append((CharSequence)selectSb).append(this.ln());
        mainSb.append("  from (").append(subQueryBeginMark).append(this.ln());
        mainSb.append(resourceViewClause).append(this.ln());
        mainSb.append("       ) ").append("dfres").append(subQueryEndMark);
        String sql = mainSb.toString();
        return this.processSubQueryIndent(sql);
    }

    @Override
    public String getClauseQueryUpdate(Map<String, Object> columnParameterMap) {
        if (columnParameterMap == null) {
            String msg = "The argument 'columnParameterMap' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (columnParameterMap.isEmpty()) {
            return null;
        }
        DBMeta dbmeta = this.getDBMeta();
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(dbmeta.getTableSqlName());
        if (this.isUseQueryUpdateDirect(dbmeta)) {
            String whereClause = this.processSubQueryIndent(this.getWhereClause());
            this.buildQueryUpdateDirectClause(columnParameterMap, whereClause, dbmeta, sb);
        } else {
            this.buildQueryUpdateInScopeClause(columnParameterMap, dbmeta, sb);
        }
        return sb.toString();
    }

    protected boolean isUseQueryUpdateDirect(DBMeta dbmeta) {
        return this._queryUpdateForcedDirectAllowed || !this.canUseQueryUpdateInScope(dbmeta);
    }

    protected boolean canUseQueryUpdateInScope(DBMeta dbmeta) {
        return this.isUpdateSubQueryUseLocalTableSupported() && !dbmeta.hasCompoundPrimaryKey();
    }

    protected void buildQueryUpdateInScopeClause(Map<String, Object> columnParameterMap, DBMeta dbmeta, StringBuilder sb) {
        if (columnParameterMap != null) {
            this.buildQueryUpdateSetClause(columnParameterMap, dbmeta, sb, null);
        }
        ColumnSqlName primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnSqlName();
        String selectClause = "select " + this.getBasePointAliasName() + "." + primaryKeyName;
        String fromWhereClause = this.getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replace(fromWhereClause, this.getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replace(fromWhereClause, this.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replace(fromWhereClause, this.getUnionWhereFirstConditionMark(), "");
        String subQuery = this.processSubQueryIndent(selectClause + " " + fromWhereClause);
        sb.append(this.ln());
        sb.append(" where ").append(primaryKeyName);
        sb.append(" in (").append(this.ln()).append(subQuery);
        if (!subQuery.endsWith(this.ln())) {
            sb.append(this.ln());
        }
        sb.append(")");
    }

    protected void buildQueryUpdateDirectClause(Map<String, Object> columnParameterMap, String whereClause, DBMeta dbmeta, StringBuilder sb) {
        String basePointAliasName;
        if (this.hasUnionQuery()) {
            this.throwQueryUpdateUnavailableFunctionException("union", dbmeta);
        }
        boolean useAlias = false;
        if (this.isUpdateTableAliasNameSupported()) {
            if (this.hasQueryUpdateSubQueryPossible(whereClause)) {
                useAlias = true;
            }
        } else if (this.hasQueryUpdateSubQueryPossible(whereClause)) {
            this.throwQueryUpdateUnavailableFunctionException("sub-query", dbmeta);
        }
        boolean directJoin = false;
        if (this.isUpdateDirectJoinSupported()) {
            if (this.hasOuterJoin()) {
                useAlias = true;
                directJoin = true;
            }
        } else if (this.hasOuterJoin()) {
            this.throwQueryUpdateUnavailableFunctionException("outer join", dbmeta);
        }
        String string = basePointAliasName = useAlias ? this.getBasePointAliasName() : null;
        if (useAlias) {
            sb.append(" ").append(basePointAliasName);
        }
        if (directJoin) {
            sb.append(this.getLeftOuterJoinClause());
        }
        if (columnParameterMap != null) {
            String setClauseAliasName = useAlias ? basePointAliasName + "." : null;
            this.buildQueryUpdateSetClause(columnParameterMap, dbmeta, sb, setClauseAliasName);
        }
        if (Srl.is_Null_or_TrimmedEmpty(whereClause)) {
            return;
        }
        if (useAlias) {
            sb.append(whereClause);
        } else {
            sb.append(this.filterQueryUpdateBasePointAliasNameLocalUnsupported(whereClause));
        }
    }

    protected boolean hasQueryUpdateSubQueryPossible(String whereClause) {
        if (Srl.is_Null_or_TrimmedEmpty(whereClause)) {
            return false;
        }
        return whereClause.contains("exists (") || whereClause.contains("(select ");
    }

    protected void buildQueryUpdateSetClause(Map<String, Object> columnParameterMap, DBMeta dbmeta, StringBuilder sb, String aliasName) {
        if (columnParameterMap == null) {
            String msg = "The argument 'columnParameterMap' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        sb.append(this.ln());
        int index = 0;
        int mapSize = columnParameterMap.size();
        for (Map.Entry<String, Object> entry : columnParameterMap.entrySet()) {
            String valueExp;
            String columnName = entry.getKey();
            Object parameter = entry.getValue();
            ColumnInfo columnInfo = dbmeta.findColumnInfo(columnName);
            ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
            if (index == 0) {
                sb.append("   set ");
            } else {
                sb.append("     , ");
            }
            if (aliasName != null) {
                sb.append(aliasName);
            }
            sb.append(columnSqlName).append(" = ");
            if (parameter instanceof SqlClause.QueryUpdateSetCalculationHandler) {
                SqlClause.QueryUpdateSetCalculationHandler handler = (SqlClause.QueryUpdateSetCalculationHandler)parameter;
                valueExp = handler.buildStatement(aliasName);
            } else {
                valueExp = parameter.toString();
            }
            sb.append(this.encryptIfNeeds(columnInfo, valueExp));
            if (mapSize - 1 > index) {
                sb.append(this.ln());
            }
            ++index;
        }
    }

    protected void throwQueryUpdateUnavailableFunctionException(String unavailableFunction, DBMeta dbmeta) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The queryUpdate() or queryDelete() with " + unavailableFunction + " is unavailable.");
        br.addItem("Advice");
        br.addElement("Your DB does not support QueryUpdateInScope and UpdateDirectJoin");
        br.addElement("or the table has compound primary key or you allowed it by option.");
        br.addItem("Table");
        br.addElement(dbmeta.getTableDbName());
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected String filterQueryUpdateBasePointAliasNameLocalUnsupported(String subQuery) {
        String basePointAliasName = this.getBasePointAliasName();
        subQuery = this.replace(subQuery, basePointAliasName + ".", "");
        String tableAliasSymbol = " " + basePointAliasName;
        subQuery = this.replace(subQuery, tableAliasSymbol + " ", " ");
        if ((subQuery = this.replace(subQuery, tableAliasSymbol + this.ln(), this.ln())).endsWith(tableAliasSymbol)) {
            subQuery = this.replace(subQuery, tableAliasSymbol, "");
        }
        return subQuery;
    }

    @Override
    public String getClauseQueryDelete() {
        DBMeta dbmeta = this.getDBMeta();
        StringBuilder sb = new StringBuilder();
        sb.append("delete");
        boolean useQueryUpdateDirect = this.isUseQueryUpdateDirect(dbmeta);
        String whereClause = null;
        if (useQueryUpdateDirect && this.needsDeleteTableAliasHint(whereClause = this.processSubQueryIndent(this.getWhereClause()))) {
            sb.append(" ").append(this.getBasePointAliasName());
        }
        sb.append(" from ").append(dbmeta.getTableSqlName());
        if (useQueryUpdateDirect) {
            this.buildQueryUpdateDirectClause(null, whereClause, dbmeta, sb);
        } else {
            this.buildQueryUpdateInScopeClause(null, dbmeta, sb);
        }
        return sb.toString();
    }

    protected boolean needsDeleteTableAliasHint(String whereClause) {
        return this.canUseDeleteTableAliasHint() && (this.hasOuterJoin() || this.hasQueryUpdateSubQueryPossible(whereClause));
    }

    protected boolean canUseDeleteTableAliasHint() {
        return this.isUpdateDirectJoinSupported() && this.isDeleteTableAliasHintSupported();
    }

    @Override
    public void allowQueryUpdateForcedDirect() {
        this._queryUpdateForcedDirectAllowed = true;
    }

    protected boolean isUpdateSubQueryUseLocalTableSupported() {
        return true;
    }

    protected boolean isUpdateDirectJoinSupported() {
        return false;
    }

    protected boolean isUpdateTableAliasNameSupported() {
        return false;
    }

    protected boolean isDeleteTableAliasHintSupported() {
        return false;
    }

    @Override
    public HpCBPurpose getPurpose() {
        return this._purpose;
    }

    @Override
    public void setPurpose(HpCBPurpose purpose) {
        this._purpose = purpose;
    }

    @Override
    public int getInScopeLimit() {
        return 0;
    }

    @Override
    public void adjustLikeSearchDBWay(LikeSearchOption option) {
        DBWay dbway = this.dbway();
        option.acceptOriginalWildCardList(dbway.getOriginalWildCardList());
        option.acceptStringConnector(dbway.getStringConnector());
        option.acceptGearedCipherManager(this.getGearedCipherManager());
    }

    @Override
    public boolean isCursorSelectByPagingAllowed() {
        return false;
    }

    protected DBMeta getDBMeta() {
        if (this._dbmeta == null) {
            String msg = "The DB meta of local table should not be null when using getDBMeta():";
            msg = msg + " tableDbName=" + this._tableDbName;
            throw new IllegalStateException(msg);
        }
        return this._dbmeta;
    }

    protected DBMeta findDBMeta(String tableDbName) {
        DBMeta dbmeta = this.getCachedDBMetaMap().get(tableDbName);
        if (dbmeta != null) {
            return dbmeta;
        }
        if (this._dbmetaProvider == null) {
            String msg = "The DB meta provider should not be null when using findDBMeta():";
            msg = msg + " tableDbName=" + tableDbName;
            throw new IllegalStateException(msg);
        }
        dbmeta = this._dbmetaProvider.provideDBMetaChecked(tableDbName);
        this.getCachedDBMetaMap().put(tableDbName, dbmeta);
        return dbmeta;
    }

    protected Map<String, DBMeta> getCachedDBMetaMap() {
        if (this._cachedDBMetaMap == null) {
            this._cachedDBMetaMap = StringKeyMap.createAsFlexible();
        }
        return this._cachedDBMetaMap;
    }

    protected ColumnInfo toColumnInfo(String tableDbName, String columnDbName) {
        return this.findDBMeta(tableDbName).findColumnInfo(columnDbName);
    }

    protected ColumnSqlName toColumnSqlName(String tableDbName, String columnDbName) {
        return this.toColumnInfo(tableDbName, columnDbName).getColumnSqlName();
    }

    protected String buildSpaceBar(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    protected String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }

    protected class RownumPagingProcessor {
        protected String _rownumExpression;
        protected String _selectHint = "";
        protected String _sqlSuffix = "";
        protected Integer _pagingBindFrom;
        protected Integer _pagingBindTo;
        protected boolean _bind;

        public RownumPagingProcessor(String rownumExpression) {
            this._rownumExpression = rownumExpression;
        }

        public void useBindVariable() {
            this._bind = true;
        }

        public void processRowNumberPaging() {
            String exp;
            boolean offset = AbstractSqlClause.this.isFetchStartIndexSupported();
            boolean limit = AbstractSqlClause.this.isFetchSizeSupported();
            if (!offset && !limit) {
                return;
            }
            StringBuilder hintSb = new StringBuilder();
            String rownum = this._rownumExpression;
            hintSb.append(" *").append(AbstractSqlClause.this.ln());
            hintSb.append("  from (").append(AbstractSqlClause.this.ln());
            hintSb.append("select plain.*, ").append(rownum).append(" as rn").append(AbstractSqlClause.this.ln());
            hintSb.append("  from (").append(AbstractSqlClause.this.ln());
            hintSb.append("select");
            StringBuilder suffixSb = new StringBuilder();
            String fromEnd = "       ) plain" + AbstractSqlClause.this.ln() + "       ) ext" + AbstractSqlClause.this.ln();
            if (offset) {
                int pageStartIndex = AbstractSqlClause.this.getPageStartIndex();
                this._pagingBindFrom = pageStartIndex;
                exp = this._bind ? "/*pmb.sqlClause.pagingBindFrom*/" : String.valueOf(pageStartIndex);
                suffixSb.append(fromEnd).append(" where ext.rn > ").append(exp);
            }
            if (limit) {
                int pageEndIndex = AbstractSqlClause.this.getPageEndIndex();
                this._pagingBindTo = pageEndIndex;
                String string = exp = this._bind ? "/*pmb.sqlClause.pagingBindTo*/" : String.valueOf(pageEndIndex);
                if (offset) {
                    suffixSb.append(AbstractSqlClause.this.ln()).append("   and ext.rn <= ").append(exp);
                } else {
                    suffixSb.append(fromEnd).append(" where ext.rn <= ").append(exp);
                }
            }
            this._selectHint = hintSb.toString();
            this._sqlSuffix = suffixSb.toString();
        }

        public String getSelectHint() {
            return this._selectHint;
        }

        public String getSqlSuffix() {
            return this._sqlSuffix;
        }

        public Integer getPagingBindFrom() {
            return this._pagingBindFrom;
        }

        public Integer getPagingBindTo() {
            return this._pagingBindTo;
        }
    }

    protected static class UnionQueryInfo {
        protected UnionClauseProvider _unionClauseProvider;
        protected boolean _unionAll;

        protected UnionQueryInfo() {
        }

        public UnionClauseProvider getUnionClauseProvider() {
            return this._unionClauseProvider;
        }

        public void setUnionClauseProvider(UnionClauseProvider unionClauseProvider) {
            this._unionClauseProvider = unionClauseProvider;
        }

        public boolean isUnionAll() {
            return this._unionAll;
        }

        public void setUnionAll(boolean unionAll) {
            this._unionAll = unionAll;
        }
    }
}

