/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.Entity;
import org.seasar.robot.dbflute.bhv.WritableOption;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.SpecifyQuery;
import org.seasar.robot.dbflute.cbean.chelper.HpCalcSpecification;
import org.seasar.robot.dbflute.cbean.chelper.HpCalculator;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.robot.dbflute.exception.BatchUpdateColumnModifiedPropertiesFragmentedException;
import org.seasar.robot.dbflute.exception.SpecifyUpdateColumnInvalidException;
import org.seasar.robot.dbflute.exception.VaryingUpdateCalculationUnsupportedColumnTypeException;
import org.seasar.robot.dbflute.exception.VaryingUpdateCommonColumnSpecificationException;
import org.seasar.robot.dbflute.exception.VaryingUpdateInvalidColumnSpecificationException;
import org.seasar.robot.dbflute.exception.VaryingUpdateNotFoundCalculationException;
import org.seasar.robot.dbflute.exception.VaryingUpdateOptimisticLockSpecificationException;
import org.seasar.robot.dbflute.exception.VaryingUpdatePrimaryKeySpecificationException;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.helper.StringKeyMap;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.util.DfCollectionUtil;
import org.seasar.robot.dbflute.util.DfTypeUtil;

public class UpdateOption<CB extends ConditionBean>
implements WritableOption<CB> {
    protected List<HpCalcSpecification<CB>> _selfSpecificationList;
    protected Map<String, HpCalcSpecification<CB>> _selfSpecificationMap;
    protected SpecifyQuery<CB> _updateColumnSpecification;
    protected CB _updateColumnSpecifiedCB;
    protected Set<String> _forcedSpecifiedUpdateColumnSet;
    protected boolean _exceptCommonColumnForcedSpecified;
    protected boolean _updateColumnModifiedPropertiesFragmentedAllowed;
    protected boolean _compatibleBatchUpdateDefaultEveryColumn;
    protected boolean _disableCommonColumnAutoSetup;
    protected boolean _nonQueryUpdateAllowed;
    protected boolean _queryUpdateForcedDirectAllowed;
    protected Integer _batchLoggingUpdateLimit;
    protected StatementConfig _updateStatementConfig;

    public HpCalculator self(SpecifyQuery<CB> selfCalculationSpecification) {
        if (selfCalculationSpecification == null) {
            String msg = "The argument 'selfCalculationSpecification' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._selfSpecificationList == null) {
            this._selfSpecificationList = DfCollectionUtil.newArrayList();
        }
        HpCalcSpecification<CB> specification = new HpCalcSpecification<CB>(selfCalculationSpecification);
        this._selfSpecificationList.add(specification);
        return specification;
    }

    public boolean hasSelfSpecification() {
        return this._selfSpecificationList != null && !this._selfSpecificationList.isEmpty();
    }

    public void resolveSelfSpecification(CB cb) {
        if (this._selfSpecificationList == null || this._selfSpecificationList.isEmpty()) {
            return;
        }
        this._selfSpecificationMap = StringKeyMap.createAsFlexibleOrdered();
        for (HpCalcSpecification<CB> specification : this._selfSpecificationList) {
            specification.specify(cb);
            String columnDbName = specification.getResolvedSpecifiedColumnDbName();
            this.assertSpecifiedColumn(cb, columnDbName);
            this._selfSpecificationMap.put(columnDbName, specification);
        }
    }

    protected void assertSpecifiedColumn(CB cb, String columnDbName) {
        ColumnInfo columnInfo;
        if (columnDbName == null) {
            this.throwVaryingUpdateInvalidColumnSpecificationException(cb);
        }
        if ((columnInfo = cb.getDBMeta().findColumnInfo(columnDbName)).isPrimary()) {
            this.throwVaryingUpdatePrimaryKeySpecificationException(columnInfo);
        }
        if (columnInfo.isCommonColumn()) {
            this.throwVaryingUpdateCommonColumnSpecificationException(columnInfo);
        }
        if (columnInfo.isOptimisticLock()) {
            this.throwVaryingUpdateOptimisticLockSpecificationException(columnInfo);
        }
        if (!columnInfo.isPropertyTypeNumber() && !columnInfo.isPropertyTypeDate()) {
            String msg = "Not number or date column specified: " + columnInfo;
            throw new VaryingUpdateCalculationUnsupportedColumnTypeException(msg);
        }
    }

    protected void throwVaryingUpdateInvalidColumnSpecificationException(CB cb) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The specified column for varying-update was invalid.");
        br.addItem("Advice");
        br.addElement("You should call specify().column[TargetColumn]() only once.");
        br.addElement("For example:");
        br.addElement("");
        br.addElement("  (x):");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            // *no, empty");
        br.addElement("        }");
        br.addElement("    });");
        br.addElement("  (x):");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            cb.specify().columnPurchaseCount();");
        br.addElement("            cb.specify().columnPurchasePrice(); // *no, duplicated");
        br.addElement("        }");
        br.addElement("    });");
        br.addElement("  (o)");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            cb.specify().columnPurchaseCount(); // OK");
        br.addElement("        }");
        br.addElement("    });");
        br.addItem("Target Table");
        br.addElement(cb.getTableDbName());
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdateInvalidColumnSpecificationException(msg);
    }

    protected void throwVaryingUpdatePrimaryKeySpecificationException(ColumnInfo columnInfo) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The primary key column was specified.");
        br.addItem("Advice");
        br.addElement("Varying-update is not allowed to specify a PK column.");
        br.addItem("Target Table");
        br.addElement(columnInfo.getDBMeta().getTableDbName());
        br.addItem("Specified Column");
        br.addElement(columnInfo);
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdatePrimaryKeySpecificationException(msg);
    }

    protected void throwVaryingUpdateCommonColumnSpecificationException(ColumnInfo columnInfo) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The column for optimistic lock was specified.");
        br.addItem("Advice");
        br.addElement("Varying-update is not allowed to specify a optimistic-lock column.");
        br.addItem("Target Table");
        br.addElement(columnInfo.getDBMeta().getTableDbName());
        br.addItem("Specified Column");
        br.addElement(columnInfo);
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdateCommonColumnSpecificationException(msg);
    }

    protected void throwVaryingUpdateOptimisticLockSpecificationException(ColumnInfo columnInfo) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The column for optimistic lock was specified.");
        br.addItem("Advice");
        br.addElement("Varying-update is not allowed to specify a optimistic-lock column.");
        br.addItem("Target Table");
        br.addElement(columnInfo.getDBMeta().getTableDbName());
        br.addItem("Specified Column");
        br.addElement(columnInfo);
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdateOptimisticLockSpecificationException(msg);
    }

    protected String getSpecifiedColumnDbNameAsOne(CB cb) {
        return cb.getSqlClause().getSpecifiedColumnDbNameAsOne();
    }

    public boolean hasStatement(String columnDbName) {
        return this.findStatementSpecification(columnDbName) != null;
    }

    public String buildStatement(String columnDbName) {
        return this.doBuildStatement(columnDbName, null);
    }

    public String buildStatement(String columnDbName, String aliasName) {
        return this.doBuildStatement(columnDbName, aliasName);
    }

    protected String doBuildStatement(String columnDbName, String aliasName) {
        HpCalcSpecification<CB> calcSp = this.findStatementSpecification(columnDbName);
        if (calcSp == null) {
            return null;
        }
        String statement = calcSp.buildStatementAsSqlName(aliasName);
        if (statement == null) {
            this.throwVaryingUpdateNotFoundCalculationException(columnDbName);
        }
        return statement;
    }

    protected HpCalcSpecification<CB> findStatementSpecification(String columnDbName) {
        return this._selfSpecificationMap != null ? this._selfSpecificationMap.get(columnDbName) : null;
    }

    protected void throwVaryingUpdateNotFoundCalculationException(String columnDbName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("A calculation of specified column for varying-update was not found.");
        br.addItem("Advice");
        br.addElement("You should call plus()/minus()/... methods after specification.");
        br.addElement("For example:");
        br.addElement("");
        br.addElement("  (x):");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            cb.specify().columnPurchaseCount();");
        br.addElement("        }");
        br.addElement("    }); // *no!");
        br.addElement("  (o):");
        br.addElement("    option.self(new SpecifyQuery<PurchaseCB>() {");
        br.addElement("        public void specify(PurchaseCB cb) {");
        br.addElement("            cb.specify().columnPurchaseCount();");
        br.addElement("        }");
        br.addElement("    }).plus(1); // OK");
        br.addItem("Specified Column");
        br.addElement(columnDbName);
        String msg = br.buildExceptionMessage();
        throw new VaryingUpdateNotFoundCalculationException(msg);
    }

    public void specify(SpecifyQuery<CB> updateColumnSpecification) {
        if (updateColumnSpecification == null) {
            String msg = "The argument 'updateColumnSpecification' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._updateColumnSpecification = updateColumnSpecification;
    }

    public void resolveUpdateColumnSpecification(CB cb) {
        if (this._updateColumnSpecification == null) {
            return;
        }
        this._updateColumnSpecification.specify(cb);
        this._updateColumnSpecifiedCB = cb;
        if (!this._exceptCommonColumnForcedSpecified) {
            this.xacceptCommonColumnForcedSpecification(cb);
        }
    }

    public UpdateOption<CB> exceptCommonColumnForcedSpecified() {
        this._exceptCommonColumnForcedSpecified = true;
        return this;
    }

    protected void xacceptCommonColumnForcedSpecification(CB cb) {
        List<ColumnInfo> beforeUpdateList = cb.getDBMeta().getCommonColumnInfoBeforeUpdateList();
        if (beforeUpdateList == null || beforeUpdateList.isEmpty()) {
            return;
        }
        for (ColumnInfo columnInfo : beforeUpdateList) {
            this.addForcedSpecifiedUpdateColumn(columnInfo);
        }
    }

    protected void addForcedSpecifiedUpdateColumn(ColumnInfo columnInfo) {
        if (this._forcedSpecifiedUpdateColumnSet == null) {
            this._forcedSpecifiedUpdateColumnSet = DfCollectionUtil.newHashSet();
        }
        this._forcedSpecifiedUpdateColumnSet.add(columnInfo.getColumnDbName());
    }

    public void xacceptUpdateColumnModifiedPropertiesIfNeeds(List<? extends Entity> entityList) {
        if (entityList == null) {
            throw new IllegalArgumentException("The argument 'entityList' should not be null.");
        }
        if (this._updateColumnSpecification != null) {
            return;
        }
        if (entityList.isEmpty()) {
            return;
        }
        if (this.xisCompatibleBatchUpdateDefaultEveryColumn()) {
            return;
        }
        Entity firstEntity = entityList.get(0);
        final Set<String> targetProps = this.xgatherUpdateColumnModifiedProperties(entityList, firstEntity);
        final DBMeta dbmeta = firstEntity.getDBMeta();
        this.specify(new SpecifyQuery<CB>(){

            @Override
            public void specify(CB cb) {
                for (String prop : targetProps) {
                    ColumnInfo info = dbmeta.findColumnInfo(prop);
                    if (info.isPrimary()) continue;
                    cb.localSp().xspecifyColumn(info.getColumnDbName());
                }
            }
        });
    }

    public void xallowUpdateColumnModifiedPropertiesFragmented() {
        this._updateColumnModifiedPropertiesFragmentedAllowed = true;
    }

    public boolean xisUpdateColumnModifiedPropertiesFragmentedAllowed() {
        return this._updateColumnModifiedPropertiesFragmentedAllowed;
    }

    protected Set<String> xgatherUpdateColumnModifiedProperties(List<? extends Entity> entityList, Entity firstEntity) {
        if (this.xisUpdateColumnModifiedPropertiesFragmentedAllowed()) {
            LinkedHashSet<String> mergedProps = new LinkedHashSet<String>();
            for (Entity entity : entityList) {
                mergedProps.addAll(entity.modifiedProperties());
            }
            return mergedProps;
        }
        Set<String> firstProps = firstEntity.modifiedProperties();
        for (Entity entity : entityList) {
            if (((Object)entity.modifiedProperties()).equals(firstProps)) continue;
            this.throwBatchUpdateColumnModifiedPropertiesFragmentedException(firstProps, entity);
        }
        return firstProps;
    }

    protected void throwBatchUpdateColumnModifiedPropertiesFragmentedException(Set<String> baseProps, Entity entity) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The modified properties in the entity are fragmented as batch update column.");
        br.addItem("Advice");
        br.addElement("You should specify the same-set columns to your entities.");
        br.addElement("For example:");
        br.addElement("");
        br.addElement("  (x): (BatchUpdate)");
        br.addElement("    for (... : ...) {");
        br.addElement("        Member member = new Member();");
        br.addElement("        member.setMemberName(\"foo\");");
        br.addElement("        if (...) { // only a part of entities is set");
        br.addElement("            member.setMemberStatusCode_Formalized();");
        br.addElement("        }");
        br.addElement("        member.setVersionNo(...);");
        br.addElement("        memberList.add(member);");
        br.addElement("    }");
        br.addElement("    memberBhv.batchUpdate(memberList); // throws exception");
        br.addElement("  (o): (BatchUpdate)");
        br.addElement("    for (... : ...) {");
        br.addElement("        Member member = new Member();");
        br.addElement("        member.setMemberName(\"foo\");");
        br.addElement("        if (...) {");
        br.addElement("            member.setMemberStatusCode_Formalized();");
        br.addElement("        } else {");
        br.addElement("            member.setMemberStatusCode_Provisional();");
        br.addElement("        }");
        br.addElement("        member.setVersionNo(...);");
        br.addElement("        memberList.add(member);");
        br.addElement("    }");
        br.addElement("    memberBhv.batchUpdate(memberList); // MEMBER_STATUS_CODE is updated");
        br.addElement("  (o): (EntityUpdate)");
        br.addElement("    for (... : ...) {");
        br.addElement("        Member member = new Member();");
        br.addElement("        member.setMemberName(\"foo\");");
        br.addElement("        if (...) { // only a part of entities is set");
        br.addElement("            member.setMemberStatusCode_Formalized();");
        br.addElement("        }");
        br.addElement("        member.setVersionNo(...);");
        br.addElement("        memberList.add(member);");
        br.addElement("    }");
        br.addElement("    for (Member member : memberList) {");
        br.addElement("        memberBhv.update(member); // keep or update new value of MEMBER_STATUS_CODE");
        br.addElement("    }");
        br.addItem("Update Table");
        br.addElement(entity.getDBMeta().getTableDbName());
        br.addItem("Base Properties");
        br.addElement(baseProps);
        br.addItem("Fragmented Entity");
        br.addElement(entity.getDBMeta().extractPrimaryKeyMap(entity));
        br.addItem("Fragmented Properties");
        br.addElement(entity.modifiedProperties());
        String msg = br.buildExceptionMessage();
        throw new BatchUpdateColumnModifiedPropertiesFragmentedException(msg);
    }

    public void xtoBeCompatibleBatchUpdateDefaultEveryColumn() {
        this._compatibleBatchUpdateDefaultEveryColumn = true;
    }

    public boolean xisCompatibleBatchUpdateDefaultEveryColumn() {
        return this._compatibleBatchUpdateDefaultEveryColumn;
    }

    public void xcheckSpecifiedUpdateColumnPrimaryKey() {
        if (this._updateColumnSpecification == null) {
            return;
        }
        this.assertUpdateColumnSpecifiedCB();
        CB cb = this._updateColumnSpecifiedCB;
        String basePointAliasName = cb.getSqlClause().getBasePointAliasName();
        DBMeta dbmeta = cb.getDBMeta();
        if (dbmeta.hasPrimaryKey()) {
            UniqueInfo pkInfo = dbmeta.getPrimaryUniqueInfo();
            List<ColumnInfo> pkList = pkInfo.getUniqueColumnList();
            for (ColumnInfo pk : pkList) {
                String columnDbName = pk.getColumnDbName();
                if (!cb.getSqlClause().hasSpecifiedSelectColumn(basePointAliasName, columnDbName)) continue;
                String msg = "PK columns should not be allowed to specify as update columns: " + columnDbName;
                throw new SpecifyUpdateColumnInvalidException(msg);
            }
        }
    }

    public boolean hasSpecifiedUpdateColumn() {
        return this._updateColumnSpecification != null;
    }

    public boolean isSpecifiedUpdateColumn(String columnDbName) {
        if (this._forcedSpecifiedUpdateColumnSet != null && this._forcedSpecifiedUpdateColumnSet.contains(columnDbName)) {
            return true;
        }
        this.assertUpdateColumnSpecifiedCB();
        SqlClause sqlClause = this._updateColumnSpecifiedCB.getSqlClause();
        return sqlClause.hasSpecifiedSelectColumn(sqlClause.getBasePointAliasName(), columnDbName);
    }

    protected void assertUpdateColumnSpecifiedCB() {
        if (this._updateColumnSpecifiedCB == null) {
            String msg = "The CB for specification of update columns should be required here.";
            throw new IllegalStateException(msg);
        }
    }

    public UpdateOption<CB> disableCommonColumnAutoSetup() {
        this._disableCommonColumnAutoSetup = true;
        return this;
    }

    public boolean isCommonColumnAutoSetupDisabled() {
        return this._disableCommonColumnAutoSetup;
    }

    public UpdateOption<CB> allowNonQueryUpdate() {
        this._nonQueryUpdateAllowed = true;
        return this;
    }

    public boolean isNonQueryUpdateAllowed() {
        return this._nonQueryUpdateAllowed;
    }

    public UpdateOption<CB> allowQueryUpdateForcedDirect() {
        this._queryUpdateForcedDirectAllowed = true;
        return this;
    }

    public boolean isQueryUpdateForcedDirectAllowed() {
        return this._queryUpdateForcedDirectAllowed;
    }

    public void limitBatchUpdateLogging(Integer batchLoggingUpdateLimit) {
        this._batchLoggingUpdateLimit = batchLoggingUpdateLimit;
    }

    public Integer getBatchUpdateLoggingLimit() {
        return this._batchLoggingUpdateLimit;
    }

    public void configure(StatementConfig updateStatementConfig) {
        this._updateStatementConfig = updateStatementConfig;
    }

    public StatementConfig getUpdateStatementConfig() {
        return this._updateStatementConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._selfSpecificationList != null && !this._selfSpecificationList.isEmpty()) {
            sb.append("SelfCalculationSpecified");
        }
        if (this._updateColumnSpecification != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("UpdateColumnSpecified");
        }
        if (this._disableCommonColumnAutoSetup) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("CommonColumnDisabled");
        }
        if (this._nonQueryUpdateAllowed) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("NonQueryUpdateAllowed");
        }
        if (this._batchLoggingUpdateLimit != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("batchLogging(" + this._batchLoggingUpdateLimit + ")");
        }
        if (sb.length() == 0) {
            sb.append("default");
        }
        return DfTypeUtil.toClassTitle(this) + ":{" + sb.toString() + "}";
    }
}

