/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype.basic;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ClassificationCodeType;
import org.seasar.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.seasar.dbflute.util.DfTypeUtil;

public class ClassificationType
extends TnAbstractValueType {
    public ClassificationType() {
        super(12);
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        String msg = "Getting as classification is unsupported: index=" + index;
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        String msg = "Getting as classification is unsupported: columnName=" + columnName;
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        String msg = "Getting as classification for Procedure is unsupported: index=" + index;
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        String msg = "Getting as classification for Procedure is unsupported: parameterName=" + parameterName;
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            if (!(value instanceof Classification)) {
                String msg = "The value should be classification:";
                msg = msg + " value=" + value + " type=" + value.getClass();
                throw new IllegalStateException(msg);
            }
            Classification cls = (Classification)value;
            if (ClassificationCodeType.String.equals((Object)cls.meta().codeType())) {
                ps.setString(index, cls.code());
            } else if (ClassificationCodeType.Number.equals((Object)cls.meta().codeType())) {
                ps.setInt(index, DfTypeUtil.toInteger((Object)cls.code()));
            } else if (ClassificationCodeType.Boolean.equals((Object)cls.meta().codeType())) {
                ps.setBoolean(index, DfTypeUtil.toBoolean(cls.code()));
            } else {
                ps.setObject(index, cls.code());
            }
        }
    }

    @Override
    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        String msg = "Binding as classification for Procedure is unsupported: value=" + value;
        throw new UnsupportedOperationException(msg);
    }
}

