/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.cbean.FetchAssistContext;
import org.seasar.dbflute.cbean.FetchNarrowingBean;
import org.seasar.dbflute.exception.FetchingOverSafetySizeException;
import org.seasar.dbflute.exception.handler.SQLExceptionResource;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.s2dao.jdbc.TnFetchAssistResultSet;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicParameterHandler;

public class TnBasicSelectHandler
extends TnBasicParameterHandler {
    private static final Log _log = LogFactory.getLog(TnBasicSelectHandler.class);
    protected final TnResultSetHandler _resultSetHandler;

    public TnBasicSelectHandler(DataSource dataSource, String sql, TnResultSetHandler resultSetHandler, StatementFactory statementFactory) {
        super(dataSource, statementFactory, sql);
        this._resultSetHandler = resultSetHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute(Connection conn, Object[] args, Class<?>[] argTypes) {
        this.logSql(args, argTypes);
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(conn);
            this.bindArgs(conn, ps, args, argTypes);
            Object object = this.queryResult(ps);
            return object;
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to execute the SQL for select.");
            this.handleSQLException(e, resource);
            Object var7_8 = null;
            return var7_8;
        }
        finally {
            this.close(ps);
        }
    }

    protected Object queryResult(PreparedStatement ps) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.doQueryResult(ps);
            Object object = this._resultSetHandler.handle(rs);
            return object;
        }
        catch (FetchingOverSafetySizeException e) {
            if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
                e.setDangerousDisplaySql(this.buildExceptionMessageSql());
            }
            throw e;
        }
        finally {
            this.close(rs);
        }
    }

    protected ResultSet doQueryResult(PreparedStatement ps) throws SQLException {
        TnFetchAssistResultSet wrapper;
        ResultSet rs = this.executeQuery(ps);
        if (!this.isUseFunctionalResultSet()) {
            return rs;
        }
        if (this.isInternalDebugEnabled()) {
            _log.debug((Object)"...Wrapping result set by functional one");
        }
        FetchBean selbean = FetchAssistContext.getFetchBeanOnThread();
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
            boolean offsetByCursorForcedly = context.isOffsetByCursorForcedly();
            boolean limitByCursorForcedly = context.isLimitByCursorForcedly();
            wrapper = this.createFunctionalResultSet(rs, selbean, offsetByCursorForcedly, limitByCursorForcedly);
        } else {
            wrapper = this.createFunctionalResultSet(rs, selbean, false, false);
        }
        return wrapper;
    }

    protected boolean isUseFunctionalResultSet() {
        FetchBean fcbean = FetchAssistContext.getFetchBeanOnThread();
        if (fcbean != null && fcbean.getSafetyMaxResultSize() > 0) {
            return true;
        }
        FetchNarrowingBean fnbean = FetchAssistContext.getFetchNarrowingBeanOnThread();
        if (fnbean != null && fnbean.isFetchNarrowingEffective()) {
            OutsideSqlContext outsideSqlContext;
            if (fnbean.isFetchNarrowingSkipStartIndexEffective() || fnbean.isFetchNarrowingLoopCountEffective()) {
                return true;
            }
            if (OutsideSqlContext.isExistOutsideSqlContextOnThread() && ((outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread()).isOffsetByCursorForcedly() || outsideSqlContext.isLimitByCursorForcedly())) {
                return true;
            }
        }
        return false;
    }

    protected TnFetchAssistResultSet createFunctionalResultSet(ResultSet rs, FetchBean fcbean, boolean offset, boolean limit) {
        return new TnFetchAssistResultSet(rs, fcbean, offset, limit);
    }
}

