/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.resource;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBFluteSystem {
    private static final Log _log = LogFactory.getLog(DBFluteSystem.class);
    protected static DBFluteCurrentProvider _currentProvider;
    protected static boolean _locked;

    public static String getBasicLn() {
        return "\n";
    }

    public static Date currentDate() {
        return new Date(DBFluteSystem.currentTimeMillis());
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(DBFluteSystem.currentTimeMillis());
    }

    public static long currentTimeMillis() {
        long millis = _currentProvider != null ? _currentProvider.currentTimeMillis() : System.currentTimeMillis();
        return millis;
    }

    public static void xlock() {
        _locked = true;
    }

    public static void xunlock() {
        _locked = false;
    }

    protected static void assertUnlocked() {
        if (_locked) {
            String msg = "DBFluteSystem was locked.";
            throw new IllegalStateException(msg);
        }
    }

    public static void xsetDBFluteCurrentProvider(DBFluteCurrentProvider currentProvider) {
        DBFluteSystem.assertUnlocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting DBFluteCurrentProvider: " + currentProvider));
        }
        _currentProvider = currentProvider;
        DBFluteSystem.xlock();
    }

    static {
        _locked = true;
    }

    public static interface DBFluteCurrentProvider {
        public long currentTimeMillis();
    }
}

