/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.token.file;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.helper.token.file.FileTokenizingHeaderInfo;
import org.seasar.dbflute.helper.token.file.exception.FileTokenizingInvalidValueCountException;

public class FileTokenizingRowResource {
    protected FileTokenizingHeaderInfo _headerInfo;
    protected List<String> _valueList;
    protected String _rowString;
    protected int _rowNumber;
    protected int _lineNumber;

    public Map<String, String> toColumnValueMap() {
        if (this._headerInfo == null || this._headerInfo.isEmpty()) {
            return null;
        }
        if (this._valueList == null || this._valueList.isEmpty()) {
            return null;
        }
        List<String> columnNameList = this._headerInfo.getColumnNameList();
        if (columnNameList.size() != this._valueList.size()) {
            String msg = "Different count between header columns and values:";
            msg = msg + " " + columnNameList.size() + ", " + this._valueList.size();
            throw new FileTokenizingInvalidValueCountException(msg);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(columnNameList.size());
        for (int i = 0; i < columnNameList.size(); ++i) {
            String columnName = columnNameList.get(i);
            String value = this._valueList.get(i);
            map.put(columnName, value);
        }
        return map;
    }

    public String toString() {
        return "{" + this._lineNumber + ", row=" + this._rowNumber + ": " + this._rowString + "}";
    }

    public FileTokenizingHeaderInfo getHeaderInfo() {
        return this._headerInfo;
    }

    public void setHeaderInfo(FileTokenizingHeaderInfo headerInfo) {
        this._headerInfo = headerInfo;
    }

    public List<String> getValueList() {
        return this._valueList;
    }

    public void setValueList(List<String> valueList) {
        this._valueList = valueList;
    }

    public String getRowString() {
        return this._rowString;
    }

    public void setRowString(String rowString) {
        this._rowString = rowString;
    }

    public int getRowNumber() {
        return this._rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this._rowNumber = rowNumber;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this._lineNumber = lineNumber;
    }
}

