/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.cbean.chelper.HpCalcElement;
import org.seasar.dbflute.cbean.chelper.HpCalcStatement;
import org.seasar.dbflute.cbean.chelper.HpCalculator;
import org.seasar.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.coption.ColumnConversionOption;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.util.DfCollectionUtil;

public class HpCalcSpecification<CB extends ConditionBean>
implements HpCalculator,
HpCalcStatement {
    protected final SpecifyQuery<CB> _specifyQuery;
    protected ConditionBean _baseCB;
    protected CB _specifedCB;
    protected final List<HpCalcElement> _calculationList = DfCollectionUtil.newArrayList();
    protected boolean _leftMode;
    protected HpCalcSpecification<CB> _leftCalcSp;
    protected boolean _convert;

    public HpCalcSpecification(SpecifyQuery<CB> specifyQuery) {
        this._specifyQuery = specifyQuery;
    }

    public HpCalcSpecification(SpecifyQuery<CB> specifyQuery, ConditionBean baseCB) {
        this._specifyQuery = specifyQuery;
        this._baseCB = baseCB;
    }

    public void specify(CB cb) {
        this._specifyQuery.specify(cb);
        this._specifedCB = cb;
        if (this._baseCB == null) {
            this._baseCB = cb;
        }
    }

    public ColumnInfo getSpecifiedColumnInfo() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            HpSpecifiedColumn dreamCruiseTicket = this._specifedCB.xshowDreamCruiseTicket();
            return !dreamCruiseTicket.isDerived() ? dreamCruiseTicket.getColumnInfo() : null;
        }
        return this._specifedCB.getSqlClause().getSpecifiedColumnInfoAsOne();
    }

    public ColumnInfo getSpecifiedDerivingColumnInfo() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            HpSpecifiedColumn dreamCruiseTicket = this._specifedCB.xshowDreamCruiseTicket();
            return dreamCruiseTicket.isDerived() ? dreamCruiseTicket.getColumnInfo() : null;
        }
        return this._specifedCB.getSqlClause().getSpecifiedDerivingColumnInfoAsOne();
    }

    public ColumnInfo getResolvedSpecifiedColumnInfo() {
        this.checkSpecifiedCB();
        ColumnInfo columnInfo = this.getSpecifiedColumnInfo();
        return columnInfo != null ? columnInfo : this.getSpecifiedDerivingColumnInfo();
    }

    public String getResolvedSpecifiedColumnDbName() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            HpSpecifiedColumn ticket = this._specifedCB.xshowDreamCruiseTicket();
            return ticket.getColumnDbName();
        }
        ColumnInfo columnInfo = this.getResolvedSpecifiedColumnInfo();
        return columnInfo != null ? columnInfo.getColumnDbName() : null;
    }

    public ColumnRealName getResolvedSpecifiedColumnRealName() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            HpSpecifiedColumn ticket = this._specifedCB.xshowDreamCruiseTicket();
            return ticket.toColumnRealName();
        }
        ColumnRealName columnRealName = this._specifedCB.getSqlClause().getSpecifiedColumnRealNameAsOne();
        if (columnRealName != null) {
            return columnRealName;
        }
        String subQuery = this._specifedCB.getSqlClause().getSpecifiedDerivingSubQueryAsOne();
        if (subQuery != null) {
            return ColumnRealName.create(null, new ColumnSqlName(subQuery));
        }
        return null;
    }

    public ColumnSqlName getResolvedSpecifiedColumnSqlName() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            HpSpecifiedColumn ticket = this._specifedCB.xshowDreamCruiseTicket();
            return ticket.toColumnSqlName();
        }
        ColumnSqlName columnSqlName = this._specifedCB.getSqlClause().getSpecifiedColumnSqlNameAsOne();
        if (columnSqlName != null) {
            return columnSqlName;
        }
        String subQuery = this._specifedCB.getSqlClause().getSpecifiedDerivingSubQueryAsOne();
        if (subQuery != null) {
            return new ColumnSqlName(subQuery);
        }
        return null;
    }

    public String getResolvedSpecifiedTableAliasName() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            HpSpecifiedColumn ticket = this._specifedCB.xshowDreamCruiseTicket();
            return ticket.getTableAliasName();
        }
        ColumnRealName columnRealName = this._specifedCB.getSqlClause().getSpecifiedColumnRealNameAsOne();
        if (columnRealName != null) {
            return columnRealName.getTableAliasName();
        }
        return this._specifedCB.getSqlClause().getSpecifiedDerivingAliasNameAsOne();
    }

    protected void checkSpecifiedCB() {
        if (this._specifedCB == null) {
            this.throwSpecifiedConditionBeanNotFoundException();
        }
    }

    protected void throwSpecifiedConditionBeanNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the specified condition-bean.");
        br.addItem("Advice");
        br.addElement("You should call specify(cb) before building statements.");
        br.addItem("Specify Query");
        br.addElement(this._specifyQuery);
        br.addItem("Calculation List");
        if (!this._calculationList.isEmpty()) {
            for (HpCalcElement element : this._calculationList) {
                br.addElement(element);
            }
        } else {
            br.addElement("*No calculation");
        }
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    @Override
    public HpCalculator plus(Number plusValue) {
        this.assertObjectNotNull("plusValue", plusValue);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.plus(plusValue);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.PLUS, plusValue);
    }

    @Override
    public HpCalculator plus(HpSpecifiedColumn plusColumn) {
        this.assertObjectNotNull("plusColumn", plusColumn);
        this.assertCalculationColumnNumber(plusColumn);
        this.assertSpecifiedDreamCruiseTicket(plusColumn);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.plus(plusColumn);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.PLUS, plusColumn);
    }

    @Override
    public HpCalculator minus(Number minusValue) {
        this.assertObjectNotNull("minusValue", minusValue);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.minus(minusValue);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.MINUS, minusValue);
    }

    @Override
    public HpCalculator minus(HpSpecifiedColumn minusColumn) {
        this.assertObjectNotNull("minusColumn", minusColumn);
        this.assertCalculationColumnNumber(minusColumn);
        this.assertSpecifiedDreamCruiseTicket(minusColumn);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.plus(minusColumn);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.MINUS, minusColumn);
    }

    @Override
    public HpCalculator multiply(Number multiplyValue) {
        this.assertObjectNotNull("multiplyValue", multiplyValue);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.multiply(multiplyValue);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.MULTIPLY, multiplyValue);
    }

    @Override
    public HpCalculator multiply(HpSpecifiedColumn multiplyColumn) {
        this.assertObjectNotNull("multiplyColumn", multiplyColumn);
        this.assertCalculationColumnNumber(multiplyColumn);
        this.assertSpecifiedDreamCruiseTicket(multiplyColumn);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.multiply(multiplyColumn);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.MULTIPLY, multiplyColumn);
    }

    @Override
    public HpCalculator divide(Number divideValue) {
        this.assertObjectNotNull("divideValue", divideValue);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.divide(divideValue);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.DIVIDE, divideValue);
    }

    @Override
    public HpCalculator divide(HpSpecifiedColumn divideColumn) {
        this.assertObjectNotNull("divideColumn", divideColumn);
        this.assertCalculationColumnNumber(divideColumn);
        this.assertSpecifiedDreamCruiseTicket(divideColumn);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.divide(divideColumn);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.DIVIDE, divideColumn);
    }

    protected HpCalculator register(HpCalcElement.CalculationType type, Number value) {
        this.assertObjectNotNull("type", (Object)type);
        if (value == null) {
            String msg = "The null value was specified as " + (Object)((Object)type) + ".";
            throw new IllegalArgumentException(msg);
        }
        HpCalcElement calculation = new HpCalcElement();
        calculation.setCalculationType(type);
        calculation.setCalculationValue(value);
        this._calculationList.add(calculation);
        return this;
    }

    protected HpCalculator register(HpCalcElement.CalculationType type, HpSpecifiedColumn column) {
        this.assertObjectNotNull("type", (Object)type);
        if (column == null) {
            String msg = "The null column was specified as " + (Object)((Object)type) + ".";
            throw new IllegalArgumentException(msg);
        }
        HpCalcElement calculation = new HpCalcElement();
        calculation.setCalculationType(type);
        calculation.setCalculationColumn(column);
        this._calculationList.add(calculation);
        return this;
    }

    @Override
    public HpCalculator convert(ColumnConversionOption option) {
        this.assertObjectNotNull("option", option);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.convert(option);
            return this;
        }
        return this.registerConv(option);
    }

    protected HpCalculator registerConv(ColumnConversionOption option) {
        if (option == null) {
            String msg = "The null value was specified as conversion option.";
            throw new IllegalArgumentException(msg);
        }
        HpCalcElement calculation = new HpCalcElement();
        calculation.setCalculationType(HpCalcElement.CalculationType.CONV);
        calculation.setColumnConversionOption(option);
        this._calculationList.add(calculation);
        this._convert = true;
        return this;
    }

    protected void prepareConvOption(ColumnConversionOption option) {
        option.xjudgeDatabase(this._baseCB.getSqlClause());
        option.xsetTargetColumnInfo(this.getResolvedSpecifiedColumnInfo());
        this._baseCB.localCQ().xregisterParameterOption(option);
    }

    protected void assertLeftCalcSp() {
        if (this._leftCalcSp == null) {
            this.throwCalculationLeftColumnUnsupportedException();
        }
    }

    protected void throwCalculationLeftColumnUnsupportedException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The calculation for left column is unsupported at the function.");
        br.addItem("Advice");
        br.addElement("For example, ColumnQuery supports it);");
        br.addElement("but UpdateOption does not.");
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    @Override
    public HpCalculator left() {
        this._leftMode = true;
        return this;
    }

    @Override
    public HpCalculator right() {
        this._leftMode = false;
        return this;
    }

    @Override
    public String buildStatementAsSqlName(String aliasName) {
        ColumnSqlName columnSqlName = this.getResolvedSpecifiedColumnSqlName();
        String columnExp = (aliasName != null ? aliasName : "") + columnSqlName.toString();
        boolean removeCalcAlias = aliasName == null;
        return this.doBuildStatement(columnExp, null, removeCalcAlias);
    }

    @Override
    public String buildStatementToSpecifidName(String columnExp) {
        return this.doBuildStatement(columnExp, null, false);
    }

    @Override
    public String buildStatementToSpecifidName(String columnExp, Map<String, String> columnAliasMap) {
        return this.doBuildStatement(columnExp, columnAliasMap, false);
    }

    protected String doBuildStatement(String columnExp, Map<String, String> columnAliasMap, boolean removeCalcAlias) {
        if (this._calculationList.isEmpty()) {
            return null;
        }
        String targetExp = columnAliasMap != null ? columnExp : this.decryptIfNeeds(columnExp);
        int index = 0;
        for (HpCalcElement calculation : this._calculationList) {
            ColumnConversionOption option;
            if (index > 0) {
                targetExp = "(" + targetExp + ")";
            }
            if (!calculation.isPreparedConvOption() && (option = calculation.getColumnConversionOption()) != null) {
                this.prepareConvOption(option);
                calculation.setPreparedConvOption(true);
            }
            targetExp = this.buildCalculationExp(targetExp, columnAliasMap, calculation, removeCalcAlias);
            ++index;
        }
        return targetExp;
    }

    protected String buildCalculationExp(String targetExp, Map<String, String> columnAliasMap, HpCalcElement calculation, boolean removeCalcAlias) {
        Object calcValueExp;
        HpCalcElement.CalculationType calculationType = calculation.getCalculationType();
        if (calculationType.equals((Object)HpCalcElement.CalculationType.CONV)) {
            ColumnConversionOption columnConversionOption = calculation.getColumnConversionOption();
            return columnConversionOption.filterFunction(targetExp);
        }
        if (calculation.hasCalculationValue()) {
            calcValueExp = calculation.getCalculationValue();
        } else if (calculation.hasCalculationColumn()) {
            String columnExp;
            HpSpecifiedColumn calculationColumn = calculation.getCalculationColumn();
            if (removeCalcAlias) {
                String basePointAliasName = this._baseCB.getSqlClause().getBasePointAliasName();
                if (!basePointAliasName.equals(calculationColumn.getTableAliasName())) {
                    this.throwCalculationColumnRelationUnresolvedException(targetExp, calculationColumn);
                }
                columnExp = calculationColumn.toColumnSqlName().toString();
            } else {
                columnExp = calculationColumn.toColumnRealName().toString();
            }
            if (columnAliasMap != null) {
                String mappedAlias = columnAliasMap.get(columnExp);
                calcValueExp = mappedAlias != null ? mappedAlias : columnExp;
            } else {
                ColumnInfo columnInfo = calculationColumn.getColumnInfo();
                calcValueExp = !calculationColumn.isDerived() ? this.decryptIfNeeds(columnInfo, columnExp) : columnExp;
            }
        } else {
            this.throwCalculationElementIllegalStateException(targetExp);
            return null;
        }
        return targetExp + " " + calculationType.operand() + " " + calcValueExp;
    }

    protected String decryptIfNeeds(String valueExp) {
        return this.decryptIfNeeds(this.getSpecifiedColumnInfo(), valueExp);
    }

    protected String decryptIfNeeds(ColumnInfo columnInfo, String valueExp) {
        if (columnInfo == null) {
            return valueExp;
        }
        ColumnFunctionCipher cipher = this._baseCB.getSqlClause().findColumnFunctionCipher(columnInfo);
        return cipher != null ? cipher.decrypt(valueExp) : valueExp;
    }

    protected void throwCalculationColumnRelationUnresolvedException(String targetExp, HpSpecifiedColumn calculationColumn) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The relation for the calculation column was unresolved.");
        br.addItem("Advice");
        br.addElement("For example, you cannot use relation columns for calculation");
        br.addElement("on set clause of update. (because of relation unresolved)");
        br.addItem("Base ConditionBean");
        br.addElement(this._baseCB.getClass().getName());
        br.addItem("Specified Column");
        br.addElement(targetExp);
        br.addItem("Calculation Column");
        br.addElement(calculationColumn);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwCalculationElementIllegalStateException(String targetExp) {
        String msg = "The either calculationValue or calculationColumn should exist: targetExp=" + targetExp;
        throw new IllegalStateException(msg);
    }

    public boolean isSpecifyColumn() {
        return this.getSpecifiedColumnInfo() != null;
    }

    public boolean isDerivedReferrer() {
        return this.getSpecifiedDerivingColumnInfo() != null;
    }

    public boolean mayNullRevived() {
        if (this._specifedCB != null && this._specifedCB.xhasDreamCruiseTicket() || this.isDerivedReferrer()) {
            return true;
        }
        for (HpCalcElement calcElement : this._calculationList) {
            if (calcElement.getCalculationColumn() != null) {
                return true;
            }
            ColumnConversionOption option = calcElement.getColumnConversionOption();
            if (option == null || !option.mayNullRevived()) continue;
            return true;
        }
        return false;
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCalculationColumnNumber(HpSpecifiedColumn specifiedColumn) {
        ColumnInfo columnInfo = specifiedColumn.getColumnInfo();
        if (columnInfo == null) {
            return;
        }
        if (!columnInfo.isPropertyTypeNumber()) {
            String msg = "The type of the calculation column should be Number: " + specifiedColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertSpecifiedDreamCruiseTicket(HpSpecifiedColumn column) {
        if (!column.isDreamCruiseTicket()) {
            String msg = "The specified column was not dream cruise ticket: " + column;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    public SpecifyQuery<CB> getSpecifyQuery() {
        return this._specifyQuery;
    }

    public void setBaseCB(ConditionBean baseCB) {
        this._baseCB = baseCB;
    }

    public List<HpCalcElement> getCalculationList() {
        return this._calculationList;
    }

    public boolean hasConvert() {
        return this._convert;
    }

    public HpCalcSpecification<CB> getLeftCalcSp() {
        return this._leftCalcSp;
    }

    public void setLeftCalcSp(HpCalcSpecification<CB> leftCalcSp) {
        this._leftCalcSp = leftCalcSp;
    }
}

