/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.seasar.dbflute.exception.AccessContextNoValueException;
import org.seasar.dbflute.exception.AccessContextNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.resource.DBFluteSystem;

public class AccessContext {
    private static final ThreadLocal<AccessContext> _threadLocal = new ThreadLocal();
    protected Date _accessDate;
    protected AccessDateProvider _accessDateProvider;
    protected Timestamp _accessTimestamp;
    protected AccessTimestampProvider _accessTimestampProvider;
    protected String _accessUser;
    protected AccessUserProvider _accessUserProvider;
    protected String _accessProcess;
    protected AccessProcessProvider _accessProcessProvider;
    protected String _accessModule;
    protected AccessModuleProvider _accessModuleProvider;
    protected Map<String, Object> _accessValueMap;

    public static AccessContext getAccessContextOnThread() {
        return _threadLocal.get();
    }

    public static void setAccessContextOnThread(AccessContext accessContext) {
        if (accessContext == null) {
            String msg = "The argument 'accessContext' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(accessContext);
    }

    public static boolean isExistAccessContextOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearAccessContextOnThread() {
        _threadLocal.set(null);
    }

    public static Date getAccessDateOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            Date provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            Date accessDate = context.getAccessDate();
            if (accessDate != null) {
                return accessDate;
            }
            AccessDateProvider provider = context.getAccessDateProvider();
            if (provider != null && (provided = provider.getAccessDate()) != null) {
                return provided;
            }
        }
        return DBFluteSystem.currentDate();
    }

    public static Timestamp getAccessTimestampOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            Timestamp provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            Timestamp accessTimestamp = context.getAccessTimestamp();
            if (accessTimestamp != null) {
                return accessTimestamp;
            }
            AccessTimestampProvider provider = context.getAccessTimestampProvider();
            if (provider != null && (provided = provider.getAccessTimestamp()) != null) {
                return provided;
            }
        }
        return DBFluteSystem.currentTimestamp();
    }

    public static String getAccessUserOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            String user;
            AccessContext context = AccessContext.getAccessContextOnThread();
            String accessUser = context.getAccessUser();
            if (accessUser != null) {
                return accessUser;
            }
            AccessUserProvider provider = context.getAccessUserProvider();
            if (provider != null && (user = provider.getAccessUser()) != null) {
                return user;
            }
        }
        String methodName = "getAccessUserOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException("getAccessUserOnThread()", "AccessUser", "user");
        } else {
            AccessContext.throwAccessContextNotFoundException("getAccessUserOnThread()");
        }
        return null;
    }

    public static String getAccessProcessOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            String provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            String accessProcess = context.getAccessProcess();
            if (accessProcess != null) {
                return accessProcess;
            }
            AccessProcessProvider provider = context.getAccessProcessProvider();
            if (provider != null && (provided = provider.getAccessProcess()) != null) {
                return provided;
            }
        }
        String methodName = "getAccessProcessOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException("getAccessProcessOnThread()", "AccessProcess", "process");
        } else {
            AccessContext.throwAccessContextNotFoundException("getAccessProcessOnThread()");
        }
        return null;
    }

    public static String getAccessModuleOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            String provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            String accessModule = context.getAccessModule();
            if (accessModule != null) {
                return accessModule;
            }
            AccessModuleProvider provider = context.getAccessModuleProvider();
            if (provider != null && (provided = provider.getAccessModule()) != null) {
                return provided;
            }
        }
        String methodName = "getAccessModuleOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException("getAccessModuleOnThread()", "AccessModule", "module");
        } else {
            AccessContext.throwAccessContextNotFoundException("getAccessModuleOnThread()");
        }
        return null;
    }

    public static Object getAccessValueOnThread(String key) {
        Object value;
        AccessContext context;
        Map<String, Object> accessValueMap;
        if (AccessContext.isExistAccessContextOnThread() && (accessValueMap = (context = AccessContext.getAccessContextOnThread()).getAccessValueMap()) != null && (value = accessValueMap.get(key)) != null) {
            return value;
        }
        String methodName = "getAccessValueOnThread(\"" + key + "\")";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException(methodName, "AccessValue", "value");
        } else {
            AccessContext.throwAccessContextNotFoundException(methodName);
        }
        return null;
    }

    protected static void throwAccessContextNotFoundException(String methodName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The access context was not found on thread.");
        br.addItem("Advice");
        br.addElement("Set up the value before DB access (using common column auto set-up)");
        br.addElement("You should set it up at your application's interceptor or filter.");
        br.addElement("For example:");
        br.addElement("  try {");
        br.addElement("      AccessContext context = new AccessContext();");
        br.addElement("      context.setAccessTimestamp(accessTimestamp);");
        br.addElement("      context.setAccessUser(accessUser);");
        br.addElement("      context.setAccessProcess(accessProcess);");
        br.addElement("      AccessContext.setAccessContextOnThread(context);");
        br.addElement("      return invocation.proceed();");
        br.addElement("  } finally {");
        br.addElement("      AccessContext.clearAccessContextOnThread();");
        br.addElement("  }");
        String msg = br.buildExceptionMessage();
        throw new AccessContextNotFoundException(msg);
    }

    protected static void throwAccessContextNoValueException(String methodName, String capPropName, String aliasName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to get the access " + aliasName + " in access context on thread.");
        br.addItem("Advice");
        br.addElement("Set up the value before DB access (using common column auto set-up)");
        br.addElement("You should set it up at your application's interceptor or filter.");
        br.addElement("For example:");
        br.addElement("  try {");
        br.addElement("      AccessContext context = new AccessContext();");
        br.addElement("      context.setAccessTimestamp(accessTimestamp);");
        br.addElement("      context.setAccessUser(accessUser);");
        br.addElement("      context.setAccessProcess(accessProcess);");
        br.addElement("      AccessContext.setAccessContextOnThread(context);");
        br.addElement("      return invocation.proceed();");
        br.addElement("  } finally {");
        br.addElement("      AccessContext.clearAccessContextOnThread();");
        br.addElement("  }");
        String msg = br.buildExceptionMessage();
        throw new AccessContextNoValueException(msg);
    }

    protected static String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public String toString() {
        return "{" + this._accessDate + ", " + this._accessTimestamp + ", " + this._accessUser + ", " + this._accessProcess + ", " + this._accessModule + ", " + this._accessValueMap + "}";
    }

    public Date getAccessDate() {
        return this._accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this._accessDate = accessDate;
    }

    public AccessDateProvider getAccessDateProvider() {
        return this._accessDateProvider;
    }

    public void setAccessDateProvider(AccessDateProvider accessDateProvider) {
        this._accessDateProvider = accessDateProvider;
    }

    public Timestamp getAccessTimestamp() {
        return this._accessTimestamp;
    }

    public void setAccessTimestamp(Timestamp accessTimestamp) {
        this._accessTimestamp = accessTimestamp;
    }

    public AccessTimestampProvider getAccessTimestampProvider() {
        return this._accessTimestampProvider;
    }

    public void setAccessTimestampProvider(AccessTimestampProvider accessTimestampProvider) {
        this._accessTimestampProvider = accessTimestampProvider;
    }

    public String getAccessUser() {
        return this._accessUser;
    }

    public void setAccessUser(String accessUser) {
        this._accessUser = accessUser;
    }

    public AccessUserProvider getAccessUserProvider() {
        return this._accessUserProvider;
    }

    public void setAccessUserProvider(AccessUserProvider accessUserProvider) {
        this._accessUserProvider = accessUserProvider;
    }

    public String getAccessProcess() {
        return this._accessProcess;
    }

    public void setAccessProcess(String accessProcess) {
        this._accessProcess = accessProcess;
    }

    public AccessProcessProvider getAccessProcessProvider() {
        return this._accessProcessProvider;
    }

    public void setAccessProcessProvider(AccessProcessProvider accessProcessProvider) {
        this._accessProcessProvider = accessProcessProvider;
    }

    public String getAccessModule() {
        return this._accessModule;
    }

    public void setAccessModule(String accessModule) {
        this._accessModule = accessModule;
    }

    public AccessModuleProvider getAccessModuleProvider() {
        return this._accessModuleProvider;
    }

    public void setAccessModuleProvider(AccessModuleProvider accessModuleProvider) {
        this._accessModuleProvider = accessModuleProvider;
    }

    public Map<String, Object> getAccessValueMap() {
        return this._accessValueMap;
    }

    public void registerAccessValue(String key, Object value) {
        if (this._accessValueMap == null) {
            this._accessValueMap = new HashMap<String, Object>();
        }
        this._accessValueMap.put(key, value);
    }

    public static interface AccessModuleProvider {
        public String getAccessModule();
    }

    public static interface AccessProcessProvider {
        public String getAccessProcess();
    }

    public static interface AccessUserProvider {
        public String getAccessUser();
    }

    public static interface AccessTimestampProvider {
        public Timestamp getAccessTimestamp();
    }

    public static interface AccessDateProvider {
        public Date getAccessDate();
    }
}

