/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.alchemy.mapper.processor;

import org.apache.uima.alchemy.digester.domain.LanguageDetectionResults;
import org.apache.uima.alchemy.digester.domain.Results;
import org.apache.uima.alchemy.mapper.processor.AlchemyOutputProcessor;
import org.apache.uima.alchemy.ts.language.LanguageFS;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;

public class LanguageProcessor
implements AlchemyOutputProcessor {
    public void process(JCas cas, Results results) throws Exception {
        LanguageFS languageFS = new LanguageFS(cas);
        Type type = languageFS.getType();
        LanguageDetectionResults languageDetectionResults = (LanguageDetectionResults)results;
        languageFS.setFeatureValueFromString(type.getFeatureByBaseName("language"), languageDetectionResults.getLanguage());
        languageFS.setFeatureValueFromString(type.getFeatureByBaseName("iso6391"), languageDetectionResults.getIso6391());
        languageFS.setFeatureValueFromString(type.getFeatureByBaseName("iso6392"), languageDetectionResults.getIso6392());
        languageFS.setFeatureValueFromString(type.getFeatureByBaseName("iso6393"), languageDetectionResults.getIso6393());
        languageFS.setFeatureValueFromString(type.getFeatureByBaseName("ethnologue"), languageDetectionResults.getEthnologue());
        languageFS.setFeatureValueFromString(type.getFeatureByBaseName("nativeSpeakers"), languageDetectionResults.getNativeSpeakers());
        languageFS.setFeatureValueFromString(type.getFeatureByBaseName("wikipedia"), languageDetectionResults.getWikipedia());
        languageFS.addToIndexes();
    }
}

