/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectConverter
implements Converter {
    private Class<?> cls;
    private transient Map<String, PropertyInfo> props;

    public ObjectConverter(Class<?> clazz) {
        this.cls = clazz;
    }

    @Override
    public Object convert(JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        if (this.props == null) {
            this.props = ObjectConverter.getSetProperties(context, this.cls);
        }
        if (object instanceof Map) {
            Object obj = context.createInternal(clazz);
            if (obj == null) {
                return null;
            }
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String string = entry.getKey().toString();
                PropertyInfo propertyInfo = this.props.get(string);
                if (propertyInfo == null) {
                    propertyInfo = this.props.get(ObjectConverter.toLowerCamel(context, string));
                }
                if (propertyInfo == null) continue;
                context.enter(string, propertyInfo.getWriteAnnotation(JSONHint.class));
                Class<?> clazz2 = propertyInfo.getWriteType();
                Type type2 = propertyInfo.getWriteGenericType();
                if (type2 instanceof TypeVariable && type instanceof ParameterizedType) {
                    type2 = ObjectConverter.resolveTypeVariable((TypeVariable)type2, (ParameterizedType)type);
                    clazz2 = ClassUtil.getRawType(type2);
                }
                propertyInfo.set(obj, context.postparseInternal(entry.getValue(), clazz2, type2));
                context.exit();
            }
            return obj;
        }
        if (object instanceof List) {
            throw new UnsupportedOperationException("Cannot convert " + object.getClass() + " to " + type);
        }
        JSONHint jSONHint = context.getHint();
        if (jSONHint != null && jSONHint.anonym().length() > 0) {
            PropertyInfo propertyInfo = this.props.get(jSONHint.anonym());
            if (propertyInfo == null) {
                return null;
            }
            Object obj = context.createInternal(clazz);
            if (obj == null) {
                return null;
            }
            context.enter(jSONHint.anonym(), propertyInfo.getWriteAnnotation(JSONHint.class));
            Class<?> clazz3 = propertyInfo.getWriteType();
            Type type3 = propertyInfo.getWriteGenericType();
            if (type3 instanceof TypeVariable && type instanceof ParameterizedType) {
                type3 = ObjectConverter.resolveTypeVariable((TypeVariable)type3, (ParameterizedType)type);
                clazz3 = ClassUtil.getRawType(type3);
            }
            propertyInfo.set(obj, context.postparseInternal(object, clazz3, type3));
            context.exit();
            return obj;
        }
        throw new UnsupportedOperationException("Cannot convert " + object.getClass() + " to " + type);
    }

    private static Map<String, PropertyInfo> getSetProperties(JSON.Context context, Class<?> clazz) {
        int n;
        String string;
        JSONHint jSONHint;
        AccessibleObject accessibleObject;
        HashMap<String, PropertyInfo> hashMap = new HashMap<String, PropertyInfo>();
        for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
            accessibleObject = propertyInfo.getField();
            if (accessibleObject == null || Modifier.isFinal(((Field)accessibleObject).getModifiers()) || context.ignoreInternal(clazz, (Member)((Object)accessibleObject))) continue;
            jSONHint = ((Field)accessibleObject).getAnnotation(JSONHint.class);
            string = null;
            n = propertyInfo.getOrdinal();
            if (jSONHint != null) {
                if (jSONHint.ignore()) continue;
                n = jSONHint.ordinal();
                if (jSONHint.name().length() != 0) {
                    string = jSONHint.name();
                }
            }
            if (string == null) {
                string = context.normalizeInternal(propertyInfo.getName());
                if (context.getPropertyStyle() != null) {
                    string = context.getPropertyStyle().to(string);
                }
            }
            if (!string.equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal() || accessibleObject != propertyInfo.getWriteMember()) {
                hashMap.put(string, new PropertyInfo(propertyInfo.getBeanClass(), string, propertyInfo.getField(), null, null, propertyInfo.isStatic(), n));
                continue;
            }
            hashMap.put(string, propertyInfo);
        }
        for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
            accessibleObject = propertyInfo.getWriteMethod();
            if (accessibleObject == null || context.ignoreInternal(clazz, (Member)((Object)accessibleObject))) continue;
            jSONHint = ((Method)accessibleObject).getAnnotation(JSONHint.class);
            string = null;
            n = propertyInfo.getOrdinal();
            if (jSONHint != null) {
                if (jSONHint.ignore()) continue;
                n = jSONHint.ordinal();
                if (jSONHint.name().length() != 0) {
                    string = jSONHint.name();
                }
            }
            if (string == null) {
                string = context.normalizeInternal(propertyInfo.getName());
                if (context.getPropertyStyle() != null) {
                    string = context.getPropertyStyle().to(string);
                }
            }
            if (!string.equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal()) {
                hashMap.put(string, new PropertyInfo(propertyInfo.getBeanClass(), string, null, null, propertyInfo.getWriteMethod(), propertyInfo.isStatic(), n));
                continue;
            }
            hashMap.put(string, propertyInfo);
        }
        return hashMap;
    }

    private static String toLowerCamel(JSON.Context context, String string) {
        StringBuilder stringBuilder = context.getLocalCache().getCachedBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 1 && Character.isUpperCase(stringBuilder.charAt(0)) && !Character.isUpperCase(stringBuilder.charAt(1))) {
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
        }
        return context.getLocalCache().getString(stringBuilder);
    }

    private static Type resolveTypeVariable(TypeVariable<?> typeVariable, ParameterizedType parameterizedType) {
        Class<?> clazz = ClassUtil.getRawType(parameterizedType);
        if (clazz.equals(typeVariable.getGenericDeclaration())) {
            String string = typeVariable.getName();
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeVariableArray.length; ++i) {
                if (!string.equals(typeVariableArray[i].getName())) continue;
                return typeArray[i];
            }
        }
        return typeVariable.getBounds()[0];
    }
}

