/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.impl;

import java.util.Arrays;
import java.util.Random;
import org.apache.uima.cas.impl.FeatureStructureImpl;

public class JCasHashMap {
    private static final boolean TUNE = false;
    private int[] histogram;
    private int nbrProbes;
    private int maxProbe = 0;
    private int sizeWhichTriggersExpansion;
    private float loadFactor = 0.5f;
    private int size;
    private FeatureStructureImpl[] table;
    private MyRandom random = new MyRandom();
    private int bits;
    private int bitsMask;
    private int casAddr;
    private final boolean useCache;

    JCasHashMap(int initialSize, boolean doUseCache) {
        this.useCache = doUseCache;
        int i = 0;
        for (int n = initialSize; n != 0; n >>= 1) {
            ++i;
        }
        if (1 << i - 1 == initialSize) {
            --i;
        }
        this.bits = i;
        this.bitsMask = (1 << i) - 1;
        initialSize = 1 << i;
        this.table = new FeatureStructureImpl[initialSize];
        this.sizeWhichTriggersExpansion = (int)((float)initialSize * this.loadFactor);
        this.size = 0;
    }

    public void clear() {
        if (!this.useCache) {
            return;
        }
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    public FeatureStructureImpl get(int key) {
        if (!this.useCache) {
            return null;
        }
        FeatureStructureImpl maybe = this.table[this.probe(key)];
        while (null != maybe && maybe.getAddress() != key) {
            maybe = this.table[this.nextProbe()];
        }
        return maybe;
    }

    public void put(FeatureStructureImpl value) {
        if (!this.useCache) {
            return;
        }
        int key = value.getAddress();
        int probeAddr = this.probe(key);
        while (null != this.table[probeAddr]) {
            probeAddr = this.nextProbe();
        }
        this.table[probeAddr] = value;
        ++this.size;
        if (this.size >= this.sizeWhichTriggersExpansion) {
            this.increaseSize();
        }
    }

    public int size() {
        return this.size;
    }

    private int probe(int addr) {
        this.casAddr = addr;
        this.random.setSeed(addr);
        this.random.next(1);
        return this.nextProbe();
    }

    private int nextProbe() {
        return this.random.next(this.bits) + this.casAddr & this.bitsMask;
    }

    private void increaseSize() {
        FeatureStructureImpl[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        int newCapacity = 2 * oldCapacity;
        ++this.bits;
        this.bitsMask = (1 << this.bits) - 1;
        this.sizeWhichTriggersExpansion = (int)((float)newCapacity * this.loadFactor);
        this.table = new FeatureStructureImpl[newCapacity];
        this.size = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (oldTable[i] == null) continue;
            this.put(oldTable[i]);
        }
    }

    public void showHistogram() {
    }

    private static class MyRandom
    extends Random {
        private static final long serialVersionUID = 1L;

        private MyRandom() {
        }

        protected int next(int bits) {
            return super.next(bits);
        }
    }
}

