/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.outsidesql.executor;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.exception.EntityDuplicatedException;
import org.seasar.dbflute.exception.FetchingOverSafetySizeException;
import org.seasar.dbflute.exception.PagingOverSafetySizeException;
import org.seasar.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlEntityExecutor;
import org.seasar.dbflute.outsidesql.factory.OutsideSqlExecutorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutsideSqlPagingExecutor<BEHAVIOR> {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final String _tableDbName;
    protected final DBDef _currentDBDef;
    protected final StatementConfig _defaultStatementConfig;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final OutsideSqlExecutorFactory _outsideSqlExecutorFactory;

    public AbstractOutsideSqlPagingExecutor(BehaviorCommandInvoker behaviorCommandInvoker, String tableDbName, DBDef currentDBDef, StatementConfig defaultStatementConfig, OutsideSqlOption outsideSqlOption, OutsideSqlExecutorFactory outsideSqlExecutorFactory) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._defaultStatementConfig = defaultStatementConfig;
        this._outsideSqlOption = outsideSqlOption;
        this._outsideSqlExecutorFactory = outsideSqlExecutorFactory;
    }

    public <ENTITY> PagingResultBean<ENTITY> selectPage(String path, PagingBean pmb, Class<ENTITY> entityType) {
        return this.doSelectPage(path, pmb, entityType);
    }

    protected <ENTITY> PagingResultBean<ENTITY> doSelectPage(String path, PagingBean pmb, Class<ENTITY> entityType) {
        if (path == null) {
            String msg = "The argument 'path' of outside-SQL should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (entityType == null) {
            String msg = "The argument 'entityType' for result should not be null: path=" + path;
            throw new IllegalArgumentException(msg);
        }
        try {
            PagingHandler<ENTITY> handler = this.createPagingHandler(path, pmb, entityType);
            PagingInvoker<ENTITY> invoker = this.createPagingInvoker(pmb);
            return invoker.invokePaging(handler);
        }
        catch (PagingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException(pmb, e);
            return null;
        }
    }

    protected <ENTITY> PagingHandler<ENTITY> createPagingHandler(final String path, final PagingBean pmb, final Class<ENTITY> entityType) {
        final OutsideSqlEntityExecutor<BEHAVIOR> countExecutor = this.createCountExecutor();
        return new PagingHandler<ENTITY>(){

            @Override
            public PagingBean getPagingBean() {
                return pmb;
            }

            @Override
            public int count() {
                pmb.xsetPaging(false);
                try {
                    return countExecutor.selectEntityWithDeletedCheck(path, pmb, Integer.class);
                }
                catch (EntityDuplicatedException e) {
                    AbstractOutsideSqlPagingExecutor.this.throwPagingCountSelectNotCountException(path, pmb, entityType, e);
                    return -1;
                }
            }

            @Override
            public List<ENTITY> paging() {
                pmb.xsetPaging(true);
                return AbstractOutsideSqlPagingExecutor.this.doSelectList(path, pmb, entityType);
            }
        };
    }

    protected OutsideSqlEntityExecutor<BEHAVIOR> createCountExecutor() {
        OutsideSqlOption countOption = this._outsideSqlOption.copyOptionWithoutPaging();
        return this._outsideSqlExecutorFactory.createEntity(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, countOption);
    }

    protected <ENTITY> void throwPagingCountSelectNotCountException(String path, PagingBean pmb, Class<ENTITY> entityType, EntityDuplicatedException e) {
        this.createBhvExThrower().throwPagingCountSelectNotCountException(this._tableDbName, path, pmb, entityType, e);
    }

    protected <ENTITY> PagingInvoker<ENTITY> createPagingInvoker(PagingBean pmb) {
        return pmb.createPagingInvoker(this._tableDbName);
    }

    protected void setupScrollableCursorIfNeeds() {
        if (!this._outsideSqlOption.isAutoPaging()) {
            return;
        }
        StatementConfig statementConfig = this._outsideSqlOption.getStatementConfig();
        if (statementConfig != null && statementConfig.hasResultSetType()) {
            return;
        }
        if (this._defaultStatementConfig != null && this._defaultStatementConfig.hasResultSetType()) {
            return;
        }
        if (statementConfig == null) {
            statementConfig = new StatementConfig();
            this.configure(statementConfig);
        }
        if (this._currentDBDef.dbway().isScrollableCursorSupported()) {
            statementConfig.typeScrollInsensitive();
        } else {
            statementConfig.typeForwardOnly();
        }
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(String path, PagingBean pmb, Class<ENTITY> entityType) {
        return this.doSelectList(path, pmb, entityType);
    }

    protected <ENTITY> ListResultBean<ENTITY> doSelectList(String path, PagingBean pmb, Class<ENTITY> entityType) {
        if (path == null) {
            String msg = "The argument 'path' of outside-SQL should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (entityType == null) {
            String msg = "The argument 'entityType' for result should not be null: path=" + path;
            throw new IllegalArgumentException(msg);
        }
        this.setupScrollableCursorIfNeeds();
        try {
            return this.createBasicExecutor().selectList(path, pmb, entityType);
        }
        catch (FetchingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException(pmb, e);
            return null;
        }
    }

    protected OutsideSqlBasicExecutor<BEHAVIOR> createBasicExecutor() {
        return this._outsideSqlExecutorFactory.createBasic(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public AbstractOutsideSqlPagingExecutor<BEHAVIOR> removeBlockComment() {
        this._outsideSqlOption.removeBlockComment();
        return this;
    }

    public AbstractOutsideSqlPagingExecutor<BEHAVIOR> removeLineComment() {
        this._outsideSqlOption.removeLineComment();
        return this;
    }

    public AbstractOutsideSqlPagingExecutor<BEHAVIOR> formatSql() {
        this._outsideSqlOption.formatSql();
        return this;
    }

    public AbstractOutsideSqlPagingExecutor<BEHAVIOR> configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }
}

