/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause.subquery;

import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

public abstract class AbstractSubQuery {
    protected final SubQueryPath _subQueryPath;
    protected final ColumnRealNameProvider _localRealNameProvider;
    protected final ColumnSqlNameProvider _subQuerySqlNameProvider;
    protected final int _subQueryLevel;
    protected final SqlClause _subQuerySqlClause;
    protected final String _subQueryIdentity;
    protected final DBMeta _subQueryDBMeta;

    public AbstractSubQuery(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQuerySqlClause, String subQueryIdentity, DBMeta subQueryDBMeta) {
        this._subQueryPath = subQueryPath;
        this._localRealNameProvider = localRealNameProvider;
        this._subQuerySqlNameProvider = subQuerySqlNameProvider;
        this._subQueryLevel = subQueryLevel;
        this._subQuerySqlClause = subQuerySqlClause;
        this._subQueryIdentity = subQueryIdentity;
        this._subQueryDBMeta = subQueryDBMeta;
    }

    protected String getSubQueryLocalAliasName() {
        return this._subQuerySqlClause.getBasePointAliasName();
    }

    protected String buildSubQueryMainAliasName() {
        return "sub" + this._subQueryLevel + "main";
    }

    protected String resolveSubQueryLevelVariable(String subQueryClause) {
        return this.replace(subQueryClause, "${subQueryLevel}", String.valueOf(this._subQueryLevel));
    }

    protected String buildPlainFromWhereClause(String selectClause, String localAliasName) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, localAliasName);
        return clause.buildPlainSubQueryFromWhereClause();
    }

    protected String buildCorrelationFromWhereClause(String selectClause, String localAliasName, ColumnRealName correlatedColumnRealName, ColumnSqlName relatedColumnSqlName) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, localAliasName);
        return clause.buildCorrelationSubQueryFromWhereClause(correlatedColumnRealName, relatedColumnSqlName);
    }

    protected String buildCorrelationFromWhereClause(String selectClause, String localAliasName, ColumnRealName[] correlatedColumnRealNames, ColumnSqlName[] relatedColumnSqlNames) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, localAliasName);
        return clause.buildCorrelationSubQueryFromWhereClause(correlatedColumnRealNames, relatedColumnSqlNames);
    }

    protected SubQueryClause createSubQueryClause(String selectClause, String localAliasName) {
        return new SubQueryClause(this._subQueryPath, selectClause, this._subQuerySqlClause, localAliasName);
    }

    protected String resolveSubQueryBeginMark(String subQueryIdentity) {
        return this._subQuerySqlClause.resolveSubQueryBeginMark(subQueryIdentity);
    }

    protected String resolveSubQueryEndMark(String subQueryIdentity) {
        return this._subQuerySqlClause.resolveSubQueryEndMark(subQueryIdentity);
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected final String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected final String initCap(String str) {
        return Srl.initCap(str);
    }

    protected final String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected final String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public SubQueryPath getSubQueryPath() {
        return this._subQueryPath;
    }

    public int getSubQueryLevel() {
        return this._subQueryLevel;
    }

    public SqlClause getSubQuerySqlClause() {
        return this._subQuerySqlClause;
    }
}

