/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.ParameterUtil;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Entity {
    public DBMeta getDBMeta();

    public String getTableDbName();

    public String getTablePropertyName();

    public boolean hasPrimaryKeyValue();

    public Set<String> modifiedProperties();

    public void clearModifiedInfo();

    public boolean hasModification();

    public String toStringWithRelation();

    public String buildDisplayString(String var1, boolean var2, boolean var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class InternalUtil {
        public static <NUMBER extends Number> NUMBER toNumber(Object obj, Class<NUMBER> type) {
            return (NUMBER)DfTypeUtil.toNumber(obj, type);
        }

        public static Boolean toBoolean(Object obj) {
            return DfTypeUtil.toBoolean(obj);
        }

        public static boolean isSameValue(Object value1, Object value2) {
            if (value1 == null && value2 == null) {
                return true;
            }
            if (value1 == null || value2 == null) {
                return false;
            }
            if (value1 instanceof byte[] && value2 instanceof byte[]) {
                return InternalUtil.isSameValueBytes((byte[])value1, (byte[])value2);
            }
            return value1.equals(value2);
        }

        public static boolean isSameValueBytes(byte[] bytes1, byte[] bytes2) {
            if (bytes1 == null && bytes2 == null) {
                return true;
            }
            if (bytes1 == null || bytes2 == null) {
                return false;
            }
            if (bytes1.length != bytes2.length) {
                return false;
            }
            for (int i = 0; i < bytes1.length; ++i) {
                if (bytes1[i] == bytes2[i]) continue;
                return false;
            }
            return true;
        }

        public static int calculateHashcode(int result, Object value) {
            if (value == null) {
                return result;
            }
            return 31 * result + (value instanceof byte[] ? ((byte[])value).length : value.hashCode());
        }

        public static String convertEmptyToNull(String value) {
            return ParameterUtil.convertEmptyToNull(value);
        }

        public static String toClassTitle(Entity entity) {
            return DfTypeUtil.toClassTitle(entity);
        }

        public static String toString(Date date, String pattern) {
            if (date == null) {
                return null;
            }
            String str = DfTypeUtil.toString(date, pattern);
            return (DfTypeUtil.isDateBC(date) ? "BC" : "") + str;
        }

        public static String toString(byte[] bytes) {
            return "byte[" + (bytes != null ? String.valueOf(bytes.length) : "null") + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntityModifiedProperties
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Set<String> _propertiesSet = new LinkedHashSet<String>();

        public void addPropertyName(String propertyName) {
            this._propertiesSet.add(propertyName);
        }

        public Set<String> getPropertyNames() {
            return this._propertiesSet;
        }

        public boolean isEmpty() {
            return this._propertiesSet.isEmpty();
        }

        public void clear() {
            this._propertiesSet.clear();
        }

        public void remove(String propertyName) {
            this._propertiesSet.remove(propertyName);
        }
    }
}

