/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cmap.CMap;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.util.ResourceLoader;

public abstract class PDCIDFont
extends PDSimpleFont {
    private static final Log log = LogFactory.getLog(PDCIDFont.class);
    private Map<Integer, Float> widthCache = null;
    private long defaultWidth = 0L;

    public PDCIDFont() {
    }

    public PDCIDFont(COSDictionary fontDictionary) {
        super(fontDictionary);
        this.extractWidths();
    }

    public PDRectangle getFontBoundingBox() throws IOException {
        throw new RuntimeException("getFontBoundingBox(): Not yet implemented");
    }

    public long getDefaultWidth() {
        if (this.defaultWidth == 0L) {
            COSNumber number = (COSNumber)this.font.getDictionaryObject(COSName.DW);
            this.defaultWidth = number != null ? (long)number.intValue() : 1000L;
        }
        return this.defaultWidth;
    }

    public void setDefaultWidth(long dw) {
        this.defaultWidth = dw;
        this.font.setLong(COSName.DW, dw);
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        float retval = this.getDefaultWidth();
        int code = this.getCodeFromArray(c, offset, length);
        Float widthFloat = this.widthCache.get(code);
        if (widthFloat != null) {
            retval = widthFloat.floatValue();
        }
        return retval;
    }

    private void extractWidths() {
        if (this.widthCache == null) {
            this.widthCache = new HashMap<Integer, Float>();
            COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.W);
            if (widths != null) {
                int size = widths.size();
                int counter = 0;
                while (counter < size) {
                    COSBase next;
                    COSNumber firstCode = (COSNumber)widths.getObject(counter++);
                    if ((next = widths.getObject(counter++)) instanceof COSArray) {
                        COSArray array = (COSArray)next;
                        int startRange = firstCode.intValue();
                        int arraySize = array.size();
                        for (int i = 0; i < arraySize; ++i) {
                            COSNumber width = (COSNumber)array.get(i);
                            this.widthCache.put(startRange + i, Float.valueOf(width.floatValue()));
                        }
                        continue;
                    }
                    COSNumber secondCode = (COSNumber)next;
                    COSNumber rangeWidth = (COSNumber)widths.getObject(counter++);
                    int startRange = firstCode.intValue();
                    int endRange = secondCode.intValue();
                    float width = rangeWidth.floatValue();
                    for (int i = startRange; i <= endRange; ++i) {
                        this.widthCache.put(i, Float.valueOf(width));
                    }
                }
            }
        }
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        float retval = 0.0f;
        PDFontDescriptor desc = this.getFontDescriptor();
        float xHeight = desc.getXHeight();
        float capHeight = desc.getCapHeight();
        retval = xHeight != 0.0f && capHeight != 0.0f ? (xHeight + capHeight) / 2.0f : (xHeight != 0.0f ? xHeight : (capHeight != 0.0f ? capHeight : 0.0f));
        if (retval == 0.0f) {
            retval = desc.getAscent();
        }
        return retval;
    }

    public float getAverageFontWidth() throws IOException {
        float average;
        float totalWidths = 0.0f;
        float characterCount = 0.0f;
        float defaultWidth = this.getDefaultWidth();
        COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.W);
        if (widths != null) {
            for (int i = 0; i < widths.size(); ++i) {
                COSNumber rangeWidth;
                COSNumber firstCode = (COSNumber)widths.getObject(i++);
                COSBase next = widths.getObject(i);
                if (next instanceof COSArray) {
                    COSArray array = (COSArray)next;
                    for (int j = 0; j < array.size(); ++j) {
                        COSNumber width = (COSNumber)array.get(j);
                        totalWidths += width.floatValue();
                        characterCount += 1.0f;
                    }
                    continue;
                }
                if (!((rangeWidth = (COSNumber)widths.getObject(++i)).floatValue() > 0.0f)) continue;
                totalWidths += rangeWidth.floatValue();
                characterCount += 1.0f;
            }
        }
        if ((average = totalWidths / characterCount) <= 0.0f) {
            average = defaultWidth;
        }
        return average;
    }

    public float getFontWidth(int charCode) {
        float width = -1.0f;
        if (this.widthCache.containsKey(charCode)) {
            width = this.widthCache.get(charCode).floatValue();
        }
        return width;
    }

    private String getCIDSystemInfo() {
        String cidSystemInfo = null;
        COSDictionary cidsysteminfo = (COSDictionary)this.font.getDictionaryObject(COSName.CIDSYSTEMINFO);
        if (cidsysteminfo != null) {
            String ordering = cidsysteminfo.getString(COSName.ORDERING);
            String registry = cidsysteminfo.getString(COSName.REGISTRY);
            int supplement = cidsysteminfo.getInt(COSName.SUPPLEMENT);
            cidSystemInfo = registry + "-" + ordering + "-" + supplement;
        }
        return cidSystemInfo;
    }

    protected void determineEncoding() {
        String cidSystemInfo = this.getCIDSystemInfo();
        if (cidSystemInfo != null) {
            cidSystemInfo = cidSystemInfo.contains("Identity") ? "Identity-H" : cidSystemInfo.substring(0, cidSystemInfo.lastIndexOf("-")) + "-UCS2";
            this.cmap = (CMap)cmapObjects.get(cidSystemInfo);
            if (this.cmap == null) {
                String resourceName = "org/apache/pdfbox/resources/cmap/" + cidSystemInfo;
                try {
                    this.parseCmap("org/apache/pdfbox/resources/cmap/", ResourceLoader.loadResource(resourceName), null);
                    if (this.cmap == null) {
                        log.error((Object)("Error: Could not parse predefined CMAP file for '" + cidSystemInfo + "'"));
                    }
                }
                catch (IOException exception) {
                    log.error((Object)("Error: Could not find predefined CMAP file for '" + cidSystemInfo + "'"));
                }
            }
        } else {
            super.determineEncoding();
        }
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        String result = null;
        result = this.cmap != null ? this.cmapEncoding(this.getCodeFromArray(c, offset, length), length, true) : super.encode(c, offset, length);
        return result;
    }
}

