/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.jdbc.IllegalBindArgSizeRuntimeException;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.util.SStringBuilder;

public class BindVariableUtil {
    private static final String NULL = "null";

    protected BindVariableUtil() {
    }

    public static String getCompleteSql(String sql, Object[] args) {
        if (args == null || args.length == 0) {
            return sql;
        }
        return BindVariableUtil.getCompleteSql(sql, args, new ValueType[args.length]);
    }

    public static String getCompleteSql(String sql, Object[] args, ValueType[] valueTypes) {
        if (args == null || args.length == 0) {
            return sql;
        }
        StringBuffer buf = new StringBuffer(sql.length() + args.length * 15);
        int pos = 0;
        int pos2 = 0;
        int pos3 = 0;
        int pos4 = 0;
        int pos5 = 0;
        int pos6 = 0;
        int index = 0;
        while (true) {
            pos = sql.indexOf(63, pos2);
            pos3 = sql.indexOf(39, pos2);
            pos4 = sql.indexOf(39, pos3 + 1);
            pos5 = sql.indexOf("/*", pos2);
            pos6 = sql.indexOf("*/", pos5 + 1);
            if (pos <= 0) break;
            if (pos3 >= 0 && pos3 < pos && pos < pos4) {
                buf.append(sql.substring(pos2, pos4 + 1));
                pos2 = pos4 + 1;
                continue;
            }
            if (pos5 >= 0 && pos5 < pos && pos < pos6) {
                buf.append(sql.substring(pos2, pos6 + 1));
                pos2 = pos6 + 1;
                continue;
            }
            if (args.length <= index) {
                throw new IllegalBindArgSizeRuntimeException(sql, args.length);
            }
            buf.append(sql.substring(pos2, pos));
            buf.append(BindVariableUtil.getBindVariableText(args[index], valueTypes[index]));
            pos2 = pos + 1;
            ++index;
        }
        buf.append(sql.substring(pos2));
        return buf.toString();
    }

    public static String getBindVariableText(Object bindVariable) {
        if (bindVariable instanceof String) {
            return BindVariableUtil.quote(bindVariable.toString());
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
            return BindVariableUtil.quote(sdf.format((Date)bindVariable));
        }
        if (bindVariable instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return BindVariableUtil.quote(sdf.format((Date)bindVariable));
        }
        if (bindVariable instanceof Boolean) {
            return bindVariable.toString();
        }
        if (bindVariable == null) {
            return NULL;
        }
        return BindVariableUtil.quote(bindVariable.toString());
    }

    public static String getBindVariableText(Object bindVariable, ValueType valueType) {
        if (valueType != null) {
            return valueType.toText(bindVariable);
        }
        return BindVariableUtil.getBindVariableText(bindVariable);
    }

    public static String nullText() {
        return NULL;
    }

    public static String toText(Number value) {
        if (value == null) {
            return NULL;
        }
        return value.toString();
    }

    public static String toText(Boolean value) {
        if (value == null) {
            return NULL;
        }
        return BindVariableUtil.quote(value.toString());
    }

    public static String toText(String value) {
        if (value == null) {
            return NULL;
        }
        return BindVariableUtil.quote(value);
    }

    public static String toText(java.sql.Date value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        SStringBuilder buf = new SStringBuilder();
        BindVariableUtil.addDate(buf, calendar);
        return BindVariableUtil.quote(buf.toString());
    }

    public static String toText(Time value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        SStringBuilder buf = new SStringBuilder();
        BindVariableUtil.addTime(buf, calendar);
        BindVariableUtil.addTimeDecimalPart(buf, calendar.get(14));
        return BindVariableUtil.quote(buf.toString());
    }

    public static String toText(Timestamp value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        SStringBuilder buf = new SStringBuilder(30);
        BindVariableUtil.addDate(buf, calendar);
        BindVariableUtil.addTime(buf, calendar);
        BindVariableUtil.addTimeDecimalPart(buf, value.getNanos());
        return BindVariableUtil.quote(buf.toString());
    }

    public static String toText(byte[] value) {
        if (value == null) {
            return NULL;
        }
        return BindVariableUtil.quote(value.toString() + "(byteLength=" + Integer.toString(value.length) + ")");
    }

    public static String toText(Object value) {
        if (value == null) {
            return NULL;
        }
        return BindVariableUtil.quote(value.toString());
    }

    protected static void addDate(SStringBuilder buf, Calendar calendar) {
        int year = calendar.get(1);
        buf.append(year);
        buf.append('-');
        int month = calendar.get(2) + 1;
        if (month < 10) {
            buf.append('0');
        }
        buf.append(month);
        buf.append('-');
        int date = calendar.get(5);
        if (date < 10) {
            buf.append('0');
        }
        buf.append(date);
    }

    protected static void addTime(SStringBuilder buf, Calendar calendar) {
        int hour;
        if (buf.length() > 0) {
            buf.append(' ');
        }
        if ((hour = calendar.get(11)) < 10) {
            buf.append('0');
        }
        buf.append(hour);
        buf.append(':');
        int minute = calendar.get(12);
        if (minute < 10) {
            buf.append('0');
        }
        buf.append(minute);
        buf.append(':');
        int second = calendar.get(13);
        if (second < 10) {
            buf.append('0');
        }
        buf.append(second);
    }

    protected static void addTimeDecimalPart(SStringBuilder buf, int decimalPart) {
        if (decimalPart == 0) {
            return;
        }
        if (buf.length() > 0) {
            buf.append('.');
        }
        buf.append(decimalPart);
    }

    protected static String quote(String text) {
        return "'" + text + "'";
    }
}

