/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.twowaysql.node;

import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.twowaysql.context.CommandContext;
import org.seasar.robot.dbflute.twowaysql.exception.LoopVariableCommentOutOfForCommentException;
import org.seasar.robot.dbflute.twowaysql.node.ForNode;
import org.seasar.robot.dbflute.twowaysql.node.LoopAcceptable;
import org.seasar.robot.dbflute.twowaysql.node.LoopInfo;
import org.seasar.robot.dbflute.twowaysql.node.ScopeNode;
import org.seasar.robot.dbflute.util.DfTypeUtil;
import org.seasar.robot.dbflute.util.Srl;

public abstract class LoopAbstractNode
extends ScopeNode
implements LoopAcceptable {
    protected final String _expression;
    protected final String _replacement;
    protected final String _specifiedSql;

    public LoopAbstractNode(String expression, String specifiedSql) {
        this._expression = expression;
        Srl.ScopeInfo scope = Srl.extractScopeWide(this._expression, "'", "'");
        this._replacement = scope != null ? scope.getContent() : null;
        this._specifiedSql = specifiedSql;
    }

    public void accept(CommandContext ctx) {
        ForNode.LoopVariableType type = this.getLoopVariableType();
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The " + type.name() + " comment was out of FOR comment!");
        br.addItem("Advice");
        br.addElement("A " + type.name() + " comment should be in FOR comment scope.");
        br.addElement("For example:");
        br.addElement(" (x):");
        br.addElement("   /*" + type.name() + "*/.../*END*/");
        br.addElement("   /*FOR*/.../*END*/");
        br.addElement(" (o):");
        br.addElement("   /*FOR*/");
        br.addElement("   /*" + type.name() + "*/.../*END*/");
        br.addElement("   /*END*/");
        br.addItem(type.name() + " Comment Expression");
        br.addElement(this._expression);
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new LoopVariableCommentOutOfForCommentException(msg);
    }

    protected abstract ForNode.LoopVariableType getLoopVariableType();

    public void accept(CommandContext ctx, LoopInfo loopInfo) {
        int loopIndex;
        int loopSize = loopInfo.getLoopSize();
        if (!this.isValid(loopSize, loopIndex = loopInfo.getLoopIndex())) {
            return;
        }
        this.acceptFrontPrefix(ctx);
        this.processAcceptingChildren(ctx, loopInfo);
    }

    protected abstract boolean isValid(int var1, int var2);

    protected void acceptFrontPrefix(CommandContext ctx) {
        if (Srl.is_NotNull_and_NotTrimmedEmpty(this._replacement)) {
            ctx.addSql(this._replacement);
        }
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._expression + "}";
    }
}

