/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.netcdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetCDFParser
extends AbstractParser {
    private final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-netcdf"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)stream, (OutputStream)os);
        String name = metadata.get("resourceName");
        if (name == null) {
            name = "";
        }
        try {
            NetcdfFile ncFile = NetcdfFile.openInMemory((String)name, (byte[])os.toByteArray());
            for (Attribute attr : ncFile.getGlobalAttributes()) {
                String attrName = attr.getName();
                if (attr.getDataType().isString()) {
                    metadata.add(attrName, attr.getStringValue());
                    continue;
                }
                if (!attr.getDataType().isNumeric()) continue;
                int value = attr.getNumericValue().intValue();
                metadata.add(attrName, String.valueOf(value));
            }
        }
        catch (IOException e) {
            throw new TikaException("NetCDF parse error", (Throwable)e);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }
}

