/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class ContainerAwareDetector
implements Detector {
    private Detector fallbackDetector;
    private Detector defaultDetector;

    public ContainerAwareDetector(Detector fallbackDetector) {
        this.fallbackDetector = fallbackDetector;
        this.defaultDetector = new DefaultDetector();
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        MediaType type = this.defaultDetector.detect(input, metadata);
        if (MediaType.OCTET_STREAM.equals(type)) {
            return this.fallbackDetector.detect(input, metadata);
        }
        return type;
    }
}

