/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Pattern;
import org.seasar.robot.entity.AccessResult;
import org.seasar.robot.entity.UrlQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryDataHelper {
    protected volatile Map<String, Queue<UrlQueue>> urlQueueMap = new HashMap<String, Queue<UrlQueue>>();
    protected volatile Map<String, Map<String, AccessResult>> sessionMap = new HashMap<String, Map<String, AccessResult>>();
    protected volatile Map<String, List<Pattern>> includeUrlPatternMap = new HashMap<String, List<Pattern>>();
    protected volatile Map<String, List<Pattern>> excludeUrlPatternMap = new HashMap<String, List<Pattern>>();

    public void clear() {
        this.urlQueueMap.clear();
        this.sessionMap.clear();
    }

    public synchronized Queue<UrlQueue> getUrlQueueList(String sessionId) {
        Queue<UrlQueue> urlQueueList = this.urlQueueMap.get(sessionId);
        if (urlQueueList == null) {
            urlQueueList = new LinkedList<UrlQueue>();
            this.urlQueueMap.put(sessionId, urlQueueList);
        }
        return urlQueueList;
    }

    public synchronized void addUrlQueueList(String sessionId, Queue<UrlQueue> urlQueueList) {
        Queue<UrlQueue> uqList = this.getUrlQueueList(sessionId);
        uqList.addAll(urlQueueList);
        this.urlQueueMap.put(sessionId, uqList);
    }

    public synchronized void removeUrlQueueList(String sessionId) {
        this.urlQueueMap.remove(sessionId);
    }

    public synchronized void clearUrlQueueList() {
        this.urlQueueMap.clear();
    }

    public synchronized Map<String, AccessResult> getAccessResultMap(String sessionId) {
        Map<String, AccessResult> arMap = this.sessionMap.get(sessionId);
        if (arMap == null) {
            arMap = new HashMap<String, AccessResult>();
            this.sessionMap.put(sessionId, arMap);
        }
        return arMap;
    }

    public synchronized void deleteAccessResultMap(String sessionId) {
        this.sessionMap.remove(sessionId);
    }

    public synchronized void deleteAllAccessResultMap() {
        this.sessionMap.clear();
    }

    public synchronized List<AccessResult> getAccessResultList(String url) {
        ArrayList<AccessResult> acList = new ArrayList<AccessResult>();
        for (Map.Entry<String, Map<String, AccessResult>> entry : this.sessionMap.entrySet()) {
            AccessResult ar;
            if (entry.getValue() == null || (ar = entry.getValue().get(url)) == null) continue;
            acList.add(ar);
        }
        return acList;
    }

    public synchronized void addIncludeUrlPattern(String sessionId, String url) {
        List<Pattern> patternList = this.getIncludeUrlPatternList(sessionId);
        patternList.add(Pattern.compile(url));
    }

    public List<Pattern> getIncludeUrlPatternList(String sessionId) {
        List<Pattern> patternList = this.includeUrlPatternMap.get(sessionId);
        if (patternList == null) {
            patternList = new ArrayList<Pattern>();
            this.includeUrlPatternMap.put(sessionId, patternList);
        }
        return patternList;
    }

    public synchronized void addExcludeUrlPattern(String sessionId, String url) {
        List<Pattern> patternList = this.getExcludeUrlPatternList(sessionId);
        patternList.add(Pattern.compile(url));
    }

    public List<Pattern> getExcludeUrlPatternList(String sessionId) {
        List<Pattern> patternList = this.excludeUrlPatternMap.get(sessionId);
        if (patternList == null) {
            patternList = new ArrayList<Pattern>();
            this.excludeUrlPatternMap.put(sessionId, patternList);
        }
        return patternList;
    }

    public synchronized void clearUrlPattern(String sessionId) {
        this.includeUrlPatternMap.remove(sessionId);
        this.excludeUrlPatternMap.remove(sessionId);
    }

    public synchronized void clearUrlPattern() {
        this.includeUrlPatternMap.clear();
        this.excludeUrlPatternMap.clear();
    }
}

