/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.framework.util.StringUtil;

public class BigDecimalConversionUtil {
    protected static final String TIGER_NORMALIZER_CLASS_NAME = "org.seasar.framework.util.TigerBigDecimalConversion";
    protected static BigDecimalNormalizer normalizer = new DefaultNormalizer();

    protected BigDecimalConversionUtil() {
    }

    public static BigDecimal toBigDecimal(Object o) {
        return BigDecimalConversionUtil.toBigDecimal(o, null);
    }

    public static BigDecimal toBigDecimal(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new BigDecimal(new SimpleDateFormat(pattern).format(o));
            }
            return new BigDecimal(Long.toString(((Date)o).getTime()));
        }
        if (o instanceof String) {
            String s = (String)o;
            if (StringUtil.isEmpty(s)) {
                return null;
            }
            return normalizer.normalize(new BigDecimal(s));
        }
        return normalizer.normalize(new BigDecimal(o.toString()));
    }

    public static String toString(BigDecimal dec) {
        return normalizer.toString(dec);
    }

    static {
        try {
            Class<?> clazz = Class.forName(TIGER_NORMALIZER_CLASS_NAME);
            normalizer = (BigDecimalNormalizer)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DefaultNormalizer
    implements BigDecimalNormalizer {
        public BigDecimal normalize(BigDecimal dec) {
            return dec;
        }

        public String toString(BigDecimal dec) {
            return dec.toString();
        }
    }

    public static interface BigDecimalNormalizer {
        public BigDecimal normalize(BigDecimal var1);

        public String toString(BigDecimal var1);
    }
}

