/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.executor.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.executor.ExecutorServiceFactory;
import org.seasar.chronos.core.threadpool.ThreadPool;
import org.seasar.framework.log.Logger;

public class ExecutorServiceFactoryImpl
implements ExecutorServiceFactory {
    private static Logger log = Logger.getLogger(ExecutorServiceFactoryImpl.class);
    private final AtomicLong threadGroupNo = new AtomicLong();

    public ExecutorService create(ThreadPoolType type, Integer threadPoolSize) {
        return this.create(type, threadPoolSize, false);
    }

    public ExecutorService create(ThreadPoolType type, Integer threadPoolSize, boolean daemon) {
        ExecutorService executorService = null;
        this.threadGroupNo.addAndGet(1L);
        if (type.equals((Object)ThreadPoolType.CACHED)) {
            executorService = Executors.newCachedThreadPool(new ThreadFactoryImpl(daemon));
        } else if (type.equals((Object)ThreadPoolType.FIXED)) {
            executorService = Executors.newFixedThreadPool(threadPoolSize, new ThreadFactoryImpl(daemon));
        } else if (type.equals((Object)ThreadPoolType.SCHEDULED)) {
            executorService = Executors.newScheduledThreadPool(threadPoolSize, new ThreadFactoryImpl(daemon));
        } else if (type.equals((Object)ThreadPoolType.SINGLE)) {
            executorService = Executors.newSingleThreadExecutor(new ThreadFactoryImpl(daemon));
        }
        return executorService;
    }

    public ExecutorService create(ThreadPool threadPool) {
        return this.create(threadPool.getThreadPoolType(), threadPool.getThreadPoolSize(), false);
    }

    public ExecutorService create(ThreadPool threadPool, boolean daemon) {
        return this.create(threadPool.getThreadPoolType(), threadPool.getThreadPoolSize(), daemon);
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        private boolean daemon = false;

        public ThreadFactoryImpl(boolean daemon) {
            this.daemon = daemon;
            SecurityManager securitymanager = System.getSecurityManager();
            this.group = securitymanager == null ? Thread.currentThread().getThreadGroup() : securitymanager.getThreadGroup();
            StringBuilder sb = new StringBuilder();
            sb.append("chronos-").append("pool-").append(poolNumber.getAndIncrement());
            sb.append("-");
            if (daemon) {
                sb.append("daemon");
            }
            sb.append("thread-");
            this.namePrefix = sb.toString();
        }

        public Thread newThread(Runnable runnable) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.namePrefix).append(this.threadNumber.getAndIncrement());
            Thread thread = new Thread(this.group, runnable, sb.toString(), 0L);
            thread.setDaemon(this.daemon);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

