/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.image.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import org.mobylet.core.image.ConnectionStream;
import org.mobylet.core.image.ImageConfig;
import org.mobylet.core.image.ImageReader;
import org.mobylet.core.image.ImageSourceType;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.util.HttpUtils;
import org.mobylet.core.util.InputStreamUtils;
import org.mobylet.core.util.PathUtils;
import org.mobylet.core.util.ResourceUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.UrlUtils;

public class MobyletImageReader
implements ImageReader {
    protected File imageBaseUri;
    protected boolean isInitializedUri = false;

    @Override
    public File getImageBase() {
        File localBaseDir;
        if (this.isInitializedUri) {
            return this.imageBaseUri;
        }
        ImageConfig config = SingletonUtils.get(ImageConfig.class);
        String localBaseDirPath = config.getLocalBaseDirPath();
        if (StringUtils.isNotEmpty(localBaseDirPath) && (localBaseDir = new File(localBaseDirPath)).exists() && localBaseDir.isDirectory() && localBaseDir.canRead()) {
            this.imageBaseUri = localBaseDir;
        }
        this.isInitializedUri = true;
        return this.getImageBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionStream getStream(String path) {
        ImageConfig config = SingletonUtils.get(ImageConfig.class);
        InputStream imageStream = null;
        if (PathUtils.isNetworkPath(path)) {
            if (config.getImageSourceType() == ImageSourceType.LOCAL) {
                return null;
            }
            if (config.getAllowUrlRegex() != null && !config.getAllowUrlRegex().matcher(path).matches()) {
                return null;
            }
            if (config.getNetworkLimitSize() > 0) {
                HttpURLConnection checkConnection = null;
                try {
                    checkConnection = HttpUtils.getHttpUrlConnection(path);
                    checkConnection.setRequestMethod("HEAD");
                    checkConnection.connect();
                    if (checkConnection.getContentLength() > config.getNetworkLimitSize()) {
                        ConnectionStream connectionStream = null;
                        return connectionStream;
                    }
                }
                catch (ProtocolException e) {
                    MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
                    if (logger != null && logger.isLoggable()) {
                        logger.log("[mobylet] Protocol Exception\u304c\u767a\u751f URL = " + path);
                        e.printStackTrace();
                    }
                    ConnectionStream connectionStream = null;
                    return connectionStream;
                }
                catch (IOException e) {
                    MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
                    if (logger != null && logger.isLoggable()) {
                        logger.log("[mobylet] I/O\u4f8b\u5916\u304c\u767a\u751f URL = " + path);
                        e.printStackTrace();
                    }
                    ConnectionStream connectionStream = null;
                    return connectionStream;
                }
                finally {
                    if (checkConnection != null) {
                        checkConnection.disconnect();
                    }
                }
            }
            HttpURLConnection connection = HttpUtils.getHttpUrlConnection(path);
            try {
                imageStream = connection.getInputStream();
            }
            catch (IOException e) {
                MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
                if (logger != null && logger.isLoggable()) {
                    logger.log("\u30b9\u30c8\u30ea\u30fc\u30e0\u3092\u30aa\u30fc\u30d7\u30f3\u3067\u304d\u307e\u305b\u3093 path = " + path);
                }
                return null;
            }
            return new ConnectionStream(connection, imageStream);
        }
        if (config.getImageSourceType() == ImageSourceType.NETWORK) {
            return null;
        }
        imageStream = ResourceUtils.getResourceFileOrInputStream(path);
        if (config.getLocalLimitSize() > 0) {
            try {
                int size = imageStream.available();
                if (size > config.getLocalLimitSize()) {
                    InputStreamUtils.closeQuietly(imageStream);
                    return null;
                }
            }
            catch (IOException e) {
                InputStreamUtils.closeQuietly(imageStream);
                return null;
            }
        }
        return new ConnectionStream(null, imageStream);
    }

    @Override
    public File getFile(String path) {
        if (this.getImageBase() == null) {
            return null;
        }
        return new File(this.getImageBase().getAbsolutePath() + File.separator + path);
    }

    @Override
    public String constructPath(String path) {
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        if (PathUtils.isNetworkPath(path)) {
            return path;
        }
        File imageBase = this.getImageBase();
        if (imageBase == null) {
            String currentUrl = UrlUtils.getCurrentUrl();
            int index = -1;
            index = currentUrl.lastIndexOf(47);
            currentUrl = index > 0 ? currentUrl.substring(0, index + 1) : currentUrl + "/";
            return currentUrl + path;
        }
        return imageBase.getAbsolutePath() + File.separator + path;
    }
}

