/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.cache.HttpCacheEntrySerializer;
import org.apache.http.impl.client.cache.CacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultCacheEntrySerializer
implements HttpCacheEntrySerializer<CacheEntry> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(CacheEntry cacheEntry, OutputStream os) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(os);
            oos.writeObject(cacheEntry);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception ignore) {}
            try {
                os.close();
            }
            catch (Exception ignore) {}
        }
    }

    @Override
    public CacheEntry readFrom(InputStream is) throws IOException {
        ObjectInputStream ois = null;
        try {
            CacheEntry cacheEntry;
            ois = new ObjectInputStream(is);
            CacheEntry cacheEntry2 = cacheEntry = (CacheEntry)ois.readObject();
            return cacheEntry2;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception ignore) {}
            try {
                is.close();
            }
            catch (Exception ignore) {}
        }
    }
}

