/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.cache.HttpCache;
import org.apache.http.client.cache.HttpCacheOperationException;
import org.apache.http.impl.client.cache.CacheEntry;
import org.apache.http.impl.client.cache.URIExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class CacheInvalidator {
    private final HttpCache<CacheEntry> cache;
    private final URIExtractor uriExtractor;
    private final Log log = LogFactory.getLog(this.getClass());

    public CacheInvalidator(URIExtractor uriExtractor, HttpCache<CacheEntry> cache) {
        this.uriExtractor = uriExtractor;
        this.cache = cache;
    }

    public void flushInvalidatedCacheEntries(HttpHost host, HttpRequest req) {
        if (this.requestShouldNotBeCached(req)) {
            this.log.debug((Object)"Request should not be cached");
            try {
                String theUri = this.uriExtractor.getURI(host, req);
                CacheEntry parent = this.cache.getEntry(theUri);
                this.log.debug((Object)("parent entry: " + parent));
                if (parent != null) {
                    for (String variantURI : parent.getVariantURIs()) {
                        this.cache.removeEntry(variantURI);
                    }
                    this.cache.removeEntry(theUri);
                }
            }
            catch (HttpCacheOperationException ex) {
                this.log.debug((Object)"Was unable to REMOVE an entry from the cache based on the uri provided", (Throwable)ex);
            }
        }
    }

    protected boolean requestShouldNotBeCached(HttpRequest req) {
        String method = req.getRequestLine().getMethod();
        return this.notGetOrHeadRequest(method) || this.containsCacheControlHeader(req) || this.containsPragmaHeader(req);
    }

    private boolean notGetOrHeadRequest(String method) {
        return !"GET".equals(method) && !"HEAD".equals(method);
    }

    private boolean containsPragmaHeader(HttpRequest req) {
        return req.getFirstHeader("Pragma") != null;
    }

    private boolean containsCacheControlHeader(HttpRequest request) {
        Header[] cacheControlHeaders = request.getHeaders("Cache-Control");
        if (cacheControlHeaders == null) {
            return false;
        }
        for (Header cacheControl : cacheControlHeaders) {
            HeaderElement[] cacheControlElements = cacheControl.getElements();
            if (cacheControlElements == null) {
                return false;
            }
            for (HeaderElement cacheControlElement : cacheControlElements) {
                if ("no-cache".equalsIgnoreCase(cacheControlElement.getName())) {
                    return true;
                }
                if (!"no-store".equalsIgnoreCase(cacheControlElement.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

