/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.client.cache.CacheEntry;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CacheEntryUpdater {
    public CacheEntry updateCacheEntry(CacheEntry entry, Date requestDate, Date responseDate, HttpResponse response) {
        Header[] mergedHeaders = this.mergeHeaders(entry, response);
        CacheEntry updated = new CacheEntry(requestDate, responseDate, entry.getProtocolVersion(), mergedHeaders, entry.getBody(), entry.getStatusCode(), entry.getReasonPhrase());
        return updated;
    }

    protected Header[] mergeHeaders(CacheEntry entry, HttpResponse response) {
        ArrayList<Header> cacheEntryHeaderList = new ArrayList<Header>(Arrays.asList(entry.getAllHeaders()));
        if (this.entryAndResponseHaveDateHeader(entry, response) && this.entryDateHeaderNewerThenResponse(entry, response)) {
            this.removeCacheEntry1xxWarnings(cacheEntryHeaderList, entry);
            return cacheEntryHeaderList.toArray(new Header[cacheEntryHeaderList.size()]);
        }
        this.removeCacheHeadersThatMatchResponse(cacheEntryHeaderList, response);
        cacheEntryHeaderList.addAll(Arrays.asList(response.getAllHeaders()));
        this.removeCacheEntry1xxWarnings(cacheEntryHeaderList, entry);
        return cacheEntryHeaderList.toArray(new Header[cacheEntryHeaderList.size()]);
    }

    private void removeCacheHeadersThatMatchResponse(List<Header> cacheEntryHeaderList, HttpResponse response) {
        for (Header responseHeader : response.getAllHeaders()) {
            ListIterator<Header> cacheEntryHeaderListIter = cacheEntryHeaderList.listIterator();
            while (cacheEntryHeaderListIter.hasNext()) {
                String cacheEntryHeaderName = cacheEntryHeaderListIter.next().getName();
                if (!cacheEntryHeaderName.equals(responseHeader.getName())) continue;
                cacheEntryHeaderListIter.remove();
            }
        }
    }

    private void removeCacheEntry1xxWarnings(List<Header> cacheEntryHeaderList, CacheEntry entry) {
        ListIterator<Header> cacheEntryHeaderListIter = cacheEntryHeaderList.listIterator();
        while (cacheEntryHeaderListIter.hasNext()) {
            String cacheEntryHeaderName = cacheEntryHeaderListIter.next().getName();
            if (!"Warning".equals(cacheEntryHeaderName)) continue;
            for (Header cacheEntryWarning : entry.getHeaders("Warning")) {
                if (!cacheEntryWarning.getValue().startsWith("1")) continue;
                cacheEntryHeaderListIter.remove();
            }
        }
    }

    private boolean entryDateHeaderNewerThenResponse(CacheEntry entry, HttpResponse response) {
        try {
            Date entryDate = DateUtils.parseDate((String)entry.getFirstHeader("Date").getValue());
            Date responseDate = DateUtils.parseDate((String)response.getFirstHeader("Date").getValue());
            if (!entryDate.after(responseDate)) {
                return false;
            }
        }
        catch (DateParseException e) {
            return false;
        }
        return true;
    }

    private boolean entryAndResponseHaveDateHeader(CacheEntry entry, HttpResponse response) {
        return entry.getFirstHeader("Date") != null && response.getFirstHeader("Date") != null;
    }
}

