/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDNameTreeNode
implements COSObjectable {
    private COSDictionary node;
    private Class valueType = null;

    public PDNameTreeNode(Class valueClass) {
        this.node = new COSDictionary();
        this.valueType = valueClass;
    }

    public PDNameTreeNode(COSDictionary dict, Class valueClass) {
        this.node = dict;
        this.valueType = valueClass;
    }

    @Override
    public COSBase getCOSObject() {
        return this.node;
    }

    public COSDictionary getCOSDictionary() {
        return this.node;
    }

    public List getKids() {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.node.getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<PDNameTreeNode> pdObjects = new ArrayList<PDNameTreeNode>();
            for (int i = 0; i < kids.size(); ++i) {
                pdObjects.add(this.createChildNode((COSDictionary)kids.getObject(i)));
            }
            retval = new COSArrayList(pdObjects, kids);
        }
        return retval;
    }

    public void setKids(List kids) {
        if (kids != null && kids.size() > 0) {
            PDNameTreeNode firstKid = (PDNameTreeNode)kids.get(0);
            PDNameTreeNode lastKid = (PDNameTreeNode)kids.get(kids.size() - 1);
            String lowerLimit = firstKid.getLowerLimit();
            this.setLowerLimit(lowerLimit);
            String upperLimit = lastKid.getUpperLimit();
            this.setUpperLimit(upperLimit);
        }
        this.node.setItem("Kids", (COSBase)COSArrayList.converterToCOSArray(kids));
    }

    public Object getValue(String name) throws IOException {
        Object retval = null;
        Map<String, Object> names = this.getNames();
        if (names != null) {
            retval = names.get(name);
        } else {
            List kids = this.getKids();
            for (int i = 0; i < kids.size() && retval == null; ++i) {
                PDNameTreeNode childNode = (PDNameTreeNode)kids.get(i);
                if (childNode.getLowerLimit().compareTo(name) > 0 || childNode.getUpperLimit().compareTo(name) < 0) continue;
                retval = childNode.getValue(name);
            }
        }
        return retval;
    }

    public Map<String, Object> getNames() throws IOException {
        COSArray namesArray = (COSArray)this.node.getDictionaryObject(COSName.NAMES);
        if (namesArray != null) {
            LinkedHashMap<String, Object> names = new LinkedHashMap<String, Object>();
            for (int i = 0; i < namesArray.size(); i += 2) {
                COSString key = (COSString)namesArray.getObject(i);
                COSBase cosValue = namesArray.getObject(i + 1);
                names.put(key.getString(), this.convertCOSToPD(cosValue));
            }
            return Collections.unmodifiableMap(names);
        }
        return null;
    }

    protected Object convertCOSToPD(COSBase base) throws IOException {
        Object retval = null;
        try {
            Constructor ctor = this.valueType.getConstructor(base.getClass());
            retval = ctor.newInstance(base);
        }
        catch (Throwable t) {
            throw new IOException("Error while trying to create value in named tree:" + t.getMessage());
        }
        return retval;
    }

    protected PDNameTreeNode createChildNode(COSDictionary dic) {
        return new PDNameTreeNode(dic, this.valueType);
    }

    public void setNames(Map<String, ? extends COSObjectable> names) {
        if (names == null) {
            this.node.setItem("Names", (COSObjectable)null);
            this.node.setItem(COSName.LIMITS, (COSObjectable)null);
        } else {
            COSArray array = new COSArray();
            ArrayList<String> keys = new ArrayList<String>(names.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                array.add(new COSString(key));
                array.add(names.get(key));
            }
            this.setLowerLimit((String)keys.get(0));
            this.setUpperLimit((String)keys.get(keys.size() - 1));
            this.node.setItem("Names", (COSBase)array);
        }
    }

    public String getUpperLimit() {
        String retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr != null) {
            retval = arr.getString(1);
        }
        return retval;
    }

    private void setUpperLimit(String upper) {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr == null) {
            arr = new COSArray();
            arr.add(null);
            arr.add(null);
            this.node.setItem(COSName.LIMITS, (COSBase)arr);
        }
        arr.setString(1, upper);
    }

    public String getLowerLimit() {
        String retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr != null) {
            retval = arr.getString(0);
        }
        return retval;
    }

    private void setLowerLimit(String lower) {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr == null) {
            arr = new COSArray();
            arr.add(null);
            arr.add(null);
            this.node.setItem(COSName.LIMITS, (COSBase)arr);
        }
        arr.setString(0, lower);
    }
}

