/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.robot.dbflute.util.DfBase64Util;
import org.seasar.robot.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTypeUtil {
    private static final String NULL = "null";
    protected static Map<Locale, DecimalFormatSymbols> symbolsCache = new ConcurrentHashMap<Locale, DecimalFormatSymbols>();
    protected static final String[] EMPTY_STRINGS = new String[0];

    public static Boolean toBoolean(Object o) {
        if (o == null) {
            return (Boolean)o;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            int num = ((Number)o).intValue();
            return num != 0;
        }
        if (o instanceof String) {
            String s = (String)o;
            if ("true".equalsIgnoreCase(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s)) {
                return Boolean.FALSE;
            }
            if (s.equals("0")) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public static boolean toPrimitiveBoolean(Object o) {
        Boolean b = DfTypeUtil.toBoolean(o);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static Integer toInteger(Object o) {
        return DfTypeUtil.toInteger(o, null);
    }

    public static Integer toInteger(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toInteger((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return new Integer(new SimpleDateFormat(pattern).format(o));
            }
            return (int)((java.util.Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        return DfTypeUtil.toInteger(o.toString());
    }

    protected static Integer toInteger(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return new Integer(DfTypeUtil.normalize(s));
    }

    public static int toPrimitiveInt(Object o) {
        return DfTypeUtil.toPrimitiveInt(o, null);
    }

    public static int toPrimitiveInt(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toPrimitiveInt((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return Integer.parseInt(new SimpleDateFormat(pattern).format(o));
            }
            return (int)((java.util.Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return DfTypeUtil.toPrimitiveInt(o.toString());
    }

    protected static int toPrimitiveInt(String s) {
        if (s == null || s.trim().length() == 0) {
            return 0;
        }
        return Integer.parseInt(DfTypeUtil.normalize(s));
    }

    public static Long toLong(Object o) {
        return DfTypeUtil.toLong(o, null);
    }

    public static Long toLong(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toLong((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return new Long(new SimpleDateFormat(pattern).format(o));
            }
            return ((java.util.Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        return DfTypeUtil.toLong(o.toString());
    }

    protected static Long toLong(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return new Long(DfTypeUtil.normalize(s));
    }

    public static long toPrimitiveLong(Object o) {
        return DfTypeUtil.toPrimitiveLong(o, null);
    }

    public static long toPrimitiveLong(Object o, String pattern) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toPrimitiveLong((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return Long.parseLong(new SimpleDateFormat(pattern).format(o));
            }
            return ((java.util.Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        return DfTypeUtil.toPrimitiveLong(o.toString());
    }

    protected static long toPrimitiveLong(String s) {
        if (s == null || s.trim().length() == 0) {
            return 0L;
        }
        return Long.parseLong(DfTypeUtil.normalize(s));
    }

    public static BigDecimal toBigDecimal(Object o) {
        return DfTypeUtil.toBigDecimal(o, null);
    }

    public static BigDecimal toBigDecimal(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return new BigDecimal(new SimpleDateFormat(pattern).format(o));
            }
            return new BigDecimal(Long.toString(((java.util.Date)o).getTime()));
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s == null || s.trim().length() == 0) {
                return null;
            }
            return new BigDecimal(new BigDecimal(s).toPlainString());
        }
        return new BigDecimal(new BigDecimal(o.toString()).toPlainString());
    }

    public static Double toDouble(Object o) {
        return DfTypeUtil.toDouble(o, null);
    }

    public static Double toDouble(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        if (o instanceof String) {
            return DfTypeUtil.toDouble((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return new Double(new SimpleDateFormat(pattern).format(o));
            }
            return new Double(((java.util.Date)o).getTime());
        }
        return DfTypeUtil.toDouble(o.toString());
    }

    protected static Double toDouble(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return new Double(DfTypeUtil.normalize(s));
    }

    public static double toPrimitiveDouble(Object o) {
        return DfTypeUtil.toPrimitiveDouble(o, null);
    }

    public static double toPrimitiveDouble(Object o, String pattern) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toPrimitiveDouble((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return Double.parseDouble(new SimpleDateFormat(pattern).format(o));
            }
            return ((java.util.Date)o).getTime();
        }
        return DfTypeUtil.toPrimitiveDouble(o.toString());
    }

    private static double toPrimitiveDouble(String s) {
        if (DfStringUtil.isNullOrEmpty(s)) {
            return 0.0;
        }
        return Double.parseDouble(DfTypeUtil.normalize(s));
    }

    public static Float toFloat(Object o) {
        return DfTypeUtil.toFloat(o, null);
    }

    public static Float toFloat(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return new Float(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return DfTypeUtil.toFloat((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return new Float(new SimpleDateFormat(pattern).format(o));
            }
            return new Float(((java.util.Date)o).getTime());
        }
        return DfTypeUtil.toFloat(o.toString());
    }

    protected static Float toFloat(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return new Float(DfTypeUtil.normalize(s));
    }

    public static float toPrimitiveFloat(Object o) {
        return DfTypeUtil.toPrimitiveFloat(o, null);
    }

    public static float toPrimitiveFloat(Object o, String pattern) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toPrimitiveFloat((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return Float.parseFloat(new SimpleDateFormat(pattern).format(o));
            }
            return ((java.util.Date)o).getTime();
        }
        return DfTypeUtil.toPrimitiveFloat(o.toString());
    }

    private static float toPrimitiveFloat(String s) {
        if (DfStringUtil.isNullOrEmpty(s)) {
            return 0.0f;
        }
        return Float.parseFloat(DfTypeUtil.normalize(s));
    }

    public static Short toShort(Object o) {
        return DfTypeUtil.toShort(o, null);
    }

    public static Short toShort(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toShort((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return Short.valueOf(new SimpleDateFormat(pattern).format(o));
            }
            return (short)((java.util.Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        }
        return DfTypeUtil.toShort(o.toString());
    }

    protected static Short toShort(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return new Short(DfTypeUtil.normalize(s));
    }

    public static short toPrimitiveShort(Object o) {
        return DfTypeUtil.toPrimitiveShort(o, null);
    }

    public static short toPrimitiveShort(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toPrimitiveShort((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return Short.parseShort(new SimpleDateFormat(pattern).format(o));
            }
            return (short)((java.util.Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        return DfTypeUtil.toPrimitiveShort(o.toString());
    }

    private static short toPrimitiveShort(String s) {
        if (DfStringUtil.isNullOrEmpty(s)) {
            return 0;
        }
        return Short.parseShort(DfTypeUtil.normalize(s));
    }

    public static BigInteger toBigInteger(Object o) {
        return DfTypeUtil.toBigInteger(o, null);
    }

    public static BigInteger toBigInteger(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        Long l = DfTypeUtil.toLong(o, pattern);
        if (l == null) {
            return null;
        }
        return BigInteger.valueOf(l);
    }

    public static Byte toByte(Object o) {
        return DfTypeUtil.toByte(o, null);
    }

    public static Byte toByte(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toByte((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return new Byte(new SimpleDateFormat(pattern).format(o));
            }
            return (byte)((java.util.Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }
        return DfTypeUtil.toByte(o.toString());
    }

    protected static Byte toByte(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return new Byte(DfTypeUtil.normalize(s));
    }

    public static byte toPrimitiveByte(Object o) {
        return DfTypeUtil.toPrimitiveByte(o, null);
    }

    public static byte toPrimitiveByte(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof String) {
            return DfTypeUtil.toPrimitiveByte((String)o);
        }
        if (o instanceof java.util.Date) {
            if (pattern != null) {
                return Byte.parseByte(new SimpleDateFormat(pattern).format(o));
            }
            return (byte)((java.util.Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        return DfTypeUtil.toPrimitiveByte(o.toString());
    }

    private static byte toPrimitiveByte(String s) {
        if (DfStringUtil.isNullOrEmpty(s)) {
            return 0;
        }
        return Byte.parseByte(DfTypeUtil.normalize(s));
    }

    public static java.util.Date toDate(Object o) {
        return DfTypeUtil.toDate(o, null);
    }

    public static java.util.Date toDate(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return DfTypeUtil.toDate((String)o, pattern);
        }
        if (o instanceof java.util.Date) {
            return (java.util.Date)o;
        }
        if (o instanceof Calendar) {
            return ((Calendar)o).getTime();
        }
        return DfTypeUtil.toDate(o.toString(), pattern);
    }

    protected static java.util.Date toDate(String s, String pattern) {
        return DfTypeUtil.toDate(s, pattern, Locale.getDefault());
    }

    protected static java.util.Date toDate(String s, String pattern, Locale locale) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat sdf = DfTypeUtil.getDateFormat(s, pattern, locale);
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            String msg = "Failed to parse the string to date: ";
            msg = msg + " string=" + s + " pattern=" + pattern + " locale=" + locale;
            throw new ToDateParseException(msg, e);
        }
    }

    public static Date toSqlDate(Object o) {
        return DfTypeUtil.toSqlDate(o, null);
    }

    public static Date toSqlDate(Object o, String pattern) {
        java.util.Date date;
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        try {
            date = DfTypeUtil.toDate(o, pattern);
        }
        catch (ToDateParseException e) {
            String msg = "Failed to parse the string to date: ";
            msg = msg + " obj=" + o + " pattern=" + pattern;
            throw new ToSqlDateParseException(msg, e);
        }
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long time = cal.getTimeInMillis();
            return new Date(time);
        }
        return null;
    }

    public static String getDateY4Pattern(Locale locale) {
        String pattern = DfTypeUtil.getDatePattern(locale);
        if (pattern.indexOf("yyyy") < 0) {
            pattern = DfStringUtil.replace(pattern, "yy", "yyyy");
        }
        return pattern;
    }

    public static String getDatePattern(Locale locale) {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        String pattern = df.toPattern();
        int index = pattern.indexOf(32);
        if (index > 0) {
            pattern = pattern.substring(0, index);
        }
        if (pattern.indexOf("MM") < 0) {
            pattern = DfStringUtil.replace(pattern, "M", "MM");
        }
        if (pattern.indexOf("dd") < 0) {
            pattern = DfStringUtil.replace(pattern, "d", "dd");
        }
        return pattern;
    }

    public static java.util.Date toDateFlexibly(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof String)) {
            try {
                return DfTypeUtil.toDate(obj);
            }
            catch (ToDateParseException e) {
                String msg = "Failed to parse the string to date flexibly: ";
                msg = msg + " obj=" + obj;
                throw new ToDateFlexiblyParseException(msg, e);
            }
        }
        String value = (String)obj;
        if (value.trim().length() == 0) {
            return null;
        }
        String filtered = DfTypeUtil.filterDateStringValue(value);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(filtered);
        }
        catch (ParseException e) {
            String msg = "Failed to parse the string to date flexibly: ";
            msg = msg + " string=" + obj + " filtered=" + filtered;
            throw new ToDateFlexiblyParseException(msg, e);
        }
    }

    protected static String filterDateStringValue(String value) {
        if ((value = value.trim()).length() <= 8) {
            if (value.length() == 7) {
                value = "0" + value;
            } else if (value.length() == 6) {
                value = "00" + value;
            } else if (value.length() == 5) {
                value = "000" + value;
            } else if (value.length() <= 4) {
                return value;
            }
            String yyyy = value.substring(0, 4);
            String mm = value.substring(4, 6);
            String dd = value.substring(6, 8);
            value = yyyy + "-" + mm + "-" + dd;
        }
        if (value.indexOf("/") == 4 && value.lastIndexOf("/") == 7) {
            value = value.replaceAll("/", "-");
        }
        if (value.indexOf("-") == 4 && value.lastIndexOf("-") == 7 && value.length() == "2007-07-09".length()) {
            value = value + " 00:00:00";
        }
        return value;
    }

    public static String format(java.util.Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Timestamp toTimestamp(Object o) {
        return DfTypeUtil.toTimestamp(o, null);
    }

    public static Timestamp toTimestamp(Object o, String pattern) {
        java.util.Date date;
        if (o == null) {
            return null;
        }
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        try {
            date = DfTypeUtil.toDate(o, pattern);
        }
        catch (ToDateParseException e) {
            String msg = "Failed to parse the string to time-stamp: ";
            msg = msg + " obj=" + o + " pattern=" + pattern;
            throw new ToTimestampParseException(msg, e);
        }
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public static String getPattern(Locale locale) {
        return DfTypeUtil.getDateY4Pattern(locale) + " " + DfTypeUtil.getTimePattern(locale);
    }

    public static Timestamp toTimestampFlexibly(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof String)) {
            try {
                return DfTypeUtil.toTimestamp(obj);
            }
            catch (ToTimestampParseException e) {
                String msg = "Failed to parse the string to time-stamp flexibly: ";
                msg = msg + " obj=" + obj;
                throw new ToTimestampFlexiblyParseException(msg, e);
            }
        }
        String string = (String)obj;
        if (string.trim().length() == 0) {
            return null;
        }
        String filtered = DfTypeUtil.filterTimestampStringValue(string);
        try {
            return Timestamp.valueOf(filtered);
        }
        catch (Exception e) {
            String msg = "Failed to parse the string to time-stamp flexibly: ";
            msg = msg + " string=" + string + " filtered=" + filtered;
            throw new ToTimestampFlexiblyParseException(msg, e);
        }
    }

    protected static String filterTimestampStringValue(String value) {
        if ((value = value.trim()).length() <= 8) {
            if (value.length() == 7) {
                value = "0" + value;
            } else if (value.length() == 6) {
                value = "00" + value;
            } else if (value.length() == 5) {
                value = "000" + value;
            } else if (value.length() <= 4) {
                return value;
            }
            String yyyy = value.substring(0, 4);
            String mm = value.substring(4, 6);
            String dd = value.substring(6, 8);
            value = yyyy + "-" + mm + "-" + dd;
        }
        if (value.indexOf("/") == 4 && value.lastIndexOf("/") == 7) {
            value = value.replaceAll("/", "-");
        }
        if (value.indexOf("-") == 4 && value.lastIndexOf("-") == 7 && value.length() == "2007-07-09".length()) {
            value = value + " 00:00:00";
        }
        return value;
    }

    public static Time toTime(Object o) {
        return DfTypeUtil.toTime(o, null);
    }

    public static Time toTime(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return DfTypeUtil.toTime((String)o, pattern);
        }
        if (o instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)o;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            return new Time(cal.getTimeInMillis());
        }
        if (o instanceof Time) {
            return (Time)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            return new Time(cal.getTimeInMillis());
        }
        return DfTypeUtil.toTime(o.toString(), pattern);
    }

    protected static Time toTime(String s, String pattern) {
        return DfTypeUtil.toTime(s, pattern, Locale.getDefault());
    }

    protected static Time toTime(String s, String pattern, Locale locale) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat sdf = DfTypeUtil.getTimeDateFormat(s, pattern, locale);
        try {
            return new Time(sdf.parse(s).getTime());
        }
        catch (ParseException e) {
            String msg = "Failed to parse the string to time: ";
            msg = msg + " string=" + s + " pattern=" + pattern + " locale=" + locale;
            throw new ToTimeParseException(msg, e);
        }
    }

    public static SimpleDateFormat getTimeDateFormat(String s, String pattern, Locale locale) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern);
        }
        return DfTypeUtil.getTimeDateFormat(s, locale);
    }

    public static SimpleDateFormat getTimeDateFormat(String s, Locale locale) {
        String pattern = DfTypeUtil.getTimePattern(locale);
        if (s.length() == pattern.length()) {
            return new SimpleDateFormat(pattern);
        }
        String shortPattern = DfTypeUtil.convertTimeShortPattern(pattern);
        if (s.length() == shortPattern.length()) {
            return new SimpleDateFormat(shortPattern);
        }
        return new SimpleDateFormat(pattern);
    }

    public static String getTimePattern(Locale locale) {
        return "HH:mm:ss";
    }

    public static String convertTimeShortPattern(String pattern) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c != 'h' && c != 'H' && c != 'm' && c != 's') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static Object toNumber(Class<?> type, Object o) {
        if (type == Integer.class) {
            return DfTypeUtil.toInteger(o);
        }
        if (type == BigDecimal.class) {
            return DfTypeUtil.toBigDecimal(o);
        }
        if (type == Double.class) {
            return DfTypeUtil.toDouble(o);
        }
        if (type == Long.class) {
            return DfTypeUtil.toLong(o);
        }
        if (type == Float.class) {
            return DfTypeUtil.toFloat(o);
        }
        if (type == Short.class) {
            return DfTypeUtil.toShort(o);
        }
        if (type == BigInteger.class) {
            return DfTypeUtil.toBigInteger(o);
        }
        if (type == Byte.class) {
            return DfTypeUtil.toByte(o);
        }
        return o;
    }

    public static Object toWrapper(Class<?> type, Object o) {
        if (type == Integer.TYPE) {
            Integer i = DfTypeUtil.toInteger(o);
            if (i != null) {
                return i;
            }
            return 0;
        }
        if (type == Double.TYPE) {
            Double d = DfTypeUtil.toDouble(o);
            if (d != null) {
                return d;
            }
            return new Double(0.0);
        }
        if (type == Long.TYPE) {
            Long l = DfTypeUtil.toLong(o);
            if (l != null) {
                return l;
            }
            return 0L;
        }
        if (type == Float.TYPE) {
            Float f = DfTypeUtil.toFloat(o);
            if (f != null) {
                return f;
            }
            return new Float(0.0f);
        }
        if (type == Short.TYPE) {
            Short s = DfTypeUtil.toShort(o);
            if (s != null) {
                return s;
            }
            return (short)0;
        }
        if (type == Boolean.TYPE) {
            Boolean b = DfTypeUtil.toBoolean(o);
            if (b != null) {
                return b;
            }
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            Byte b = DfTypeUtil.toByte(o);
            if (b != null) {
                return b;
            }
            return (byte)0;
        }
        return o;
    }

    public static Object convertPrimitiveWrapper(Class<?> type, Object o) {
        if (type == Integer.TYPE) {
            Integer i = DfTypeUtil.toInteger(o);
            if (i != null) {
                return i;
            }
            return 0;
        }
        if (type == Double.TYPE) {
            Double d = DfTypeUtil.toDouble(o);
            if (d != null) {
                return d;
            }
            return new Double(0.0);
        }
        if (type == Long.TYPE) {
            Long l = DfTypeUtil.toLong(o);
            if (l != null) {
                return l;
            }
            return 0L;
        }
        if (type == Float.TYPE) {
            Float f = DfTypeUtil.toFloat(o);
            if (f != null) {
                return f;
            }
            return new Float(0.0f);
        }
        if (type == Short.TYPE) {
            Short s = DfTypeUtil.toShort(o);
            if (s != null) {
                return s;
            }
            return (short)0;
        }
        if (type == Boolean.TYPE) {
            Boolean b = DfTypeUtil.toBoolean(o);
            if (b != null) {
                return b;
            }
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            Byte b = DfTypeUtil.toByte(o);
            if (b != null) {
                return b;
            }
            return (byte)0;
        }
        return o;
    }

    public static Calendar toCalendar(Object o) {
        return DfTypeUtil.toCalendar(o, null);
    }

    public static Calendar toCalendar(Object o, String pattern) {
        if (o instanceof Calendar) {
            return (Calendar)o;
        }
        java.util.Date date = DfTypeUtil.toDate(o, pattern);
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        return null;
    }

    public static Calendar localize(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTimeInMillis(calendar.getTimeInMillis());
        return localCalendar;
    }

    public static byte[] toBinary(String o, String encoding) {
        if (o == null) {
            return null;
        }
        try {
            return o.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is invalid: encoding=" + encoding + " o=" + o;
            throw new IllegalStateException(msg);
        }
    }

    protected static String normalize(String s) {
        return DfTypeUtil.normalize(s, Locale.getDefault());
    }

    protected static String normalize(String s, Locale locale) {
        if (s == null) {
            return null;
        }
        DecimalFormatSymbols symbols = DfTypeUtil.getDecimalFormatSymbols(locale);
        char decimalSep = symbols.getDecimalSeparator();
        char groupingSep = symbols.getGroupingSeparator();
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == groupingSep) continue;
            if (c == decimalSep) {
                c = '.';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toString(Object value) {
        return DfTypeUtil.toString(value, null);
    }

    public static String toString(Object value, String pattern) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof java.util.Date) {
            return DfTypeUtil.toString((java.util.Date)value, pattern);
        }
        if (value instanceof Number) {
            return DfTypeUtil.toString((Number)value, pattern);
        }
        if (value instanceof byte[]) {
            return DfBase64Util.encode((byte[])value);
        }
        return value.toString();
    }

    public static String toString(Number value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return new DecimalFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static String toString(java.util.Date value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return new SimpleDateFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static String nullText() {
        return NULL;
    }

    public static String toText(Number value) {
        if (value == null) {
            return NULL;
        }
        return value.toString();
    }

    public static String toText(Boolean value) {
        if (value == null) {
            return NULL;
        }
        return DfTypeUtil.quote(value.toString());
    }

    public static String toText(String value) {
        if (value == null) {
            return NULL;
        }
        return DfTypeUtil.quote(value);
    }

    public static String toText(java.util.Date value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder buf = new StringBuilder();
        DfTypeUtil.addDate(buf, calendar);
        return DfTypeUtil.quote(buf.toString());
    }

    public static String toText(Time value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder buf = new StringBuilder();
        DfTypeUtil.addTime(buf, calendar);
        DfTypeUtil.addTimeDecimalPart(buf, calendar.get(14));
        return DfTypeUtil.quote(buf.toString());
    }

    public static String toText(Timestamp value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder buf = new StringBuilder(30);
        DfTypeUtil.addDate(buf, calendar);
        DfTypeUtil.addTime(buf, calendar);
        DfTypeUtil.addTimeDecimalPart(buf, value.getNanos());
        return DfTypeUtil.quote(buf.toString());
    }

    public static String toText(byte[] value) {
        if (value == null) {
            return NULL;
        }
        return DfTypeUtil.quote(value.getClass() + "(byteLength=" + Integer.toString(value.length) + ")");
    }

    public static String toText(Object value) {
        if (value == null) {
            return NULL;
        }
        return DfTypeUtil.quote(value.toString());
    }

    protected static void addDate(StringBuilder buf, Calendar calendar) {
        int year = calendar.get(1);
        buf.append(year);
        buf.append('-');
        int month = calendar.get(2) + 1;
        if (month < 10) {
            buf.append('0');
        }
        buf.append(month);
        buf.append('-');
        int date = calendar.get(5);
        if (date < 10) {
            buf.append('0');
        }
        buf.append(date);
    }

    protected static void addTime(StringBuilder buf, Calendar calendar) {
        int hour;
        if (buf.length() > 0) {
            buf.append(' ');
        }
        if ((hour = calendar.get(11)) < 10) {
            buf.append('0');
        }
        buf.append(hour);
        buf.append(':');
        int minute = calendar.get(12);
        if (minute < 10) {
            buf.append('0');
        }
        buf.append(minute);
        buf.append(':');
        int second = calendar.get(13);
        if (second < 10) {
            buf.append('0');
        }
        buf.append(second);
    }

    protected static void addTimeDecimalPart(StringBuilder buf, int decimalPart) {
        if (decimalPart == 0) {
            return;
        }
        if (buf.length() > 0) {
            buf.append('.');
        }
        buf.append(decimalPart);
    }

    protected static String quote(String text) {
        return "'" + text + "'";
    }

    protected static SimpleDateFormat getDateFormat(String s, String pattern, Locale locale) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern);
        }
        return DfTypeUtil.getDateFormat(s, locale);
    }

    protected static SimpleDateFormat getDateFormat(String s, Locale locale) {
        String pattern = DfTypeUtil.getDateFormatPattern(locale);
        String shortPattern = DfTypeUtil.removeDateDelimiter(pattern);
        String delimitor = DfTypeUtil.findDateDelimiter(s);
        if (delimitor == null) {
            if (s.length() == shortPattern.length()) {
                return new SimpleDateFormat(shortPattern);
            }
            if (s.length() == shortPattern.length() + 2) {
                return new SimpleDateFormat(DfTypeUtil.replace(shortPattern, "yy", "yyyy"));
            }
        } else {
            String[] array = DfTypeUtil.split(s, delimitor);
            for (int i = 0; i < array.length; ++i) {
                if (array[i].length() != 4) continue;
                pattern = DfTypeUtil.replace(pattern, "yy", "yyyy");
                break;
            }
            return new SimpleDateFormat(pattern);
        }
        return new SimpleDateFormat();
    }

    protected static String getDateFormatPattern(Locale locale) {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        String pattern = df.toPattern();
        int index = pattern.indexOf(32);
        if (index > 0) {
            pattern = pattern.substring(0, index);
        }
        if (pattern.indexOf("MM") < 0) {
            pattern = DfTypeUtil.replace(pattern, "M", "MM");
        }
        if (pattern.indexOf("dd") < 0) {
            pattern = DfTypeUtil.replace(pattern, "d", "dd");
        }
        return pattern;
    }

    protected static String removeDateDelimiter(String pattern) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c != 'y' && c != 'M' && c != 'd') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    protected static String findDateDelimiter(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c)) continue;
            return Character.toString(c);
        }
        return null;
    }

    protected static DecimalFormatSymbols getDecimalFormatSymbols() {
        return DfTypeUtil.getDecimalFormatSymbols(Locale.getDefault());
    }

    protected static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        DecimalFormatSymbols symbols = symbolsCache.get(locale);
        if (symbols == null) {
            symbols = new DecimalFormatSymbols(locale);
            symbolsCache.put(locale, symbols);
        }
        return symbols;
    }

    protected static String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                sb.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(text.substring(pos2, pos));
            sb.append(toText);
            pos2 = pos + fromText.length();
        }
        sb.append(text.substring(pos2));
        return sb.toString();
    }

    protected static String[] split(String str, String delimiter) {
        if (str == null || str.trim().length() == 0) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public static class ToTimeParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ToTimeParseException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ToTimestampFlexiblyParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ToTimestampFlexiblyParseException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ToTimestampParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ToTimestampParseException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ToDateFlexiblyParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ToDateFlexiblyParseException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ToSqlDateParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ToSqlDateParseException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ToDateParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ToDateParseException(String msg, ParseException e) {
            super(msg, e);
        }
    }
}

