/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfReflectionUtil {
    private static Map<Class<?>, Class<?>> wrapperToPrimitiveMap = new HashMap();
    private static Map<Class<?>, Class<?>> primitiveToWrapperMap = new HashMap();
    private static Map<String, Class<?>> primitiveClsssNameMap = new HashMap();
    private static final Method IS_BRIDGE_METHOD;
    private static final Method IS_SYNTHETIC_METHOD;

    private static Method getIsBridgeMethod() {
        try {
            return Method.class.getMethod("isBridge", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getIsSyntheticMethod() {
        try {
            return Method.class.getMethod("isSynthetic", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Class<?> forName(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            String msg = "The class was not found: class=" + className + " loader=" + loader;
            throw new IllegalStateException(msg, e);
        }
    }

    public static Object newInstance(Class<?> clazz) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            String msg = "Failed to instantiate the class: " + clazz;
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the class: " + clazz;
            throw new IllegalStateException(msg, e);
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?>[] argTypes) {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            String msg = "Such a method was not found:";
            msg = msg + " class=" + clazz + " argTypes=" + Arrays.asList(argTypes);
            throw new IllegalStateException(msg, e);
        }
    }

    public static Object newInstance(Constructor<?> constructor, Object[] args) {
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            String msg = "Failed to instantiate the class: " + constructor;
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the class: " + constructor;
            throw new IllegalStateException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "The InvocationTargetException occurred: " + constructor;
            throw new IllegalStateException(msg, e.getTargetException());
        }
    }

    public static boolean isAssignableFrom(Class<?> toClass, Class<?> fromClass) {
        if (toClass == Object.class && !fromClass.isPrimitive()) {
            return true;
        }
        if (toClass.isPrimitive()) {
            fromClass = DfReflectionUtil.getPrimitiveClassIfWrapper(fromClass);
        }
        return toClass.isAssignableFrom(fromClass);
    }

    public static Class<?> getPrimitiveClass(Class<?> clazz) {
        return wrapperToPrimitiveMap.get(clazz);
    }

    public static Class<?> getPrimitiveClassIfWrapper(Class<?> clazz) {
        Class<?> ret = DfReflectionUtil.getPrimitiveClass(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        return primitiveToWrapperMap.get(clazz);
    }

    public static Object getValue(Field field, Object target) {
        DfReflectionUtil.assertObjectNotNull("field", field);
        try {
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the field: field=" + field + " target=" + target;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void setValue(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the field: field=" + field + " target=" + target;
            throw new IllegalStateException(msg, e);
        }
    }

    public static boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    public static boolean isPublicField(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod);
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            String msg = "Not found the method in the class: ";
            msg = msg + " method=" + name + (parameterTypes != null ? Arrays.asList(parameterTypes) : "");
            msg = msg + " class=" + clazz;
            throw new IllegalStateException(msg, e);
        }
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            String msg = "The InvocationTargetException occurred: ";
            msg = msg + " method=" + method + " target=" + target;
            msg = msg + " args=" + (args != null ? Arrays.asList(args) : "");
            throw new IllegalStateException(msg, t);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the method:";
            msg = msg + " method =" + method;
            msg = msg + " args=" + (args != null ? Arrays.asList(args) : "");
            throw new IllegalStateException(msg, e);
        }
    }

    public static boolean isBridgeMethod(Method method) {
        if (IS_BRIDGE_METHOD == null) {
            return false;
        }
        return (Boolean)DfReflectionUtil.invoke(IS_BRIDGE_METHOD, method, null);
    }

    public static boolean isSyntheticMethod(Method method) {
        if (IS_SYNTHETIC_METHOD == null) {
            return false;
        }
        return (Boolean)DfReflectionUtil.invoke(IS_SYNTHETIC_METHOD, method, null);
    }

    public static boolean isPublic(int modifier) {
        return Modifier.isPublic(modifier);
    }

    public static boolean isStatic(int modifier) {
        return Modifier.isStatic(modifier);
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        primitiveToWrapperMap.put(Character.TYPE, Character.class);
        primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveToWrapperMap.put(Short.TYPE, Short.class);
        primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveToWrapperMap.put(Long.TYPE, Long.class);
        primitiveToWrapperMap.put(Double.TYPE, Double.class);
        primitiveToWrapperMap.put(Float.TYPE, Float.class);
        primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveClsssNameMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveClsssNameMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveClsssNameMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveClsssNameMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveClsssNameMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveClsssNameMap.put(Double.TYPE.getName(), Double.TYPE);
        primitiveClsssNameMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveClsssNameMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        IS_BRIDGE_METHOD = DfReflectionUtil.getIsBridgeMethod();
        IS_SYNTHETIC_METHOD = DfReflectionUtil.getIsSyntheticMethod();
    }
}

