/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.info.RelationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignInfo
implements RelationInfo {
    protected final String foreignPropertyName;
    protected final DBMeta localDBMeta;
    protected final DBMeta foreignDBMeta;
    protected final Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap;
    protected final Map<ColumnInfo, ColumnInfo> foreignLocalColumnInfoMap;
    protected final int relationNo;
    protected final boolean oneToOne;

    public ForeignInfo(String foreignPropertyName, DBMeta localDBMeta, DBMeta foreignDBMeta, Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap, int relationNo, boolean oneToOne) {
        this.assertObjectNotNull("foreignPropertyName", foreignPropertyName);
        this.assertObjectNotNull("localDBMeta", localDBMeta);
        this.assertObjectNotNull("foreignDBMeta", foreignDBMeta);
        this.assertObjectNotNull("localForeignColumnInfoMap", localForeignColumnInfoMap);
        this.foreignPropertyName = foreignPropertyName;
        this.localDBMeta = localDBMeta;
        this.foreignDBMeta = foreignDBMeta;
        this.localForeignColumnInfoMap = localForeignColumnInfoMap;
        Set<ColumnInfo> keySet = localForeignColumnInfoMap.keySet();
        this.foreignLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>();
        for (ColumnInfo key : keySet) {
            ColumnInfo value = localForeignColumnInfoMap.get(key);
            this.foreignLocalColumnInfoMap.put(value, key);
        }
        this.relationNo = relationNo;
        this.oneToOne = oneToOne;
    }

    public ColumnInfo findLocalByForeign(String foreignColumnDbName) {
        ColumnInfo keyColumnInfo = this.foreignDBMeta.findColumnInfo(foreignColumnDbName);
        ColumnInfo resultColumnInfo = this.foreignLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by foreignColumnDbName in foreignLocalColumnInfoMap:";
            msg = msg + " foreignColumnDbName=" + foreignColumnDbName + " foreignLocalColumnInfoMap=" + this.foreignLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public Method findSetter() {
        return this.findMethod(this.localDBMeta.getEntityType(), "set" + this.buildInitCapPropertyName(), new Class[]{List.class});
    }

    public Method findGetter() {
        return this.findMethod(this.localDBMeta.getEntityType(), "get" + this.buildInitCapPropertyName(), new Class[0]);
    }

    protected String buildInitCapPropertyName() {
        return this.initCap(this.foreignPropertyName);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getForeignPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getForeignDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalForeignColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return false;
    }

    protected String initCap(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this.foreignPropertyName.hashCode() + this.localDBMeta.hashCode() + this.foreignDBMeta.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ForeignInfo)) {
            return false;
        }
        ForeignInfo target = (ForeignInfo)obj;
        if (!this.foreignPropertyName.equals(target.getForeignPropertyName())) {
            return false;
        }
        if (!this.localDBMeta.equals(target.getLocalDBMeta())) {
            return false;
        }
        return this.foreignDBMeta.equals(target.getForeignDBMeta());
    }

    public String toString() {
        return this.localDBMeta.getTableDbName() + "." + this.foreignPropertyName + "->" + this.foreignDBMeta.getTableDbName();
    }

    public String getForeignPropertyName() {
        return this.foreignPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this.localDBMeta;
    }

    public DBMeta getForeignDBMeta() {
        return this.foreignDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalForeignColumnInfoMap() {
        return new LinkedHashMap<ColumnInfo, ColumnInfo>(this.localForeignColumnInfoMap);
    }

    public Map<ColumnInfo, ColumnInfo> getForeignLocalColumnInfoMap() {
        return new LinkedHashMap<ColumnInfo, ColumnInfo>(this.foreignLocalColumnInfoMap);
    }

    public int getRelationNo() {
        return this.relationNo;
    }

    @Override
    public boolean isOneToOne() {
        return this.oneToOne;
    }
}

