/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.h2.util.IOUtils;

public class DataReader {
    private static final EOFException EOF = new EOFException();
    private InputStream in;

    public DataReader(InputStream inputStream) {
        this.in = inputStream;
    }

    public byte read() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw EOF;
        }
        return (byte)n;
    }

    public int readVarInt() throws IOException {
        byte by = this.read();
        if (by >= 0) {
            return by;
        }
        int n = by & 0x7F;
        by = this.read();
        if (by >= 0) {
            return n | by << 7;
        }
        n |= (by & 0x7F) << 7;
        by = this.read();
        if (by >= 0) {
            return n | by << 14;
        }
        n |= (by & 0x7F) << 14;
        by = this.read();
        if (by >= 0) {
            return n | by << 21;
        }
        return n | (by & 0x7F) << 21 | this.read() << 28;
    }

    public long readVarLong() throws IOException {
        long l = this.read();
        if (l >= 0L) {
            return l;
        }
        l &= 0x7FL;
        int n = 7;
        while (true) {
            long l2 = this.read();
            l |= (l2 & 0x7FL) << n;
            if (l2 >= 0L) {
                return l;
            }
            n += 7;
        }
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = IOUtils.readFully(this.in, byArray, n, n2);
        if (n3 < n2) {
            throw EOF;
        }
    }

    public String readString() throws IOException {
        int n = this.readVarInt();
        return this.readString(n);
    }

    private String readString(int n) throws IOException {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.read() & 0xFF;
            cArray[i] = n2 < 128 ? (char)n2 : (n2 >= 224 ? (char)(((n2 & 0xF) << 12) + ((this.read() & 0x3F) << 6) + (this.read() & 0x3F)) : (char)(((n2 & 0x1F) << 6) + (this.read() & 0x3F)));
        }
        return new String(cArray);
    }
}

