/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause.subquery;

import java.io.Serializable;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

public class SubQueryIndentProcessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BEGIN_MARK_PREFIX = "--df:sqbegin#";
    public static final String END_MARK_PREFIX = "--df:sqend#";
    public static final String IDENTITY_TERMINAL = "--df:idterm#";

    public String resolveSubQueryBeginMark(String subQueryIdentity) {
        return END_MARK_PREFIX + subQueryIdentity + IDENTITY_TERMINAL;
    }

    public String resolveSubQueryEndMark(String subQueryIdentity) {
        return END_MARK_PREFIX + subQueryIdentity + IDENTITY_TERMINAL;
    }

    public String processSubQueryIndent(String sql, String preIndent, String originalSql) {
        String beginMarkPrefix = END_MARK_PREFIX;
        if (!sql.contains(END_MARK_PREFIX)) {
            return sql;
        }
        String[] lines = sql.split(this.ln());
        String endMarkPrefix = END_MARK_PREFIX;
        String identityTerminal = IDENTITY_TERMINAL;
        int terminalLength = IDENTITY_TERMINAL.length();
        StringBuilder mainSb = new StringBuilder();
        StringBuilder subSb = null;
        boolean throughBegin = false;
        boolean throughBeginFirst = false;
        String subQueryIdentity = null;
        String indent = null;
        for (String line : lines) {
            String clause;
            String msg;
            int terminalIndex;
            int markIndex;
            if (!throughBegin) {
                if (line.contains(END_MARK_PREFIX)) {
                    throughBegin = true;
                    subSb = new StringBuilder();
                    markIndex = line.indexOf(END_MARK_PREFIX);
                    terminalIndex = line.indexOf(IDENTITY_TERMINAL);
                    if (terminalIndex < 0) {
                        msg = "Identity terminal was not found at the begin line: [" + line + "]";
                        throw new SubQueryIndentFailureException(msg);
                    }
                    clause = line.substring(0, markIndex) + line.substring(terminalIndex + terminalLength);
                    subQueryIdentity = line.substring(markIndex + END_MARK_PREFIX.length(), terminalIndex);
                    subSb.append(clause);
                    indent = this.buildSpaceBar(markIndex - preIndent.length());
                    continue;
                }
                mainSb.append(line).append(this.ln());
                continue;
            }
            if (line.contains(END_MARK_PREFIX + subQueryIdentity)) {
                markIndex = line.indexOf(END_MARK_PREFIX);
                terminalIndex = line.indexOf(IDENTITY_TERMINAL);
                if (terminalIndex < 0) {
                    msg = "Identity terminal was not found at the begin line: [" + line + "]";
                    throw new SubQueryIndentFailureException(msg);
                }
                clause = line.substring(0, markIndex) + line.substring(terminalIndex + terminalLength);
                subSb.append(clause).append(this.ln());
                String currentSql = this.processSubQueryIndent(subSb.toString(), preIndent + indent, originalSql);
                mainSb.append(currentSql);
                throughBegin = false;
                throughBeginFirst = false;
                continue;
            }
            if (!throughBeginFirst) {
                subSb.append(line.trim()).append(this.ln());
                throughBeginFirst = true;
                continue;
            }
            subSb.append(indent).append(line).append(this.ln());
        }
        String filteredSql = mainSb.toString();
        if (throughBegin) {
            this.throwSubQueryNotFoundEndMarkException(subQueryIdentity, sql, filteredSql, originalSql);
        }
        if (filteredSql.contains(END_MARK_PREFIX)) {
            this.throwSubQueryAnyBeginMarkNotHandledException(subQueryIdentity, sql, filteredSql, originalSql);
        }
        return filteredSql;
    }

    protected void throwSubQueryNotFoundEndMarkException(String subQueryIdentity, String sql, String filteredSql, String originalSql) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the end mark for sub-query.");
        br.addItem("SubQueryIdentity");
        br.addElement(subQueryIdentity);
        br.addItem("Before Filter");
        br.addElement(sql);
        br.addItem("After Filter");
        br.addElement(filteredSql);
        br.addItem("Original SQL");
        br.addElement(originalSql);
        String msg = br.buildExceptionMessage();
        throw new SubQueryIndentFailureException(msg);
    }

    protected void throwSubQueryAnyBeginMarkNotHandledException(String subQueryIdentity, String sql, String filteredSql, String originalSql) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Any begin marks are not handled.");
        br.addItem("SubQueryIdentity");
        br.addElement(subQueryIdentity);
        br.addItem("Before Filter");
        br.addElement(sql);
        br.addItem("After Filter");
        br.addElement(filteredSql);
        br.addItem("Original SQL");
        br.addElement(originalSql);
        String msg = br.buildExceptionMessage();
        throw new SubQueryIndentFailureException(msg);
    }

    protected String buildSpaceBar(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    protected String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public static class SubQueryIndentFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SubQueryIndentFailureException(String msg) {
            super(msg);
        }
    }
}

