/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause.subquery;

import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryLevelReflector;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

public abstract class AbstractSubQuery {
    protected final SqlClause _sqlClause;
    protected final SubQueryPath _subQueryPath;
    protected final ColumnRealNameProvider _localRealNameProvider;
    protected final ColumnSqlNameProvider _subQuerySqlNameProvider;
    protected final int _subQueryLevel;
    protected final SqlClause _subQueryClause;
    protected final SubQueryLevelReflector _reflector;
    protected final String _subQueryIdentity;
    protected final DBMeta _subQueryDBMeta;

    public AbstractSubQuery(SqlClause sqlClause, SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQueryClause, SubQueryLevelReflector reflector, String subQueryIdentity, DBMeta subQueryDBMeta) {
        this._sqlClause = sqlClause;
        this._subQueryPath = subQueryPath;
        this._localRealNameProvider = localRealNameProvider;
        this._subQuerySqlNameProvider = subQuerySqlNameProvider;
        this._subQueryLevel = subQueryLevel;
        this._subQueryClause = subQueryClause;
        this._reflector = reflector;
        this._subQueryIdentity = subQueryIdentity;
        this._subQueryDBMeta = subQueryDBMeta;
    }

    protected String buildPlainFromWhereClause(String selectClause, String tableAliasName) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, tableAliasName);
        return clause.buildPlainSubQueryFromWhereClause();
    }

    protected String buildCorrelationFromWhereClause(String selectClause, String tableAliasName, ColumnSqlName relatedColumnSqlName, ColumnRealName correlatedColumnRealName) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, tableAliasName);
        return clause.buildCorrelationSubQueryFromWhereClause(relatedColumnSqlName, correlatedColumnRealName);
    }

    protected String buildCorrelationFromWhereClause(String selectClause, String tableAliasName, ColumnSqlName[] relatedColumnSqlNames, ColumnRealName[] correlatedColumnRealNames) {
        SubQueryClause clause = this.createSubQueryClause(selectClause, tableAliasName);
        return clause.buildCorrelationSubQueryFromWhereClause(relatedColumnSqlNames, correlatedColumnRealNames);
    }

    protected SubQueryClause createSubQueryClause(String selectClause, String tableAliasName) {
        return new SubQueryClause(this._sqlClause, this._subQueryPath, selectClause, this._subQueryClause, tableAliasName);
    }

    protected void reflectLocalSubQueryLevel() {
        this._reflector.reflect(this._subQueryLevel);
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected final String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected final String initCap(String str) {
        return Srl.initCap(str);
    }

    protected final String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected final String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

