/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.ckey;

import java.util.List;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.dbflute.cbean.sqlclause.query.StringQueryClause;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbway.ExtensionOperand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionKeyNotLikeSearch
extends ConditionKey {
    private static final long serialVersionUID = 1L;

    protected ConditionKeyNotLikeSearch() {
        this._conditionKey = "notLikeSearch";
        this._operand = "not like";
    }

    @Override
    public boolean isValidRegistration(ConditionValue conditionValue, Object value, String callerName) {
        return value != null;
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value) {
        throw new UnsupportedOperationException("doAddWhereClause without condition-option is unsupported!!!");
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value, ConditionOption option) {
        QueryClause clause;
        if (option == null) {
            String msg = "The argument 'option' should not be null:";
            msg = msg + " columnName=" + columnRealName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (!(option instanceof LikeSearchOption)) {
            String msg = "The argument 'option' should be LikeSearchOption:";
            msg = msg + " columnName=" + columnRealName + " value=" + value;
            msg = msg + " option=" + option;
            throw new IllegalArgumentException(msg);
        }
        String location = value.getNotLikeSearchLocation();
        LikeSearchOption myOption = (LikeSearchOption)option;
        String rearOption = myOption.getRearOption();
        ExtensionOperand extOperand = myOption.getExtensionOperand();
        String operand = extOperand != null ? extOperand.operand() : null;
        operand = operand == null || operand.trim().length() == 0 ? this.getOperand() : "not " + operand;
        QueryClauseArranger arranger = myOption.getWhereClauseArranger();
        if (arranger != null) {
            String bindExpression = this.buildBindExpression(location, null);
            String arranged = arranger.arrange(columnRealName, operand, bindExpression, rearOption);
            clause = new StringQueryClause(arranged);
        } else {
            clause = this.buildBindClause(columnRealName, operand, location, rearOption);
        }
        conditionList.add(clause);
    }

    @Override
    protected void doSetupConditionValue(ConditionValue conditionValue, Object value, String location) {
        throw new UnsupportedOperationException("doSetupConditionValue without condition-option is unsupported!!!");
    }

    @Override
    protected void doSetupConditionValue(ConditionValue conditionValue, Object value, String location, ConditionOption option) {
        conditionValue.setNotLikeSearch((String)value, (LikeSearchOption)option).setNotLikeSearchLocation(location);
    }
}

