/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import java.util.List;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.cbean.chelper.HpCalcStatement;
import org.seasar.dbflute.cbean.chelper.HpCalculator;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HpCalcSpecification<CB extends ConditionBean>
implements HpCalculator,
HpCalcStatement {
    protected final SpecifyQuery<CB> _specifyQuery;
    protected CB _cb;
    protected final List<HpCalculator.CalculationElement> _calculationList = DfCollectionUtil.newArrayList();

    public HpCalcSpecification(SpecifyQuery<CB> specifyQuery) {
        this._specifyQuery = specifyQuery;
    }

    public void specify(CB cb) {
        this._specifyQuery.specify(cb);
        this._cb = cb;
    }

    public ColumnInfo getSpecifiedColumnInfo() {
        return this._cb.getSqlClause().getSpecifiedColumnInfoAsOne();
    }

    public ColumnRealName getSpecifiedColumnRealName() {
        return this._cb.getSqlClause().getSpecifiedColumnRealNameAsOne();
    }

    public ColumnSqlName getSpecifiedColumnSqlName() {
        return this._cb.getSqlClause().getSpecifiedColumnSqlNameAsOne();
    }

    @Override
    public HpCalculator plus(Number plusValue) {
        return this.register(HpCalculator.CalculationType.PLUS, plusValue);
    }

    @Override
    public HpCalculator minus(Number minusValue) {
        return this.register(HpCalculator.CalculationType.MINUS, minusValue);
    }

    @Override
    public HpCalculator multiply(Number multiplyValue) {
        return this.register(HpCalculator.CalculationType.MULTIPLY, multiplyValue);
    }

    @Override
    public HpCalculator divide(Number divideValue) {
        return this.register(HpCalculator.CalculationType.DIVIDE, divideValue);
    }

    protected HpCalculator register(HpCalculator.CalculationType type, Number value) {
        if (value == null) {
            String msg = "The null value was specified as " + (Object)((Object)type) + ": " + this._specifyQuery;
            throw new IllegalArgumentException(msg);
        }
        HpCalculator.CalculationElement calculation = new HpCalculator.CalculationElement();
        calculation.setCalculationType(type);
        calculation.setCalculationValue(value);
        this._calculationList.add(calculation);
        return this;
    }

    @Override
    public String buildStatementAsSqlName() {
        return this.doBuildStatement(false);
    }

    @Override
    public String buildStatementAsRealName() {
        return this.doBuildStatement(true);
    }

    protected String doBuildStatement(boolean real) {
        String columnExp;
        if (real) {
            ColumnRealName columnRealName = this.getSpecifiedColumnRealName();
            columnExp = columnRealName.toString();
        } else {
            ColumnSqlName columnSqlName = this.getSpecifiedColumnSqlName();
            columnExp = columnSqlName.toString();
        }
        List<HpCalculator.CalculationElement> calculationList = this.getCalculationList();
        if (calculationList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(columnExp);
        int index = 0;
        for (HpCalculator.CalculationElement calculation : calculationList) {
            if (index > 0) {
                sb.insert(0, "(").append(")");
            }
            sb.append(" ").append(calculation.getCalculationType().operand());
            sb.append(" ").append(calculation.getCalculationValue());
            ++index;
        }
        return sb.toString();
    }

    public SpecifyQuery<CB> getSpecifyQuery() {
        return this._specifyQuery;
    }

    public List<HpCalculator.CalculationElement> getCalculationList() {
        return this._calculationList;
    }
}

