/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.resource.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutsideSqlCommand<RESULT>
extends AbstractBehaviorCommand<RESULT> {
    protected String _outsideSqlPath;
    protected Object _parameterBean;
    protected OutsideSqlOption _outsideSqlOption;
    protected DBDef _currentDBDef;

    @Override
    public boolean isConditionBean() {
        return false;
    }

    @Override
    public boolean isOutsideSql() {
        return true;
    }

    @Override
    public boolean isSelectCount() {
        return false;
    }

    @Override
    public ConditionBean getConditionBean() {
        return null;
    }

    @Override
    public String getOutsideSqlPath() {
        return this._outsideSqlPath;
    }

    @Override
    public OutsideSqlOption getOutsideSqlOption() {
        return this._outsideSqlOption;
    }

    protected OutsideSqlContext createOutsideSqlContext() {
        return new OutsideSqlContext(ResourceContext.dbmetaProvider(), ResourceContext.getOutsideSqlPackage());
    }

    protected String buildDbmsSuffix() {
        this.assertOutsideSqlBasic("buildDbmsSuffix");
        String productName = this._currentDBDef.code();
        return productName != null ? "_" + productName.toLowerCase() : "";
    }

    protected boolean isRemoveBlockComment(OutsideSqlContext context) {
        return context.isRemoveBlockComment() || this.needsToRemoveBlockComment();
    }

    protected boolean isRemoveLineComment(OutsideSqlContext context) {
        return context.isRemoveLineComment() || this.needsToRemoveLineComment();
    }

    protected boolean needsToRemoveBlockComment() {
        this.assertOutsideSqlBasic("isCurrentDBDef");
        return !this._currentDBDef.dbway().isBlockCommentSupported();
    }

    protected boolean needsToRemoveLineComment() {
        this.assertOutsideSqlBasic("isCurrentDBDef");
        return !this._currentDBDef.dbway().isLineCommentSupported();
    }

    protected void assertOutsideSqlBasic(String methodName) {
        if (this._outsideSqlPath == null) {
            throw new IllegalStateException(this.buildAssertMessage("_outsideSqlPath", methodName));
        }
        if (this._outsideSqlOption == null) {
            throw new IllegalStateException(this.buildAssertMessage("_outsideSqlOption", methodName));
        }
        if (this._currentDBDef == null) {
            throw new IllegalStateException(this.buildAssertMessage("_currentDBDef", methodName));
        }
    }

    public void setOutsideSqlPath(String outsideSqlPath) {
        this._outsideSqlPath = outsideSqlPath;
    }

    public void setParameterBean(Object parameterBean) {
        this._parameterBean = parameterBean;
    }

    public void setOutsideSqlOption(OutsideSqlOption outsideSqlOption) {
        this._outsideSqlOption = outsideSqlOption;
    }

    public void setCurrentDBDef(DBDef currentDBDef) {
        this._currentDBDef = currentDBDef;
    }
}

