/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.tartarus.snowball.SnowballProgram;

public class SnowballFilter
extends TokenFilter {
    private SnowballProgram stemmer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SnowballFilter(TokenStream input, SnowballProgram stemmer) {
        super(input);
        this.stemmer = stemmer;
    }

    public SnowballFilter(TokenStream in, String name) {
        super(in);
        try {
            Class<?> stemClass = Class.forName("org.tartarus.snowball.ext." + name + "Stemmer");
            this.stemmer = (SnowballProgram)stemClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public final Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        String originalTerm = nextToken.term();
        this.stemmer.setCurrent(originalTerm);
        this.stemmer.stem();
        String finalTerm = this.stemmer.getCurrent();
        if (!originalTerm.equals(finalTerm)) {
            nextToken.setTermBuffer(finalTerm);
        }
        return nextToken;
    }

    static {
        $assertionsDisabled = !SnowballFilter.class.desiredAssertionStatus();
    }
}

