/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.ejb.tx;

import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.ApplicationException;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.extension.tx.DefaultTransactionCallback;
import org.seasar.extension.tx.TransactionManagerAdapter;

public class EJB3TransactionCallback
extends DefaultTransactionCallback {
    public EJB3TransactionCallback(MethodInvocation methodInvocation, List txRules) {
        super(methodInvocation, txRules);
    }

    protected void applyTxRule(TransactionManagerAdapter adapter, Throwable t) {
        if (EJB3TransactionCallback.isRollingBack(t)) {
            adapter.setRollbackOnly();
            return;
        }
        super.applyTxRule(adapter, t);
    }

    protected static boolean isRollingBack(Throwable throwable) {
        Class<?> exceptionClass = throwable.getClass();
        ApplicationException annotation = exceptionClass.getAnnotation(ApplicationException.class);
        if (annotation != null) {
            return annotation.rollback();
        }
        if (throwable instanceof RemoteException) {
            return true;
        }
        if (throwable instanceof RuntimeException) {
            return true;
        }
        return !(throwable instanceof Exception);
    }
}

