/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.MethodUtil;

public class HotAwareDelegateInterceptor
implements MethodInterceptor {
    private static final long serialVersionUID = 1L;
    protected S2Container container;
    protected String targetName;

    public void setContainer(S2Container container) {
        this.container = container.getRoot();
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.targetName == null) {
            throw new EmptyRuntimeException("targetName");
        }
        Method method = invocation.getMethod();
        if (!MethodUtil.isAbstract(method)) {
            return invocation.proceed();
        }
        Object target = this.container.getComponent(this.targetName);
        return MethodUtil.invoke(method, target, invocation.getArguments());
    }
}

