/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.util.Collections;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestResult;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClassRunner;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethodTest {
    @Test
    public void testFailures() throws Exception {
        List<Throwable> problems = this.validateAllMethods(EverythingWrong.class);
        int errorCount = 21;
        Assert.assertEquals(errorCount, problems.size());
    }

    @Test
    public void validateInheritedMethods() throws Exception {
        List<Throwable> problems = this.validateAllMethods(SubWrong.class);
        Assert.assertEquals(1, problems.size());
    }

    @Test
    public void dontValidateShadowedMethods() throws Exception {
        List<Throwable> problems = this.validateAllMethods(SubShadows.class);
        Assert.assertTrue(problems.isEmpty());
    }

    private List<Throwable> validateAllMethods(Class<?> clazz) {
        try {
            new TestClassRunner(clazz);
        }
        catch (InitializationError e) {
            return e.getCauses();
        }
        return Collections.emptyList();
    }

    @Test
    public void ignoreRunner() {
        JUnitCore runner = new JUnitCore();
        Result result = runner.run(IgnoredTest.class);
        Assert.assertEquals(2, result.getIgnoreCount());
    }

    @Test
    public void compatibility() {
        TestResult result = new TestResult();
        new JUnit4TestAdapter(IgnoredTest.class).run(result);
        Assert.assertEquals(1, result.runCount());
    }

    @Test
    public void overloaded() {
        MethodValidator validator = new MethodValidator(Confused.class);
        List<Throwable> errors = validator.validateMethodsForDefaultRunner();
        Assert.assertEquals(1, errors.size());
    }

    @Test
    public void onlyIgnoredMethodsIsStillFineTestClass() {
        Result result = JUnitCore.runClasses(OnlyTestIsIgnored.class);
        Assert.assertEquals(0, result.getFailureCount());
        Assert.assertEquals(1, result.getIgnoreCount());
    }

    public static class OnlyTestIsIgnored {
        @Ignore
        @Test
        public void ignored() {
        }
    }

    public static class Confused {
        @Test
        public void a(Object b) {
        }

        @Test
        public void a() {
        }
    }

    public static class IgnoredTest {
        @Test
        public void valid() {
        }

        @Ignore
        @Test
        public void ignored() {
        }

        @Ignore(value="For testing purposes")
        @Test
        public void withReason() {
        }
    }

    public static class SubShadows
    extends SuperWrong {
        @Test
        public void notPublic() {
        }
    }

    public static class SubWrong
    extends SuperWrong {
        @Test
        public void justFine() {
        }
    }

    public static class SuperWrong {
        @Test
        void notPublic() {
        }
    }

    public static class EverythingWrong {
        private EverythingWrong() {
        }

        @BeforeClass
        public void notStaticBC() {
        }

        @BeforeClass
        static void notPublicBC() {
        }

        @BeforeClass
        public static int nonVoidBC() {
            return 0;
        }

        @BeforeClass
        public static void argumentsBC(int i) {
        }

        @BeforeClass
        public static void fineBC() {
        }

        @AfterClass
        public void notStaticAC() {
        }

        @AfterClass
        static void notPublicAC() {
        }

        @AfterClass
        public static int nonVoidAC() {
            return 0;
        }

        @AfterClass
        public static void argumentsAC(int i) {
        }

        @AfterClass
        public static void fineAC() {
        }

        @After
        public static void staticA() {
        }

        @After
        void notPublicA() {
        }

        @After
        public int nonVoidA() {
            return 0;
        }

        @After
        public void argumentsA(int i) {
        }

        @After
        public void fineA() {
        }

        @Before
        public static void staticB() {
        }

        @Before
        void notPublicB() {
        }

        @Before
        public int nonVoidB() {
            return 0;
        }

        @Before
        public void argumentsB(int i) {
        }

        @Before
        public void fineB() {
        }

        @Test
        public static void staticT() {
        }

        @Test
        void notPublicT() {
        }

        @Test
        public int nonVoidT() {
            return 0;
        }

        @Test
        public void argumentsT(int i) {
        }

        @Test
        public void fineT() {
        }
    }
}

